/*
 * Decompiled with CFR 0.152.
 */
package com.ib.controller;

import com.ib.client.Types;
import com.ib.controller.Alias;
import com.ib.controller.Group;
import com.ib.controller.Profile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public class AdvisorUtil {
    static ArrayList<Group> getGroups(String xml) {
        try {
            return AdvisorUtil.getGroups_(xml);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static ArrayList<Group> getGroups_(String xml) throws IOException {
        String line;
        ArrayList<Group> list = new ArrayList<Group>();
        Group group = null;
        BufferedReader reader = new BufferedReader(new StringReader(xml));
        int state = 0;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            switch (state) {
                case 0: {
                    if (!line.equals("<ListOfGroups>")) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (line.equals("<Group>")) {
                        group = new Group();
                        state = 2;
                        break;
                    }
                    if (line.equals("</ListOfGroups>")) {
                        state = 0;
                        break;
                    }
                    AdvisorUtil.err(line);
                    break;
                }
                case 2: {
                    if (line.startsWith("<name>")) {
                        group.name(AdvisorUtil.getVal(line));
                        break;
                    }
                    if (line.startsWith("<defaultMethod>")) {
                        group.defaultMethod(Types.Method.valueOf(AdvisorUtil.getVal(line)));
                        break;
                    }
                    if (line.startsWith("<ListOfAccts")) {
                        state = 3;
                        break;
                    }
                    if (line.equals("</Group>")) {
                        list.add(group);
                        state = 1;
                        break;
                    }
                    AdvisorUtil.err(line);
                    break;
                }
                case 3: {
                    if (line.equals("</ListOfAccts>")) {
                        state = 2;
                        break;
                    }
                    group.addAccount(AdvisorUtil.getVal(line));
                }
            }
        }
        return list;
    }

    static ArrayList<Profile> getProfiles(String xml) {
        try {
            return AdvisorUtil.getProfiles_(xml);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static ArrayList<Profile> getProfiles_(String xml) throws IOException {
        String line;
        ArrayList<Profile> list = new ArrayList<Profile>();
        Profile profile = null;
        Profile.Allocation alloc = null;
        BufferedReader reader = new BufferedReader(new StringReader(xml));
        int state = 0;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            switch (state) {
                case 0: {
                    if (!line.equals("<ListOfAllocationProfiles>")) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (line.equals("<AllocationProfile>")) {
                        profile = new Profile();
                        state = 2;
                        break;
                    }
                    if (line.equals("</ListOfAllocationProfiles>")) {
                        state = 0;
                        break;
                    }
                    AdvisorUtil.err(line);
                    break;
                }
                case 2: {
                    if (line.startsWith("<name>")) {
                        profile.name(AdvisorUtil.getVal(line));
                        break;
                    }
                    if (line.startsWith("<type>")) {
                        int i = Integer.parseInt(AdvisorUtil.getVal(line));
                        profile.type(Profile.Type.get(i));
                        break;
                    }
                    if (line.startsWith("<ListOfAllocations")) {
                        state = 3;
                        break;
                    }
                    if (line.equals("</AllocationProfile>")) {
                        list.add(profile);
                        state = 1;
                        break;
                    }
                    AdvisorUtil.err(line);
                    break;
                }
                case 3: {
                    if (line.equals("<Allocation>")) {
                        alloc = new Profile.Allocation();
                        state = 4;
                        break;
                    }
                    if (line.equals("</ListOfAllocations>")) {
                        state = 2;
                        break;
                    }
                    AdvisorUtil.err(line);
                    break;
                }
                case 4: {
                    if (line.startsWith("<acct>")) {
                        alloc.account(AdvisorUtil.getVal(line));
                        break;
                    }
                    if (line.startsWith("<amount>")) {
                        alloc.amount(AdvisorUtil.getVal(line));
                        break;
                    }
                    if (line.startsWith("<posEff>")) break;
                    if (line.equals("</Allocation>")) {
                        profile.add(alloc);
                        state = 3;
                        break;
                    }
                    AdvisorUtil.err(line);
                }
            }
        }
        return list;
    }

    static ArrayList<Alias> getAliases(String xml) {
        try {
            return AdvisorUtil.getAliases_(xml);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static ArrayList<Alias> getAliases_(String xml) throws IOException {
        String line;
        ArrayList<Alias> list = new ArrayList<Alias>();
        Alias alias = null;
        BufferedReader reader = new BufferedReader(new StringReader(xml));
        int state = 0;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            switch (state) {
                case 0: {
                    if (!line.equals("<ListOfAccountAliases>")) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (line.equals("<AccountAlias>")) {
                        alias = new Alias();
                        state = 2;
                        break;
                    }
                    if (line.equals("</ListOfAccountAliases>")) {
                        state = 0;
                        break;
                    }
                    AdvisorUtil.err(line);
                    break;
                }
                case 2: {
                    if (line.startsWith("<account>")) {
                        alias.account(AdvisorUtil.getVal(line));
                        break;
                    }
                    if (line.startsWith("<alias>")) {
                        alias.alias(AdvisorUtil.getVal(line));
                        break;
                    }
                    if (line.equals("</AccountAlias>")) {
                        list.add(alias);
                        state = 1;
                        break;
                    }
                    AdvisorUtil.err(line);
                }
            }
        }
        return list;
    }

    private static String getVal(String line) {
        int i1 = line.indexOf(62);
        int i2 = line.indexOf(60, 1);
        return line.substring(i1 + 1, i2);
    }

    private static void err(String line) {
        System.out.println("error " + line);
    }

    public static void main(String[] args) {
        String str1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ListOfGroups>\n\t<Group>\n\t\t<name>Group 1</name>\n\t\t<ListOfAccts varName=\"list\">\n\t\t\t<String>DU109949</String>\n\t\t\t<String>DU109950</String>\n\t\t\t<String>DU110a156</String>\n\t\t\t<String>DU110157</String>\n\t\t\t<String>DU110158</String>\n\t\t</ListOfAccts>\n\t\t<defaultMethod>AvailableEquity</defaultMethod>\n\t</Group>\n\t<Group>\n\t\t<name>Group 2</name>\n\t\t<ListOfAccts varName=\"list\">\n\t\t\t<String>DU109950</String>\n\t\t\t<String>DU110156</String>\n\t\t\t<String>DU110157</String>\n\t\t</ListOfAccts>\n\t\t<defaultMethod>AvailableEquity</defaultMethod>\n\t</Group>\n</ListOfGroups>\n";
        ArrayList<Group> groups = AdvisorUtil.getGroups(str1);
        String str2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ListOfAllocationProfiles>\n\t<AllocationProfile>\n\t\t<name>High Risk</name>\n\t\t<type>1</type>\n\t\t<ListOfAllocations varName=\"listOfAllocations\">\n\t\t\t<Allocation>\n\t\t\t\t<acct>DU110157</acct>\n\t\t\t\t<amount>90.0</amount>\n\t\t\t\t<posEff>O</posEff>\n\t\t\t</Allocation>\n\t\t\t<Allocation>\n\t\t\t\t<acct>DU110158</acct>\n\t\t\t\t<amount>10.0</amount>\n\t\t\t\t<posEff>O</posEff>\n\t\t\t</Allocation>\n\t\t</ListOfAllocations>\n\t</AllocationProfile>\n\t<AllocationProfile>\n\t\t<name>Profile</name>\n\t\t<type>2</type>\n\t\t<ListOfAllocations varName=\"listOfAllocations\">\n\t\t\t<Allocation>\n\t\t\t\t<acct>DU109949</acct>\n\t\t\t\t<amount>1.0</amount>\n\t\t\t\t<posEff>O</posEff>\n\t\t\t</Allocation>\n\t\t</ListOfAllocations>\n\t</AllocationProfile>\n</ListOfAllocationProfiles>\n";
        ArrayList<Profile> profiles = AdvisorUtil.getProfiles(str2);
        String str3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ListOfAccountAliases>\n\t<AccountAlias>\n\t\t<account>DF109948</account>\n\t\t<alias>DF109948</alias>\n\t</AccountAlias>\n\t<AccountAlias>\n\t\t<account>DU109949</account>\n\t\t<alias>DU109949</alias>\n\t</AccountAlias>\n\t<AccountAlias>\n\t\t<account>DU109950</account>\n\t\t<alias>DU109950</alias>\n\t</AccountAlias>\n\t<AccountAlias>\n\t\t<account>DU110156</account>\n\t\t<alias>DU110156</alias>\n\t</AccountAlias>\n\t<AccountAlias>\n\t\t<account>DU110157</account>\n\t\t<alias>DU110157</alias>\n\t</AccountAlias>\n\t<AccountAlias>\n\t\t<account>DU110158</account>\n\t\t<alias>DU110158</alias>\n\t</AccountAlias>\n</ListOfAccountAliases>\n\n";
        ArrayList<Alias> aliases = AdvisorUtil.getAliases(str3);
        AdvisorUtil.err(aliases.toString());
    }

    public static String getGroupsXml(ArrayList<Group> groups) {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<ListOfGroups>\n");
        for (Group group : groups) {
            buf.append("<Group>\n");
            buf.append(String.format("<name>%s</name>\n", group.name()));
            buf.append(String.format("<defaultMethod>%s</defaultMethod>\n", group.defaultMethod()));
            buf.append("<ListOfAccts varName=\"list\"\n>");
            for (String acct : group.accounts()) {
                buf.append(String.format("<String>%s</String>\n", acct));
            }
            buf.append("</ListOfAccts>\n");
            buf.append("</Group>\n");
        }
        buf.append("</ListOfGroups>\n");
        return buf.toString();
    }

    public static String getProfilesXml(ArrayList<Profile> profiles) {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<ListOfProfiles>\n");
        for (Profile profile : profiles) {
            buf.append("<Profile>\n");
            buf.append(String.format("<name>%s</name>\n", profile.name()));
            buf.append(String.format("<type>%s</type>\n", profile.type().ordinal()));
            buf.append("<ListOfAllocations varName=\"listOfAllocations\">\n");
            for (Profile.Allocation alloc : profile.allocations()) {
                buf.append("<Allocation>\n");
                buf.append(String.format("<acct>%s</acct>\n", alloc.account()));
                buf.append(String.format("<amount>%s</amount>\n", alloc.amount()));
                buf.append("</Allocation>\n");
            }
            buf.append("</ListOfAllocations>\n");
            buf.append("</Profile>\n");
        }
        buf.append("</ListOfProfiles>\n");
        return buf.toString();
    }
}

