/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.EClientSocket;
import com.ib.client.EReaderSignal;
import com.ib.client.EWrapper;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class EClientSocketSSL
extends EClientSocket {
    public EClientSocketSSL(EWrapper eWrapper, EReaderSignal signal) {
        super(eWrapper, signal);
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            SSLContext.setDefault(ctx);
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void eConnect(String host, int port, int clientId, boolean extraAuth) {
        this.m_host = this.checkConnected(host);
        this.m_clientId = clientId;
        this.m_extraAuth = extraAuth;
        this.m_redirectCount = 0;
        if (this.m_host == null) {
            return;
        }
        try {
            SSLSocket socket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(this.m_host, port);
            this.eConnect(socket);
        }
        catch (Exception e) {
            this.eDisconnect();
            this.wrapper().error(e);
        }
    }

    @Override
    protected void performRedirect(String address, int defaultPort) throws IOException {
        int newPort;
        System.out.println("Server Redirect: " + address);
        String[] array = address.split(":");
        this.m_host = array[0];
        try {
            newPort = array.length > 1 ? Integer.parseInt(array[1]) : defaultPort;
        }
        catch (NumberFormatException e) {
            System.out.println("Warning: redirect port is invalid, using default port");
            newPort = defaultPort;
        }
        this.eConnect((SSLSocket)SSLSocketFactory.getDefault().createSocket(this.m_host, newPort));
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

