/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.ComboLeg;
import com.ib.client.DeltaNeutralContract;
import com.ib.client.Types;
import com.ib.client.Util;
import java.util.ArrayList;

public class Contract
implements Cloneable {
    private int m_conid;
    private String m_symbol;
    private String m_secType;
    private String m_lastTradedateOrContractMonth;
    private double m_strike;
    private String m_right;
    private String m_multiplier;
    private String m_exchange;
    private String m_primaryExch;
    private String m_currency;
    private String m_localSymbol;
    private String m_tradingClass;
    private String m_secIdType;
    private String m_secId;
    private DeltaNeutralContract m_underComp;
    private boolean m_includeExpired;
    private String m_comboLegsDescrip;
    private ArrayList<ComboLeg> m_comboLegs = new ArrayList();

    public double strike() {
        return this.m_strike;
    }

    public int conid() {
        return this.m_conid;
    }

    public Types.SecIdType secIdType() {
        return Types.SecIdType.get(this.m_secIdType);
    }

    public String getSecIdType() {
        return this.m_secIdType;
    }

    public Types.SecType secType() {
        return Types.SecType.get(this.m_secType);
    }

    public String getSecType() {
        return this.m_secType;
    }

    public String currency() {
        return this.m_currency;
    }

    public String exchange() {
        return this.m_exchange;
    }

    public String primaryExch() {
        return this.m_primaryExch;
    }

    public String lastTradeDateOrContractMonth() {
        return this.m_lastTradedateOrContractMonth;
    }

    public String localSymbol() {
        return this.m_localSymbol;
    }

    public String tradingClass() {
        return this.m_tradingClass;
    }

    public String multiplier() {
        return this.m_multiplier;
    }

    public Types.Right right() {
        return Types.Right.get(this.m_right);
    }

    public String getRight() {
        return this.m_right;
    }

    public String secId() {
        return this.m_secId;
    }

    public String symbol() {
        return this.m_symbol;
    }

    public boolean includeExpired() {
        return this.m_includeExpired;
    }

    public DeltaNeutralContract underComp() {
        return this.m_underComp;
    }

    public ArrayList<ComboLeg> comboLegs() {
        return this.m_comboLegs;
    }

    public String comboLegsDescrip() {
        return this.m_comboLegsDescrip;
    }

    public void conid(int v) {
        this.m_conid = v;
    }

    public void currency(String v) {
        this.m_currency = v;
    }

    public void exchange(String v) {
        this.m_exchange = v;
    }

    public void lastTradeDateOrContractMonth(String v) {
        this.m_lastTradedateOrContractMonth = v;
    }

    public void localSymbol(String v) {
        this.m_localSymbol = v;
    }

    public void tradingClass(String v) {
        this.m_tradingClass = v;
    }

    public void multiplier(String v) {
        this.m_multiplier = v;
    }

    public void primaryExch(String v) {
        this.m_primaryExch = v;
    }

    public void right(Types.Right v) {
        this.m_right = v == null ? null : v.getApiString();
    }

    public void right(String v) {
        this.m_right = v;
    }

    public void secId(String v) {
        this.m_secId = v;
    }

    public void secIdType(Types.SecIdType v) {
        this.m_secIdType = v == null ? null : v.getApiString();
    }

    public void secIdType(String v) {
        this.m_secIdType = v;
    }

    public void secType(Types.SecType v) {
        this.m_secType = v == null ? null : v.getApiString();
    }

    public void secType(String v) {
        this.m_secType = v;
    }

    public void strike(double v) {
        this.m_strike = v;
    }

    public void symbol(String v) {
        this.m_symbol = v;
    }

    public void underComp(DeltaNeutralContract v) {
        this.m_underComp = v;
    }

    public void includeExpired(boolean v) {
        this.m_includeExpired = v;
    }

    public void comboLegs(ArrayList<ComboLeg> v) {
        this.m_comboLegs = v;
    }

    public void comboLegsDescrip(String v) {
        this.m_comboLegsDescrip = v;
    }

    public Contract() {
        this.m_conid = 0;
        this.m_strike = 0.0;
        this.m_includeExpired = false;
    }

    public Contract clone() {
        try {
            Contract copy = (Contract)super.clone();
            copy.m_comboLegs = copy.m_comboLegs != null ? new ArrayList<ComboLeg>(copy.m_comboLegs) : new ArrayList();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Contract(int p_conId, String p_symbol, String p_secType, String p_lastTradeDateOrContractMonth, double p_strike, String p_right, String p_multiplier, String p_exchange, String p_currency, String p_localSymbol, String p_tradingClass, ArrayList<ComboLeg> p_comboLegs, String p_primaryExch, boolean p_includeExpired, String p_secIdType, String p_secId) {
        this.m_conid = p_conId;
        this.m_symbol = p_symbol;
        this.m_secType = p_secType;
        this.m_lastTradedateOrContractMonth = p_lastTradeDateOrContractMonth;
        this.m_strike = p_strike;
        this.m_right = p_right;
        this.m_multiplier = p_multiplier;
        this.m_exchange = p_exchange;
        this.m_currency = p_currency;
        this.m_includeExpired = p_includeExpired;
        this.m_localSymbol = p_localSymbol;
        this.m_tradingClass = p_tradingClass;
        this.m_comboLegs = p_comboLegs;
        this.m_primaryExch = p_primaryExch;
        this.m_secIdType = p_secIdType;
        this.m_secId = p_secId;
    }

    public boolean equals(Object p_other) {
        if (this == p_other) {
            return true;
        }
        if (p_other == null || !(p_other instanceof Contract)) {
            return false;
        }
        Contract l_theOther = (Contract)p_other;
        if (this.m_conid != l_theOther.m_conid) {
            return false;
        }
        if (Util.StringCompare(this.m_secType, l_theOther.m_secType) != 0) {
            return false;
        }
        if (Util.StringCompare(this.m_symbol, l_theOther.m_symbol) != 0 || Util.StringCompare(this.m_exchange, l_theOther.m_exchange) != 0 || Util.StringCompare(this.m_primaryExch, l_theOther.m_primaryExch) != 0 || Util.StringCompare(this.m_currency, l_theOther.m_currency) != 0) {
            return false;
        }
        if (!Util.NormalizeString(this.m_secType).equals("BOND")) {
            if (this.m_strike != l_theOther.m_strike) {
                return false;
            }
            if (Util.StringCompare(this.m_lastTradedateOrContractMonth, l_theOther.m_lastTradedateOrContractMonth) != 0 || Util.StringCompare(this.m_right, l_theOther.m_right) != 0 || Util.StringCompare(this.m_multiplier, l_theOther.m_multiplier) != 0 || Util.StringCompare(this.m_localSymbol, l_theOther.m_localSymbol) != 0 || Util.StringCompare(this.m_tradingClass, l_theOther.m_tradingClass) != 0) {
                return false;
            }
        }
        if (Util.StringCompare(this.m_secIdType, l_theOther.m_secIdType) != 0) {
            return false;
        }
        if (Util.StringCompare(this.m_secId, l_theOther.m_secId) != 0) {
            return false;
        }
        if (!Util.ArrayEqualsUnordered(this.m_comboLegs, l_theOther.m_comboLegs)) {
            return false;
        }
        if (this.m_underComp != l_theOther.m_underComp) {
            if (this.m_underComp == null || l_theOther.m_underComp == null) {
                return false;
            }
            if (!this.m_underComp.equals(l_theOther.m_underComp)) {
                return false;
            }
        }
        return true;
    }

    public String description() {
        StringBuilder sb = new StringBuilder();
        if (this.isCombo()) {
            int i = 0;
            for (ComboLeg leg : this.m_comboLegs) {
                if (i++ > 0) {
                    sb.append("/");
                }
                sb.append(leg.toString());
            }
        } else {
            sb.append(this.m_symbol);
            Contract.app(sb, this.m_secType);
            Contract.app(sb, this.m_exchange);
            if (this.m_exchange != null && this.m_exchange.equals("SMART") && this.m_primaryExch != null) {
                Contract.app(sb, this.m_primaryExch);
            }
            Contract.app(sb, this.m_lastTradedateOrContractMonth);
            if (this.m_strike != 0.0) {
                Contract.app(sb, this.m_strike);
            }
            if (!Util.StringIsEmpty(this.m_right)) {
                Contract.app(sb, this.m_right);
            }
        }
        return sb.toString();
    }

    private static void app(StringBuilder buf, Object obj) {
        if (obj != null) {
            buf.append(" ");
            buf.append(obj);
        }
    }

    public boolean isCombo() {
        return this.m_comboLegs.size() > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Contract.add(sb, "conid", this.m_conid);
        Contract.add(sb, "symbol", this.m_symbol);
        Contract.add(sb, "secType", this.m_secType);
        Contract.add(sb, "lastTradeDateOrContractMonth", this.m_lastTradedateOrContractMonth);
        Contract.add(sb, "strike", this.m_strike);
        Contract.add(sb, "right", this.m_right);
        Contract.add(sb, "multiplier", this.m_multiplier);
        Contract.add(sb, "exchange", this.m_exchange);
        Contract.add(sb, "currency", this.m_currency);
        Contract.add(sb, "localSymbol", this.m_localSymbol);
        Contract.add(sb, "tradingClass", this.m_tradingClass);
        Contract.add(sb, "primaryExch", this.m_primaryExch);
        Contract.add(sb, "secIdType", this.m_secIdType);
        Contract.add(sb, "secId", this.m_secId);
        return sb.toString();
    }

    public static void add(StringBuilder sb, String tag, Object val) {
        if (val == null || val instanceof String && ((String)val).length() == 0) {
            return;
        }
        sb.append(tag);
        sb.append('\t');
        sb.append(val);
        sb.append('\n');
    }
}

