/*
 * Decompiled with CFR 0.152.
 */
package com.instaclustr.cassandra.auth;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseKerberosAuthenticator
implements IAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(BaseKerberosAuthenticator.class);
    public static final String SASL_MECHANISM = "GSSAPI";
    private static final String ROLE = "role";
    private Configuration config;
    private Subject subject;

    public boolean requireAuthentication() {
        return true;
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    public Set<? extends IResource> protectedResources() {
        return ImmutableSet.of((Object)DataResource.table((String)"system_auth", (String)"roles"));
    }

    public void validateConfiguration() throws ConfigurationException {
        this.config = Configuration.loadConfig();
    }

    public void setup() {
        this.subject = BaseKerberosAuthenticator.loginAsSubject(this.config.servicePrincipal(), this.config.keytab());
        this.afterSetup();
    }

    public abstract void afterSetup();

    static String getKrb5LoginModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
    }

    private static Subject loginAsSubject(final KerberosPrincipal servicePrincipal, final File keytab) {
        logger.debug("Logging in Kerberos service principal {} using keytab at {}", (Object)servicePrincipal, (Object)keytab.getAbsolutePath());
        javax.security.auth.login.Configuration conf = new javax.security.auth.login.Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{new AppConfigurationEntry(BaseKerberosAuthenticator.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, (Map<String, ?>)ImmutableMap.builder().put((Object)"principal", (Object)servicePrincipal.toString()).put((Object)"useKeyTab", (Object)"true").put((Object)"keyTab", (Object)keytab.getAbsolutePath()).put((Object)"storeKey", (Object)"true").put((Object)"doNotPrompt", (Object)"true").put((Object)"isInitiator", (Object)"false").build())};
            }
        };
        try {
            LoginContext loginContext = new LoginContext("", null, cbh -> {
                throw new RuntimeException(new LoginException(String.format("Failed to establish a login context for principal %s with keytab at %s.", servicePrincipal, keytab.getAbsolutePath())));
            }, conf);
            loginContext.login();
            logger.debug("Login context established");
            return loginContext.getSubject();
        }
        catch (LoginException e) {
            throw new RuntimeException("Failed to establish a login context", e);
        }
    }

    public AuthenticatedUser legacyAuthenticate(Map<String, String> credentials) throws AuthenticationException {
        throw new UnsupportedOperationException("Legacy authentication is not supported");
    }

    private static final class NoSuchRoleException
    extends RuntimeException {
        private NoSuchRoleException() {
        }
    }

    public static abstract class QueryUserFunction
    implements Function<String, String> {
        SelectStatement getRoleStatement;
        final String query = String.format("SELECT %s FROM %s.%s WHERE role = ?", "role", "system_auth", "roles");

        public QueryUserFunction() {
            this.getRoleStatement = this.prepare(this.query);
        }

        @Override
        public String apply(String roleName) {
            try {
                logger.debug("Querying role {}", (Object)roleName);
                ResultMessage.Rows rows = this.execute(roleName);
                if (rows.result.isEmpty()) {
                    throw new NoSuchRoleException();
                }
                UntypedResultSet result = UntypedResultSet.create((ResultSet)rows.result);
                if (!result.one().has(BaseKerberosAuthenticator.ROLE)) {
                    throw new NoSuchRoleException();
                }
                return result.one().getString(BaseKerberosAuthenticator.ROLE);
            }
            catch (RequestExecutionException e) {
                logger.trace("Error performing internal authentication", (Throwable)e);
                throw e;
            }
        }

        public abstract SelectStatement prepare(String var1);

        public abstract ResultMessage.Rows execute(String var1);
    }

    public abstract class KerberosSaslAuthenticator
    implements IAuthenticator.SaslNegotiator {
        private final SaslServer saslServer;
        private AuthenticatedUser authenticatedUser = null;

        public KerberosSaslAuthenticator(String saslProtocol, Map<String, ?> saslProperties) {
            logger.debug("Creating SaslServer for {} with {} mechanism. SASL Protocol: {} SASL Properties: {}", new Object[]{BaseKerberosAuthenticator.this.config.servicePrincipal, BaseKerberosAuthenticator.SASL_MECHANISM, saslProtocol, saslProperties});
            try {
                this.saslServer = Subject.doAs(BaseKerberosAuthenticator.this.subject, () -> Sasl.createSaslServer(BaseKerberosAuthenticator.SASL_MECHANISM, saslProtocol, this.serverName(), saslProperties, callbacks -> {
                    for (Callback cb : callbacks) {
                        if (!(cb instanceof AuthorizeCallback)) continue;
                        this.handleAuthorizeCallback((AuthorizeCallback)cb);
                    }
                }));
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e.getException());
            }
        }

        private void handleAuthorizeCallback(AuthorizeCallback ac) throws AuthenticationException {
            ac.setAuthorizedID(null);
            ac.setAuthorized(false);
            if (ac.getAuthenticationID() == null) {
                logger.debug("Kerberos authentication succeeded, but the authentication ID is null.");
                throw new AuthenticationException("Authentication ID must not be null");
            }
            String clientPrincipal = ac.getAuthenticationID().split("[@/]")[0];
            AuthenticatedUser principalUser = this.getCassandraUser(clientPrincipal);
            if (ac.getAuthorizationID() == null || ac.getAuthorizationID().equals(ac.getAuthenticationID())) {
                this.authenticatedUser = principalUser;
                ac.setAuthorizedID(principalUser.getName());
                ac.setAuthorized(true);
            } else {
                AuthenticatedUser assumedUser = this.getCassandraUser(ac.getAuthorizationID());
                if (principalUser.getRoles().contains(assumedUser.getPrimaryRole())) {
                    this.authenticatedUser = assumedUser;
                    ac.setAuthorizedID(assumedUser.getName());
                    ac.setAuthorized(true);
                } else {
                    logger.debug("Kerberos client principal \"{}\" authenticated, but the Cassandra user \"{}\" does not have permission to assume the role \"{}\" specified by the authorization ID.", new Object[]{ac.getAuthenticationID(), principalUser.getName(), assumedUser.getName()});
                    throw new AuthenticationException(String.format("Cassandra user \"%s\" is unable to assume the role \"%s\"", principalUser.getName(), assumedUser.getName()));
                }
            }
            if (ac.isAuthorized()) {
                logger.debug("Kerberos client principal \"{}\" authorized as Cassandra user \"{}\"", (Object)ac.getAuthenticationID(), (Object)ac.getAuthorizedID());
            }
        }

        public byte[] evaluateResponse(byte[] response) throws AuthenticationException {
            try {
                return Subject.doAs(BaseKerberosAuthenticator.this.subject, () -> this.saslServer.evaluateResponse(response));
            }
            catch (PrivilegedActionException e) {
                logger.error(String.format("The SASL server could not evaluate the response sent by the client. Check that the authentication mechanism is configured correctly, and that the client is sending a valid SASL/%s response: %s", BaseKerberosAuthenticator.SASL_MECHANISM, e.getException().getMessage()));
                throw new AuthenticationException("The SASL server could not evaluate the response sent by the client. The server may not be configured correctly, or the response may be invalid: " + e.getException().getMessage());
            }
        }

        public boolean isComplete() {
            return this.saslServer.isComplete() && this.authenticatedUser != null;
        }

        public AuthenticatedUser getAuthenticatedUser() throws AuthenticationException {
            if (!this.isComplete()) {
                throw new AuthenticationException("SASL negotiation is not complete");
            }
            return this.authenticatedUser;
        }

        private AuthenticatedUser getCassandraUser(String username) throws AuthenticationException {
            try {
                this.fetchUser(username);
                return new AuthenticatedUser(username);
            }
            catch (Exception e) {
                if (e.getCause() instanceof NoSuchRoleException) {
                    throw new AuthenticationException(String.format("Provided username %s is incorrect", username));
                }
                if (e.getCause() instanceof RequestExecutionException) {
                    logger.trace("Error performing internal authentication", (Throwable)e);
                    throw new AuthenticationException(String.format("Error during authentication of user %s : %s", username, e.getMessage()));
                }
                throw new RuntimeException(e);
            }
        }

        public abstract void fetchUser(String var1);

        public abstract String serverName();
    }

    protected static class Configuration {
        private URL configUrl;
        private File keytab;
        private String qop;
        private KerberosPrincipal servicePrincipal;
        static final String DEFAULT_CONFIGURATION = "cassandra-krb5.properties";
        static final String CONFIGURATION_KEYTAB_PATH_NAME = "keytab";
        static final String CONFIGURATION_QOP_NAME = "qop";
        static final String CONFIGURATION_SERVICE_PRINCIPAL_NAME = "service_principal";
        private static final String DEFAULT_KEYTAB_PATH = "cassandra.keytab";
        private static final String DEFAULT_QOP = "auth";

        private Configuration() {
        }

        public File keytab() {
            return this.keytab;
        }

        public String qop() {
            return this.qop;
        }

        public KerberosPrincipal servicePrincipal() {
            return this.servicePrincipal;
        }

        public String getKerberosPrincipalServiceNameComponent() {
            Pattern kerberosPrincipalPattern = Pattern.compile("([^/@]*)(/([^/@]*))?@([^/@]*)");
            Matcher match = kerberosPrincipalPattern.matcher(this.servicePrincipal.toString());
            if (!match.matches()) {
                throw new RuntimeException("Config value for service_principal in " + this.configUrl.toString() + " is not valid. Kerberos principal must be in KRB_NT_SRV_HST format");
            }
            return match.group(1);
        }

        private static URL getConfig(String rawUrl) throws ConfigurationException {
            URL url;
            block2: {
                try {
                    url = new URL(rawUrl);
                    url.openStream().close();
                }
                catch (Exception e) {
                    ClassLoader loader = BaseKerberosAuthenticator.class.getClassLoader();
                    url = loader.getResource(rawUrl);
                    if (url != null) break block2;
                    String required = "file:" + File.separator + File.separator;
                    throw new ConfigurationException("Cannot locate " + rawUrl + ".  If this is a local file, please confirm you've provided " + required + File.separator + " as a URI prefix.");
                }
            }
            logger.debug("Kerberos configuration location: {}", (Object)url);
            return url;
        }

        private static File getKeytab(String path) throws ConfigurationException {
            File file = new File(path);
            if (!file.isFile()) {
                ClassLoader loader = BaseKerberosAuthenticator.class.getClassLoader();
                URL url = loader.getResource(path);
                if (url == null) {
                    String required = "file:" + File.separator + File.separator;
                    throw new ConfigurationException("Cannot locate " + path + ".  If this is a local file, please confirm you've provided " + required + File.separator + " as a URI prefix.");
                }
                file = new File(url.getFile());
            }
            logger.debug("Kerberos keytab location: {}", (Object)file.getAbsolutePath());
            return file;
        }

        private void load() throws ConfigurationException {
            if (this.configUrl == null) {
                this.configUrl = Configuration.getConfig(System.getProperty("cassandra.krb5.config", DEFAULT_CONFIGURATION));
            }
            Properties config = new Properties();
            try {
                logger.debug("Loading Kerberos settings from {}", (Object)this.configUrl);
                try (InputStream is = this.configUrl.openStream();){
                    config.load(is);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.keytab = Configuration.getKeytab(config.getProperty(CONFIGURATION_KEYTAB_PATH_NAME, DEFAULT_KEYTAB_PATH));
            this.qop = config.getProperty(CONFIGURATION_QOP_NAME, DEFAULT_QOP);
            this.servicePrincipal = new KerberosPrincipal(config.getProperty(CONFIGURATION_SERVICE_PRINCIPAL_NAME), 3);
        }

        void validate() throws ConfigurationException {
            if (this.servicePrincipal == null) {
                throw new ConfigurationException("No value for service_principal found in " + this.configUrl.toString());
            }
            if (this.qop == null) {
                throw new ConfigurationException("No value for qop found in " + this.configUrl.toString());
            }
            ImmutableList validQopValues = ImmutableList.builder().add((Object)DEFAULT_QOP).add((Object)"auth-conf").add((Object)"auth-int").build();
            if (!validQopValues.contains(this.qop)) {
                throw new ConfigurationException("Config value for qop in " + this.configUrl.toString() + " is not valid. Valid values are: " + validQopValues.toString());
            }
            if (!this.keytab.isFile() || !this.keytab.canRead()) {
                throw new ConfigurationException("Keytab file " + this.keytab.getAbsolutePath() + " specified in " + this.configUrl.toString() + " does not exist, is not a normal file, or cannot be read.");
            }
        }

        static Configuration loadConfig() {
            Configuration config = new Configuration();
            config.load();
            config.validate();
            return config;
        }
    }
}

