/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.permissions.PermissionsListener;
import com.inlocomedia.android.core.private.fm;
import com.inlocomedia.android.core.private.fo;
import com.inlocomedia.android.core.private.fp;
import com.inlocomedia.android.core.private.ft;
import com.inlocomedia.android.core.private.fy;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLocoCheckIn;
import com.inlocomedia.android.location.InLocoOptions;
import com.inlocomedia.android.location.private.ba;
import com.inlocomedia.android.location.private.bj;
import com.inlocomedia.android.location.private.cv;
import com.inlocomedia.android.location.private.ee;
import com.inlocomedia.android.location.private.kr;
import com.inlocomedia.android.location.private.o;
import java.util.Map;

@ApiAccess
public final class InLoco {
    private InLoco() {
    }

    public static void init(@NonNull Context context, InLocoOptions options) {
        bj.g.c(context.getApplicationContext(), options);
    }

    public static void setLocationTrackingEnabled(Context context, boolean enabled) {
        if (enabled && !InLoco.hasGivenPrivacyConsent(context)) {
            DevLogger.i((String)"It is not possible to enable location tracking because the user has not given privacy consent");
            return;
        }
        final InLocoOptions inLocoOptions = InLocoOptions.getInstance(context);
        inLocoOptions.setLocationTrackingEnabled(enabled);
        final Context context2 = context.getApplicationContext();
        fm.m().b((fy)fo.b()).b((fp)new ft(){

            public void a() {
                bj.a.a(context2);
                ee.q().a(inLocoOptions.isLocationTrackingEnabled());
                ee.o().a(InLocoOptions.getInstance(context2));
            }
        }).a((Thread.UncaughtExceptionHandler)bj.a).b();
    }

    public static void givePrivacyConsent(Context context, boolean consent) {
        if (consent) {
            DevLogger.i((String)"User has given privacy consent");
        } else {
            DevLogger.i((String)"User has revoked privacy consent");
        }
        final InLocoOptions inLocoOptions = InLocoOptions.getInstance(context);
        inLocoOptions.givePrivacyConsent(consent);
        final Context context2 = context.getApplicationContext();
        fm.m().b((fy)fo.b()).b((fp)new ft(){

            public void a() {
                bj.a.a(context2);
                ee.e().a(!inLocoOptions.hasGivenPrivacyConsent());
                if (InLoco.hasGivenPrivacyConsent(context2) && InLoco.isLocationTrackingEnabled(context2)) {
                    DevLogger.i((String)"Enabling location tracking");
                    ee.l().a();
                } else {
                    DevLogger.i((String)"Disabling location tracking");
                    ee.l().b();
                }
                ee.o().a(InLocoOptions.getInstance(context2));
            }
        }).a((Thread.UncaughtExceptionHandler)bj.a).b();
    }

    @Deprecated
    public static boolean hasGivenPrivacyConsent(Context context) {
        return InLocoOptions.getInstance(context).hasGivenPrivacyConsent();
    }

    public static boolean isWaitingUserPrivacyConsent(Context context) {
        return InLocoOptions.getInstance(context).isWaitingUserPrivacyConsent();
    }

    @Deprecated
    public static boolean isLocationTrackingEnabled(Context context) {
        return InLocoOptions.getInstance(context).isLocationTrackingEnabled();
    }

    public static void requestLocationPermission(Activity context, boolean askIfDenied) {
        bj.a.a(context.getApplicationContext());
        ee.l().a(context, askIfDenied);
    }

    public static void requestCoarseLocationPermission(Activity context, boolean askIfDenied) {
        bj.a.a(context.getApplicationContext());
        ee.l().a(context, askIfDenied);
    }

    public static void requestPermissions(Activity context, String[] permissions, boolean askIfDenied, PermissionsListener listener) {
        bj.a.a((Context)context);
        ee.b().a((Context)context, permissions, askIfDenied, listener);
    }

    public static void trackLocalizedEvent(Context context, String eventName) {
        InLoco.trackLocalizedEvent(context, eventName, null);
    }

    public static void trackLocalizedEvent(Context context, final String eventName, final Map<String, String> properties) {
        try {
            Validator.notNull((Object)eventName, (String)"eventName");
            final Context context2 = context.getApplicationContext();
            fm.m().b((fy)fo.b()).b((fp)new ft(){

                public void a() {
                    bj.a.c(context2, InLocoOptions.getInstance(context2));
                    ba ba2 = ee.i().m();
                    long l2 = ba2 != null ? ba2.b() : ba.a;
                    ee.s().a(new cv(){

                        @Override
                        public void a(kr kr2) {
                            ee.h().a(eventName, properties, kr2.i());
                            DevLogger.i((String)("Event logged successfully: " + eventName + " " + properties));
                        }

                        @Override
                        public void a() {
                            ee.h().a(eventName, properties, null);
                            DevLogger.w((String)("Event logged without location: " + eventName + " " + properties));
                        }
                    }, l2);
                }
            }).a((Thread.UncaughtExceptionHandler)bj.d).b();
        }
        catch (Throwable throwable) {
            DevLogger.w((String)("Could not track event " + eventName), (Throwable)throwable);
        }
    }

    public static void trackEvent(Context context, String eventName) {
        InLoco.trackEvent(context, eventName, null);
    }

    public static void trackEvent(Context context, final String eventName, final Map<String, String> properties) {
        try {
            Validator.notNull((Object)eventName, (String)"eventName");
            final Context context2 = context.getApplicationContext();
            fm.m().b((fy)fo.b()).b((fp)new ft(){

                public void a() {
                    bj.a.c(context2, InLocoOptions.getInstance(context2));
                    o o2 = ee.h();
                    o2.a(eventName, properties, null);
                }
            }).a((fp)new ft(){

                public void a() throws Throwable {
                    DevLogger.i((String)("Event logged successfully: " + eventName + " " + properties));
                }
            }).a((Thread.UncaughtExceptionHandler)bj.d).b();
        }
        catch (Throwable throwable) {
            DevLogger.w((String)("Could not track event " + eventName), (Throwable)throwable);
        }
    }

    public static void registerCheckIn(Context context, final InLocoCheckIn checkIn) {
        try {
            Validator.notNull((Object)checkIn, (String)"checkIn");
            final Context context2 = context.getApplicationContext();
            fm.m().b((fy)fo.b()).b((fp)new ft(){

                public void a() {
                    bj.a.c(context2, InLocoOptions.getInstance(context2));
                    ee.t().a(checkIn);
                }
            }).a((Thread.UncaughtExceptionHandler)bj.d).b();
        }
        catch (Throwable throwable) {
            DevLogger.w((String)"Could not register check-in", (Throwable)throwable);
        }
    }
}

