/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.permissions.PermissionsListener;
import com.inlocomedia.android.core.private.fm;
import com.inlocomedia.android.core.private.fo;
import com.inlocomedia.android.core.private.fp;
import com.inlocomedia.android.core.private.ft;
import com.inlocomedia.android.core.private.fy;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLocoOptions;
import com.inlocomedia.android.location.private.bf;
import com.inlocomedia.android.location.private.dw;
import com.inlocomedia.android.location.private.o;
import java.util.Map;

@ApiAccess
public final class InLoco {
    private InLoco() {
    }

    public static void init(@NonNull Context context, InLocoOptions options) {
        bf.g.c(context.getApplicationContext(), options);
    }

    public static void setLocationTrackingEnabled(Context context, boolean enabled) {
        if (enabled && !InLoco.hasGivenPrivacyConsent(context)) {
            DevLogger.i((String)"It is not possible to enable location tracking because the user has not given privacy consent");
            return;
        }
        final InLocoOptions inLocoOptions = InLocoOptions.getInstance(context);
        inLocoOptions.setLocationTrackingEnabled(enabled);
        final Context context2 = context.getApplicationContext();
        fm.m().b((fy)fo.b()).b((fp)new ft(){

            public void a() {
                bf.a.a(context2);
                dw.q().a(inLocoOptions.isLocationTrackingEnabled());
                dw.o().a(InLocoOptions.getInstance(context2));
            }
        }).a((Thread.UncaughtExceptionHandler)bf.a).b();
    }

    public static void givePrivacyConsent(Context context, boolean consent) {
        if (consent) {
            DevLogger.i((String)"User has given privacy consent");
        } else {
            DevLogger.i((String)"User has revoked privacy consent");
        }
        final InLocoOptions inLocoOptions = InLocoOptions.getInstance(context);
        inLocoOptions.givePrivacyConsent(consent);
        final Context context2 = context.getApplicationContext();
        fm.m().b((fy)fo.b()).b((fp)new ft(){

            public void a() {
                bf.a.a(context2);
                dw.e().a(!inLocoOptions.hasGivenPrivacyConsent());
                if (InLoco.hasGivenPrivacyConsent(context2) && InLoco.isLocationTrackingEnabled(context2)) {
                    DevLogger.i((String)"Enabling location tracking");
                    dw.l().a();
                } else {
                    DevLogger.i((String)"Disabling location tracking");
                    dw.l().b();
                }
                dw.o().a(InLocoOptions.getInstance(context2));
            }
        }).a((Thread.UncaughtExceptionHandler)bf.a).b();
    }

    public static boolean hasGivenPrivacyConsent(Context context) {
        return InLocoOptions.getInstance(context).hasGivenPrivacyConsent();
    }

    public static boolean isWaitingUserPrivacyConsent(Context context) {
        return InLocoOptions.getInstance(context).isWaitingUserPrivacyConsent();
    }

    public static boolean isLocationTrackingEnabled(Context context) {
        return InLocoOptions.getInstance(context).isLocationTrackingEnabled();
    }

    public static void requestLocationPermission(Activity context, boolean askIfDenied) {
        bf.a.a(context.getApplicationContext());
        dw.l().a(context, askIfDenied);
    }

    public static void requestCoarseLocationPermission(Activity context, boolean askIfDenied) {
        bf.a.a(context.getApplicationContext());
        dw.l().a(context, askIfDenied);
    }

    public static void requestPermissions(Activity context, String[] permissions, boolean askIfDenied, PermissionsListener listener) {
        bf.a.a((Context)context);
        dw.b().a((Context)context, permissions, askIfDenied, listener);
    }

    public static void trackEvent(Context context, String eventName) {
        InLoco.trackEvent(context, eventName, null);
    }

    public static void trackEvent(Context context, final String eventName, final Map<String, String> properties) {
        try {
            Validator.notNull((Object)eventName, (String)"eventName");
            final Context context2 = context.getApplicationContext();
            fm.m().b((fy)fo.b()).b((fp)new ft(){

                public void a() {
                    bf.a.c(context2, InLocoOptions.getInstance(context2));
                    o o2 = dw.h();
                    o2.a(eventName, properties);
                }
            }).a((fp)new ft(){

                public void a() throws Throwable {
                    DevLogger.i((String)("Event logged successfully: " + eventName + " " + properties));
                }
            }).a((Thread.UncaughtExceptionHandler)bf.a).b();
        }
        catch (Throwable throwable) {
            DevLogger.w((String)("Could not track event " + eventName), (Throwable)throwable);
        }
    }
}

