/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location;

import android.annotation.SuppressLint;
import android.content.Context;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.private.bk;
import com.inlocomedia.android.core.profile.Device;
import com.inlocomedia.android.core.util.Validator;

@SuppressLint(value={"CommitPrefEdits"})
@ApiAccess
public final class InLocoOptions {
    private static final String PREFS_NAME = "com.inlocomedia.android.location.InLocoOptions";
    private static final String PREFS_DEVELOPMENT_ENABLED = "com.inlocomedia.android.location.InLocoOptions#DEVELOPMENT";
    private static final String PREFS_ADS_KEY = "com.inlocomedia.android.ads.InLocoMediaOptions#ADS_KEY";
    private static final String PREFS_LOCATION_KEY = "com.inlocomedia.android.location.InLocoOptions#LOCATION_KEY";
    private static final String PREFS_LOGS_ENABLED = "com.inlocomedia.android.location.InLocoOptions#LOGS_ENABLED";
    private static final String PREFS_GENERAL_CACHE_SIZE = "com.inlocomedia.android.location.InLocoOptions#GENERAL_CACHE_SIZE";
    private static final String PREFS_FILES_CACHE_SIZE = "com.inlocomedia.android.location.InLocoOptions#FILES_CACHE_SIZE";
    private static final String PREFS_LOCATION_TRACKING_ENABLED = "com.inlocomedia.android.location.InLocoOptions#LOCATION_TRACKING_ENABLED";
    private static final String PREFS_SCREEN_TRACKING_ENABLED = "com.inlocomedia.android.location.InLocoOptions#SCREEN_TRACKING_ENABLED";
    private static final String PREFS_USER_PRIVACY_CONSENT_GIVEN = "com.inlocomedia.android.location.InLocoOptions#USER_PRIVACY_CONSENT_GIVEN";
    private static final String PREFS_REQUIRES_USER_PRIVACY_CONSENT = "com.inlocomedia.android.location.InLocoOptions#REQUIRES_USER_PRIVACY_CONSENT";
    private static final String PREFS_FOREGROUND_SERVICE_ENABLED = "com.inlocomedia.android.location.InLocoOptions#FOREGROUND_SERVICE_ENABLED";
    private static InLocoOptions sInstance;
    private final Context mContext;
    private static final long GENERAL_CACHE_SIZE_DEFAULT = 0xA00000L;
    private static final long FILES_CACHE_SIZE_DEFAULT = 0x3200000L;

    public static synchronized InLocoOptions newInstance(Context context) {
        sInstance = new InLocoOptions(context, true);
        return sInstance;
    }

    public static synchronized InLocoOptions getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new InLocoOptions(context, false);
        }
        return sInstance;
    }

    private InLocoOptions(Context context, boolean clearPrefs) {
        this.mContext = context.getApplicationContext();
        if (clearPrefs) {
            this.clear();
        }
    }

    public void clear() {
        InLocoOptions.getPrefsEntry(this.mContext).e();
    }

    public String getLocationKey() {
        String string2 = InLocoOptions.getPrefsEntry(this.mContext).a(PREFS_LOCATION_KEY, null);
        return string2 != null ? string2 : InLocoOptions.getPrefsEntry(this.mContext).a(PREFS_ADS_KEY, null);
    }

    public void setLocationKey(String locationProductionKey) {
        InLocoOptions.getPrefsEntry(this.mContext).b(PREFS_LOCATION_KEY, locationProductionKey).d();
    }

    public void setGeneralCacheSize(long cacheSize) {
        InLocoOptions.getPrefsEntry(this.mContext).b(PREFS_GENERAL_CACHE_SIZE, cacheSize).d();
    }

    public long getGeneralCacheSize() {
        return InLocoOptions.getPrefsEntry(this.mContext).a(PREFS_GENERAL_CACHE_SIZE, 0xA00000L);
    }

    public void setFilesCacheSize(long cacheSize) {
        InLocoOptions.getPrefsEntry(this.mContext).b(PREFS_FILES_CACHE_SIZE, cacheSize).d();
    }

    public long getFilesCacheSize() {
        return InLocoOptions.getPrefsEntry(this.mContext).a(PREFS_FILES_CACHE_SIZE, 0x3200000L);
    }

    public void setLogEnabled(boolean enabled) {
        InLocoOptions.getPrefsEntry(this.mContext).b(PREFS_LOGS_ENABLED, enabled).d();
    }

    public boolean isLogEnabled() {
        return InLocoOptions.getPrefsEntry(this.mContext).a(PREFS_LOGS_ENABLED, true);
    }

    public void setForegroundServiceEnabled(boolean enabled) {
        InLocoOptions.getPrefsEntry(this.mContext).b(PREFS_FOREGROUND_SERVICE_ENABLED, enabled).d();
    }

    public boolean isForegroundServiceEnabled() {
        return InLocoOptions.getPrefsEntry(this.mContext).a(PREFS_FOREGROUND_SERVICE_ENABLED, true);
    }

    public void setLocationTrackingEnabled(boolean enabled) {
        if (enabled && !this.hasGivenPrivacyConsent()) {
            DevLogger.i((String)"It is not possible to enable location tracking because the user is disabled");
        }
        InLocoOptions.getPrefsEntry(this.mContext).b(PREFS_LOCATION_TRACKING_ENABLED, enabled).d();
    }

    public boolean isLocationTrackingEnabled() {
        return InLocoOptions.getPrefsEntry(this.mContext).a(PREFS_LOCATION_TRACKING_ENABLED, true) && this.hasGivenPrivacyConsent();
    }

    public void setScreenTrackingEnabled(boolean enabled) {
        InLocoOptions.getPrefsEntry(this.mContext).b(PREFS_SCREEN_TRACKING_ENABLED, enabled).d();
    }

    public boolean isScreenTrackingEnabled() {
        return InLocoOptions.getPrefsEntry(this.mContext).a(PREFS_SCREEN_TRACKING_ENABLED, false);
    }

    public boolean isUserPrivacyConsentRequired() {
        return InLocoOptions.getPrefsEntry(this.mContext).a(PREFS_REQUIRES_USER_PRIVACY_CONSENT, false);
    }

    public void setRequiresUserPrivacyConsent(boolean required) {
        InLocoOptions.getPrefsEntry(this.mContext).b(PREFS_REQUIRES_USER_PRIVACY_CONSENT, required).d();
    }

    public void givePrivacyConsent(boolean consent) {
        InLocoOptions.getPrefsEntry(this.mContext).b(PREFS_USER_PRIVACY_CONSENT_GIVEN, consent).d();
    }

    public boolean hasGivenPrivacyConsent() {
        return InLocoOptions.getPrefsEntry(this.mContext).a(PREFS_USER_PRIVACY_CONSENT_GIVEN, false) || !this.isUserPrivacyConsentRequired();
    }

    public boolean isWaitingUserPrivacyConsent() {
        return !InLocoOptions.getPrefsEntry(this.mContext).j(PREFS_USER_PRIVACY_CONSENT_GIVEN) && this.isUserPrivacyConsentRequired();
    }

    public boolean isDevelopmentEnvironment() {
        return InLocoOptions.getPrefsEntry(this.mContext).a(PREFS_DEVELOPMENT_ENABLED, false);
    }

    public void setDevelopmentDevices(String ... developmentDevices) {
        boolean bl2 = false;
        String string2 = Device.getDevelopmentDeviceId((Context)this.mContext);
        if (!Validator.isNullOrEmpty((String)string2) && developmentDevices != null) {
            for (String string3 : developmentDevices) {
                if (!string2.equals(string3)) continue;
                bl2 = true;
                break;
            }
        }
        InLocoOptions.getPrefsEntry(this.mContext).b(PREFS_DEVELOPMENT_ENABLED, bl2).d();
    }

    private static bk.a getPrefsEntry(Context context) {
        return bk.a((Context)context).a(PREFS_NAME);
    }

    public static void reset(Context context) {
        InLocoOptions.getPrefsEntry(context).e();
        sInstance = null;
    }
}

