/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.permissions.PermissionsListener;
import com.inlocomedia.android.core.private.eo;
import com.inlocomedia.android.core.private.eq;
import com.inlocomedia.android.core.private.er;
import com.inlocomedia.android.core.private.ev;
import com.inlocomedia.android.core.private.fa;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLocoOptions;
import com.inlocomedia.android.location.private.as;
import com.inlocomedia.android.location.private.db;
import com.inlocomedia.android.location.private.n;
import java.util.Map;

@ApiAccess
public final class InLoco {
    private InLoco() {
    }

    public static void init(@NonNull Context context, InLocoOptions options) {
        as.g.a(context.getApplicationContext(), options);
    }

    public static void setLocationTrackingEnabled(Context context, boolean enabled) {
        if (enabled && !InLoco.hasGivenPrivacyConsent(context)) {
            DevLogger.i((String)"It is not possible to enable location tracking because the user has not given privacy consent");
            return;
        }
        InLocoOptions.getInstance(context).setLocationTrackingEnabled(enabled);
        db.p().a(enabled);
        final Context context2 = context.getApplicationContext();
        eo.m().b((fa)eq.b()).b((er)new ev(){

            public void a() {
                as.a.a(context2);
                if (InLoco.hasGivenPrivacyConsent(context2) && InLoco.isLocationTrackingEnabled(context2)) {
                    DevLogger.i((String)"Enabling location tracking");
                    db.k().a();
                } else {
                    DevLogger.i((String)"Disabling location tracking");
                    db.k().b();
                }
                db.n().a(InLocoOptions.getInstance(context2));
            }
        }).a((Thread.UncaughtExceptionHandler)as.a).b();
    }

    public static void givePrivacyConsent(Context context, boolean consent) {
        if (consent) {
            DevLogger.i((String)"User has given privacy consent");
        } else {
            DevLogger.i((String)"User has revoked privacy consent");
        }
        final InLocoOptions inLocoOptions = InLocoOptions.getInstance(context);
        inLocoOptions.givePrivacyConsent(consent);
        final Context context2 = context.getApplicationContext();
        eo.m().b((fa)eq.b()).b((er)new ev(){

            public void a() {
                as.a.a(context2);
                db.d().a(!inLocoOptions.hasGivenPrivacyConsent());
                if (InLoco.hasGivenPrivacyConsent(context2) && InLoco.isLocationTrackingEnabled(context2)) {
                    DevLogger.i((String)"Enabling location tracking");
                    db.k().a();
                } else {
                    DevLogger.i((String)"Disabling location tracking");
                    db.k().b();
                }
                db.n().a(InLocoOptions.getInstance(context2));
            }
        }).a((Thread.UncaughtExceptionHandler)as.a).b();
    }

    public static boolean hasGivenPrivacyConsent(Context context) {
        return InLocoOptions.getInstance(context).hasGivenPrivacyConsent();
    }

    public static boolean isWaitingUserPrivacyConsent(Context context) {
        return InLocoOptions.getInstance(context).isWaitingUserPrivacyConsent();
    }

    public static boolean isLocationTrackingEnabled(Context context) {
        return InLocoOptions.getInstance(context).isLocationTrackingEnabled();
    }

    public static void requestLocationPermission(Activity context, boolean askIfDenied) {
        as.a.a(context.getApplicationContext());
        db.k().a(context, askIfDenied);
    }

    public static void requestCoarseLocationPermission(Activity context, boolean askIfDenied) {
        as.a.a(context.getApplicationContext());
        db.k().a(context, askIfDenied);
    }

    public static void requestPermissions(Activity context, String[] permissions, boolean askIfDenied, PermissionsListener listener) {
        as.a.a((Context)context);
        db.b().a((Context)context, permissions, askIfDenied, listener);
    }

    public static void trackEvent(Context context, String eventName) {
        InLoco.trackEvent(context, eventName, null);
    }

    public static void trackEvent(Context context, final String eventName, final Map<String, String> properties) {
        try {
            Validator.notNull((Object)eventName, (String)"eventName");
            final Context context2 = context.getApplicationContext();
            eo.m().b((fa)eq.b()).b((er)new ev(){

                public void a() {
                    as.a.a(context2, InLocoOptions.getInstance(context2));
                    n n2 = db.g();
                    n2.a(eventName, properties);
                }
            }).a((er)new ev(){

                public void a() throws Throwable {
                    DevLogger.i((String)("Event logged successfully: " + eventName + " " + properties));
                }
            }).a((Thread.UncaughtExceptionHandler)as.a).b();
        }
        catch (Throwable throwable) {
            DevLogger.w((String)("Could not track event " + eventName), (Throwable)throwable);
        }
    }
}

