/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location.geofencing;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.VisibleForTesting;
import com.inlocomedia.android.location.geofencing.p;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class SimpleGeofence
implements Parcelable,
Serializable {
    @VisibleForTesting
    static final int DEFAULT_LOITERING_DELAY = (int)TimeUnit.MINUTES.toMillis(5L);
    @VisibleForTesting
    static final int DEFAULT_GEOFENCE_RESPONSIVENESS_DELAY = (int)TimeUnit.MINUTES.toMillis(5L);
    public static final int TYPE_MICRO = 1;
    public static final int TYPE_MACRO = 2;
    public static final int GEOFENCING_TRANSITION_ENTER = 1;
    public static final int GEOFENCING_TRANSITION_EXIT = 2;
    public static final int GEOFENCING_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;
    public final int type;
    public final String category;
    public final String id;
    public final double latitude;
    public final double longitude;
    public final double radius;
    public final long expirationDate;
    public final long inPollRate;
    public final long outPollRate;
    public final int triggeringTransitionTypes;
    public final int initialTriggerTransitions;
    public final int monitoredTransitions;
    final List<String> monitoredRetailIds;
    public final boolean trackTransition;
    public final String registerTransitionUrl;
    public final int loiteringDelay;
    public final int responsivenessDelay;
    public static final Parcelable.Creator<SimpleGeofence> CREATOR = new Parcelable.Creator<SimpleGeofence>(){

        public SimpleGeofence a(Parcel parcel) {
            return new SimpleGeofence(parcel);
        }

        public SimpleGeofence[] a(int n2) {
            return new SimpleGeofence[n2];
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    SimpleGeofence(a builder) {
        this.type = builder.a;
        this.category = builder.b;
        this.id = builder.c;
        this.latitude = builder.d;
        this.longitude = builder.e;
        this.radius = builder.f;
        this.expirationDate = builder.g;
        this.inPollRate = builder.h;
        this.outPollRate = builder.i;
        this.triggeringTransitionTypes = builder.j;
        this.initialTriggerTransitions = builder.l;
        this.monitoredTransitions = builder.k;
        this.monitoredRetailIds = builder.m != null ? builder.m : new ArrayList<String>();
        this.trackTransition = builder.n;
        this.registerTransitionUrl = builder.o;
        this.loiteringDelay = builder.p;
        this.responsivenessDelay = builder.q;
    }

    boolean isExpired() {
        return SystemClock.elapsedRealtime() > this.expirationDate;
    }

    static String generateUniqueId() {
        return UUID.randomUUID().toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.type);
        dest.writeString(this.category);
        dest.writeString(this.id);
        dest.writeDouble(this.latitude);
        dest.writeDouble(this.longitude);
        dest.writeDouble(this.radius);
        dest.writeLong(this.expirationDate);
        dest.writeLong(this.inPollRate);
        dest.writeLong(this.outPollRate);
        dest.writeInt(this.triggeringTransitionTypes);
        dest.writeInt(this.monitoredTransitions);
        dest.writeInt(this.initialTriggerTransitions);
        dest.writeInt(this.trackTransition ? 1 : 0);
        dest.writeStringList(this.monitoredRetailIds);
        dest.writeInt(this.loiteringDelay);
        dest.writeInt(this.responsivenessDelay);
    }

    private SimpleGeofence(Parcel in) {
        this.type = in.readInt();
        this.category = in.readString();
        this.id = in.readString();
        this.latitude = in.readDouble();
        this.longitude = in.readDouble();
        this.radius = in.readDouble();
        this.expirationDate = in.readLong();
        this.inPollRate = in.readLong();
        this.outPollRate = in.readLong();
        this.monitoredTransitions = in.readInt();
        this.triggeringTransitionTypes = in.readInt();
        this.initialTriggerTransitions = in.readInt();
        this.trackTransition = in.readInt() != 0;
        this.registerTransitionUrl = in.readString();
        this.monitoredRetailIds = new ArrayList<String>();
        in.readStringList(this.monitoredRetailIds);
        this.loiteringDelay = in.readInt();
        this.responsivenessDelay = in.readInt();
    }

    public String toString() {
        return "SimpleGeofence{type=" + (this.type == 2 ? "Macro" : "Micro") + (this.category != null ? ", category='" + this.category + '\'' : "") + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", radius=" + this.radius + ", expirationDate=" + this.expirationDate + ", inPollRate=" + this.inPollRate + ", outPollRate=" + this.outPollRate + ", triggeringTransitionTypes=" + p.a(this.triggeringTransitionTypes) + ", initialTriggerTransitions=" + p.a(this.initialTriggerTransitions) + ", monitoredTransitions=" + p.a(this.monitoredTransitions) + (!this.monitoredRetailIds.isEmpty() ? ", monitoredRetailIds=" + this.monitoredRetailIds : "") + ", trackTransition=" + this.trackTransition + (this.registerTransitionUrl != null ? ", registerTransitionUrl=" + this.registerTransitionUrl : "") + ", loiteringDelay=" + this.loiteringDelay + ", responsivenessDelay=" + this.responsivenessDelay + '}';
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SimpleGeofence simpleGeofence = (SimpleGeofence)o2;
        if (this.type != simpleGeofence.type) {
            return false;
        }
        if (Double.compare(simpleGeofence.latitude, this.latitude) != 0) {
            return false;
        }
        if (Double.compare(simpleGeofence.longitude, this.longitude) != 0) {
            return false;
        }
        if (Double.compare(simpleGeofence.radius, this.radius) != 0) {
            return false;
        }
        if (this.expirationDate != simpleGeofence.expirationDate) {
            return false;
        }
        if (this.inPollRate != simpleGeofence.inPollRate) {
            return false;
        }
        if (this.outPollRate != simpleGeofence.outPollRate) {
            return false;
        }
        if (this.triggeringTransitionTypes != simpleGeofence.triggeringTransitionTypes) {
            return false;
        }
        if (this.initialTriggerTransitions != simpleGeofence.initialTriggerTransitions) {
            return false;
        }
        if (this.monitoredTransitions != simpleGeofence.monitoredTransitions) {
            return false;
        }
        if (this.trackTransition != simpleGeofence.trackTransition) {
            return false;
        }
        if (this.loiteringDelay != simpleGeofence.loiteringDelay) {
            return false;
        }
        if (this.responsivenessDelay != simpleGeofence.responsivenessDelay) {
            return false;
        }
        if (this.category != null ? !this.category.equals(simpleGeofence.category) : simpleGeofence.category != null) {
            return false;
        }
        if (!this.id.equals(simpleGeofence.id)) {
            return false;
        }
        return this.monitoredRetailIds.equals(simpleGeofence.monitoredRetailIds);
    }

    public int hashCode() {
        int n2 = this.type;
        n2 = 31 * n2 + (this.category != null ? this.category.hashCode() : 0);
        n2 = 31 * n2 + this.id.hashCode();
        long l2 = Double.doubleToLongBits(this.latitude);
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.longitude);
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.radius);
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        n2 = 31 * n2 + (int)(this.expirationDate ^ this.expirationDate >>> 32);
        n2 = 31 * n2 + (int)(this.inPollRate ^ this.inPollRate >>> 32);
        n2 = 31 * n2 + (int)(this.outPollRate ^ this.outPollRate >>> 32);
        n2 = 31 * n2 + this.triggeringTransitionTypes;
        n2 = 31 * n2 + this.initialTriggerTransitions;
        n2 = 31 * n2 + this.monitoredTransitions;
        n2 = 31 * n2 + this.monitoredRetailIds.hashCode();
        n2 = 31 * n2 + (this.trackTransition ? 1 : 0);
        n2 = 31 * n2 + this.loiteringDelay;
        n2 = 31 * n2 + this.responsivenessDelay;
        return n2;
    }

    public static class a {
        public Integer a;
        public String b;
        public String c;
        public Double d;
        public Double e;
        public Double f;
        public Long g;
        public Long h;
        public Long i;
        public Integer j;
        public Integer k;
        public Integer l;
        List<String> m;
        public Boolean n;
        String o;
        public Integer p;
        public Integer q;

        public SimpleGeofence a() {
            return new SimpleGeofence(this);
        }

        public a a(int n2) {
            this.a = n2;
            return this;
        }

        public a a(String string) {
            this.b = string;
            return this;
        }

        public a b(String string) {
            this.c = string;
            return this;
        }

        public a a(double d2) {
            this.d = d2;
            return this;
        }

        public a b(double d2) {
            this.e = d2;
            return this;
        }

        public a c(double d2) {
            this.f = d2;
            return this;
        }

        public a a(long l2) {
            this.g = l2;
            return this;
        }

        public a b(long l2) {
            this.h = l2;
            return this;
        }

        public a c(long l2) {
            this.i = l2;
            return this;
        }

        public a b(int n2) {
            this.j = n2;
            return this;
        }

        public a c(int n2) {
            this.k = n2;
            return this;
        }

        public a d(int n2) {
            this.l = n2;
            return this;
        }

        a a(List<String> list) {
            this.m = list;
            return this;
        }

        public a a(boolean bl2) {
            this.n = bl2;
            return this;
        }

        a c(String string) {
            this.o = string;
            return this;
        }

        public a e(int n2) {
            this.p = n2;
            return this;
        }

        public a f(int n2) {
            this.q = n2;
            return this;
        }
    }
}

