/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location.maps;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import com.inlocomedia.android.core.communication.Request;
import com.inlocomedia.android.core.communication.exception.NetworkException;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.exception.InLocoMediaAPIException;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLoco;
import com.inlocomedia.android.location.core.communication.listeners.StoresRequestListener;
import com.inlocomedia.android.location.exception.InvalidFloorException;
import com.inlocomedia.android.location.exception.LocationExceptionMapping;
import com.inlocomedia.android.location.exception.RetailMapImageInvalidException;
import com.inlocomedia.android.location.exception.RouteUnavailableException;
import com.inlocomedia.android.location.exception.StoresUnavailableException;
import com.inlocomedia.android.location.maps.MapViewLoadListener;
import com.inlocomedia.android.location.maps.views.IndoorMapView;
import com.inlocomedia.android.location.models.Location;
import com.inlocomedia.android.location.models.Retail;
import com.inlocomedia.android.location.models.RetailMap;
import com.inlocomedia.android.location.models.Store;
import com.inlocomedia.android.location.models.e;
import com.inlocomedia.android.location.private.as;
import com.inlocomedia.android.location.private.av;
import com.inlocomedia.android.location.private.ba;
import com.inlocomedia.android.location.private.u;
import com.inlocomedia.android.location.private.v;
import com.inlocomedia.android.location.private.y;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class a {
    private final IndoorMapView a;
    private Retail b;
    private RetailMap c;
    private Integer d;
    private List<RetailMap> e;
    private SparseArray<RetailMap> f;
    private HashMap<String, RetailMap> g;
    private final ThreadPoolExecutor h;
    private final LinkedBlockingQueue<Runnable> i;
    private y j;
    private Thread k;
    private MapViewLoadListener l;
    private final Handler m;
    private boolean n;

    public a(IndoorMapView indoorMapView) {
        this.a = indoorMapView;
        this.i = new LinkedBlockingQueue();
        this.h = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.i);
        this.m = new Handler(Looper.getMainLooper());
    }

    public void a(RetailMap retailMap) {
        Integer n2;
        Validator.mainThread((String)"IndoorMapView data change error");
        if (this.b("SetRetailMap") && this.a(n2 = this.a(this.e, retailMap), " a map with floor " + retailMap.getFloor())) {
            this.d = n2;
            this.h();
            if (n2 != null) {
                this.h.submit(new a(n2, this.l, this.b));
            }
        }
    }

    public void a() {
        Validator.mainThread((String)"IndoorMapView data change error");
        if (this.b("NextFloor")) {
            if (this.d == null) {
                this.d = -1;
            }
            if (this.a(this.d + 1, "a next floor")) {
                Integer n2 = this.d;
                Integer n3 = this.d = Integer.valueOf(this.d + 1);
                this.h();
                this.h.submit(new a(this.d, this.l, this.b));
            }
        }
    }

    public void b() {
        Validator.mainThread((String)"IndoorMapView data change error");
        if (this.b("PreviousFloor")) {
            if (this.d == null) {
                this.d = 1;
            }
            if (this.a(this.d - 1, "a previous floor")) {
                Integer n2 = this.d;
                Integer n3 = this.d = Integer.valueOf(this.d - 1);
                this.h();
                this.h.submit(new a(this.d, this.l, this.b));
            }
        }
    }

    public RetailMap a(int n2) {
        return (RetailMap)((Object)this.f.get(n2));
    }

    public RetailMap a(String string2) {
        return this.g.get(string2);
    }

    public boolean c() {
        return this.c != null && this.a((Integer)(this.d + 1));
    }

    public boolean d() {
        return this.c != null && this.a((Integer)(this.d - 1));
    }

    public boolean e() {
        return this.b != null;
    }

    private boolean b(String string2) {
        if (this.b == null) {
            InLocoMediaAPIException inLocoMediaAPIException = new InLocoMediaAPIException("You need to load a retail before using this operation (" + string2 + ")");
            this.a(this.l, inLocoMediaAPIException);
            return false;
        }
        if (this.e == null) {
            InLocoMediaAPIException inLocoMediaAPIException = new InLocoMediaAPIException("Retail not loaded. Wait the setRetail to finish before using this operation (" + string2 + ")");
            this.a(this.l, inLocoMediaAPIException);
            return false;
        }
        return true;
    }

    private boolean a(Integer n2, String string2) {
        if (!this.a(n2)) {
            InvalidFloorException invalidFloorException = new InvalidFloorException("The retail does not have " + string2);
            this.a(this.l, invalidFloorException);
            return false;
        }
        return true;
    }

    public void a(Retail retail, MapViewLoadListener mapViewLoadListener) {
        Validator.notNull((Object)((Object)retail), (String)"Retail");
        Validator.notNullNorEmpty((String)retail.getId(), (String)"Retail id");
        this.l = mapViewLoadListener;
        this.b = retail;
        this.h();
        this.j = new y(this.a.getContext(), retail.getId());
        this.d = null;
        this.h.submit(new c(retail, this.l));
    }

    public void a(MapViewLoadListener mapViewLoadListener) {
        this.l = mapViewLoadListener;
    }

    public RetailMap b(int n2) {
        for (RetailMap retailMap : this.e) {
            if (retailMap.getFloor() != n2) continue;
            return retailMap;
        }
        return null;
    }

    private void a(final MapViewLoadListener mapViewLoadListener, final InLocoMediaAPIException inLocoMediaAPIException) {
        DevLogger.w((String)("IndoorMapView error: " + inLocoMediaAPIException.getFormattedMessage()));
        if (mapViewLoadListener != null && this.g()) {
            this.m.post(new Runnable(){

                @Override
                public void run() {
                    mapViewLoadListener.onLoadError(inLocoMediaAPIException);
                }
            });
        }
    }

    private Integer a(List<RetailMap> list, RetailMap retailMap) {
        int n2 = 0;
        for (RetailMap retailMap2 : list) {
            if (retailMap2.getId().equals(retailMap.getId())) {
                return n2;
            }
            ++n2;
        }
        return null;
    }

    private boolean a(Integer n2) {
        return n2 != null && n2 >= 0 && n2 < this.e.size();
    }

    public boolean a(Location location) {
        return this.b != null && (location == null || this.b.getId().equals(location.getRetailId()));
    }

    private void h() {
        this.i.clear();
    }

    public void f() {
        this.n = true;
        this.h.shutdownNow();
        if (this.k != null) {
            this.k.interrupt();
            this.k = null;
        }
        this.h();
        this.b = null;
        this.c = null;
        this.e = null;
        this.l = null;
        this.d = null;
    }

    public boolean g() {
        return !this.n && this.a != null;
    }

    private class b
    extends Thread {
        private final Retail b;
        private final MapViewLoadListener c;

        b(Retail retail, MapViewLoadListener mapViewLoadListener) {
            super("InLocoMedia IndoorMapView Extras Thread");
            this.b = retail;
            this.c = mapViewLoadListener;
        }

        @Override
        public void run() {
            Context context;
            if (a.this.g() && (context = a.this.a.getContext()) != null) {
                IndoorMapView.Options options = a.this.a.getOptions();
                this.a(context, this.b, this.c);
                if (a.this.g() && options.isRouteEnabled()) {
                    this.b(context, this.b, this.c);
                }
            }
        }

        private void a(Context context, Retail retail, final MapViewLoadListener mapViewLoadListener) {
            StoresRequestListener storesRequestListener = new StoresRequestListener(){

                @Override
                public void onRequestFinished(List<Store> response) {
                    a.this.a.setStores(response);
                }

                @Override
                public void onRequestFailed(InLocoMediaAPIException error) {
                    StoresUnavailableException storesUnavailableException = new StoresUnavailableException("Stores request has failed. " + error.getLocalizedMessage(), (Exception)error);
                    a.this.a(mapViewLoadListener, storesUnavailableException);
                }
            };
            List<Store> list = a.this.j.a();
            if (list == null) {
                InLoco.requestStores(context, retail.getId(), Locale.getDefault(), storesRequestListener);
            } else {
                storesRequestListener.onRequestFinished(list);
            }
        }

        private void b(Context context, Retail retail, final MapViewLoadListener mapViewLoadListener) {
            RequestListener<av<ba>> requestListener = new RequestListener<av<ba>>(){

                public void a(av<ba> av2) {
                    a.this.a.setGraph(av2);
                }

                public void onRequestFailed(InLocoMediaException error) {
                    if (error instanceof NetworkException) {
                        RouteUnavailableException routeUnavailableException = new RouteUnavailableException("Route request has failed", (Exception)((Object)error));
                        a.this.a(mapViewLoadListener, routeUnavailableException);
                    } else {
                        RouteUnavailableException routeUnavailableException = new RouteUnavailableException("Route is unavailable", (Exception)((Object)error));
                        a.this.a(mapViewLoadListener, routeUnavailableException);
                    }
                }

                public /* synthetic */ void onRequestFinished(Object object) {
                    this.a((av)object);
                }
            };
            av<ba> av2 = a.this.j.b();
            if (av2 == null) {
                as.d(context, retail.getId(), requestListener);
            } else {
                requestListener.onRequestFinished(av2);
            }
        }
    }

    private class a
    implements Runnable {
        private final MapViewLoadListener b;
        private final Retail c;
        private final int d;

        a(int n2, MapViewLoadListener mapViewLoadListener, Retail retail) {
            this.b = mapViewLoadListener;
            this.d = n2;
            this.c = retail;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DevLogger.i((String)("IndoorMapView is loading the retail map at position " + this.d));
            List list = a.this.e;
            if (a.this.b("Load map at index " + this.d)) {
                final RetailMap retailMap = (RetailMap)((Object)list.get(this.d));
                if (a.this.g() && a.this.b("Switch to map " + (Object)((Object)retailMap))) {
                    RequestListener<e> requestListener = new RequestListener<e>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void a(final e e2) {
                            if (a.this.g()) {
                                ThreadPool.executeInMain((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            a.this.c = retailMap;
                                            a.this.a.loadRetailMap(retailMap, e2);
                                            if (a.this.b != null) {
                                                a.this.b.onRetailMapLoadFinished(retailMap);
                                            }
                                        }
                                        catch (RetailMapImageInvalidException retailMapImageInvalidException) {
                                            a.this.a(a.this.b, retailMapImageInvalidException);
                                        }
                                    }
                                });
                            }
                            a a2 = a.this;
                            synchronized (a2) {
                                a.this.notifyAll();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onRequestFailed(InLocoMediaException error) {
                            a a2 = a.this;
                            synchronized (a2) {
                                a.this.notifyAll();
                            }
                            a.this.a(a.this.b, LocationExceptionMapping.parseException(error));
                        }

                        public /* synthetic */ void onRequestFinished(Object object) {
                            this.a((e)object);
                        }
                    };
                    e e2 = a.this.j.a(retailMap.getId());
                    if (e2 == null) {
                        a a2 = this;
                        synchronized (a2) {
                            Request request = as.a(a.this.a.getContext(), this.c.getId(), retailMap.getId(), true, requestListener);
                            while (!request.isTerminated()) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    } else {
                        requestListener.onRequestFinished((Object)e2);
                    }
                }
            }
        }
    }

    private class c
    implements Runnable {
        private final Retail b;
        private final MapViewLoadListener c;

        c(Retail retail, MapViewLoadListener mapViewLoadListener) {
            this.b = retail;
            this.c = mapViewLoadListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            v.a(a.this.a.getContext(), u.b.e);
            DevLogger.i((String)("IndoorMapView is loading the retail with id " + this.b.getId()));
            RequestListener<List<RetailMap>> requestListener = new RequestListener<List<RetailMap>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void a(final List<RetailMap> list) {
                    Collections.sort(list, RetailMap.getComparatorByFloor());
                    a.this.e = list;
                    a.this.b = c.this.b;
                    if (a.this.e.size() > 0) {
                        a.this.f = new SparseArray(list.size());
                        a.this.g = new HashMap(list.size());
                        for (RetailMap retailMap : list) {
                            a.this.f.append(retailMap.getFloor(), (Object)retailMap);
                            a.this.g.put(retailMap.getId(), retailMap);
                        }
                        if (a.this.g() && c.this.c != null) {
                            a.this.m.post(new Runnable(){

                                @Override
                                public void run() {
                                    c.this.c.onRetailLoadFinished(c.this.b, list);
                                }
                            });
                            a.this.k = new b(c.this.b, c.this.c);
                            a.this.k.start();
                        }
                    }
                    c c2 = c.this;
                    synchronized (c2) {
                        c.this.notifyAll();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onRequestFailed(InLocoMediaException error) {
                    a.this.a(c.this.c, LocationExceptionMapping.parseException(error));
                    c c2 = c.this;
                    synchronized (c2) {
                        c.this.notifyAll();
                    }
                }

                public /* synthetic */ void onRequestFinished(Object object) {
                    this.a((List)object);
                }
            };
            List<RetailMap> list = a.this.j.c();
            if (list == null) {
                Request request = as.c(a.this.a.getContext(), this.b.getId(), requestListener);
                c c2 = this;
                synchronized (c2) {
                    while (!request.isTerminated()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            } else {
                requestListener.onRequestFinished(list);
            }
        }
    }
}

