/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location.exception;

import com.inlocomedia.android.core.exception.ErrorHandler;
import com.inlocomedia.android.core.exception.InLocoMediaAPIException;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.location.exception.RetailMapImageNotFoundException;
import com.inlocomedia.android.location.exception.RetailMapNotFoundException;

public class RetailMapException
extends InLocoMediaAPIException {
    protected static final String RETAIL_MAP = "retail_map";
    protected static final String RETAIL_MAP_NOT_FOUND_ERROR = "retail_map.not_found";
    protected static final String RETAIL_MAP_VECTOR_IMAGE_FOUND_ERROR = "retail_map.vector_image_not_found";
    private static final long serialVersionUID = 7831428233871175099L;
    public static final ErrorHandler ERROR_HANDLER = new ErrorHandler(){

        public boolean shouldHandler(String errorType) {
            return errorType.equals(RetailMapException.RETAIL_MAP);
        }

        public void handle(String error) throws InLocoMediaException {
            switch (error) {
                case "retail_map.not_found": {
                    throw new RetailMapNotFoundException("Retail map not found");
                }
                case "retail_map.vector_image_not_found": {
                    throw new RetailMapImageNotFoundException("RetailMap image not found");
                }
            }
            throw new RetailMapException("");
        }
    };

    public RetailMapException(String error) {
        super(error);
    }

    public RetailMapException(String error, Exception e2) {
        super(error, (Throwable)e2);
    }
}

