/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location.exception;

import com.inlocomedia.android.core.communication.exception.NetworkException;
import com.inlocomedia.android.core.communication.exception.UnauthorizedException;
import com.inlocomedia.android.core.exception.InLocoMediaAPIException;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.exception.InLocoMediaUnavailableException;
import com.inlocomedia.android.core.exception.InvalidAndroidSDKVersion;
import com.inlocomedia.android.core.exception.InvalidMappingException;
import com.inlocomedia.android.core.exception.NetworkUnavailableException;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.location.exception.MapInvalidImageException;
import com.inlocomedia.android.location.exception.RetailException;
import com.inlocomedia.android.location.exception.RetailMapException;
import com.inlocomedia.android.location.exception.RetailMapImageInvalidException;
import com.inlocomedia.android.location.exception.RetailMapImageNotFoundException;
import com.inlocomedia.android.location.exception.RetailMapNotFoundException;
import com.inlocomedia.android.location.exception.RetailNotFoundException;

public final class LocationExceptionMapping {
    private static final String TAG = Logger.makeTag(LocationExceptionMapping.class);

    private LocationExceptionMapping() {
    }

    public static InLocoMediaAPIException parseException(Throwable e2) {
        InLocoMediaAPIException inLocoMediaAPIException = LocationExceptionMapping.parseExceptionAux(e2);
        DevLogger.w((String)inLocoMediaAPIException.getFormattedMessage());
        return inLocoMediaAPIException;
    }

    private static InLocoMediaAPIException parseExceptionAux(Throwable e2) {
        Exception exception;
        if (e2 == null) {
            return new InLocoMediaAPIException("Undefined Error");
        }
        if (e2 instanceof Exception) {
            exception = (Exception)e2;
            if (exception instanceof InvalidAndroidSDKVersion) {
                return new InLocoMediaAPIException(InLocoMediaException.getFormattedMessage((Throwable)exception), (Throwable)exception);
            }
            if (exception instanceof NetworkException) {
                if (exception instanceof com.inlocomedia.android.core.communication.exception.NetworkUnavailableException) {
                    return new NetworkUnavailableException("The network is unavailable. Connect and try again", exception);
                }
                if (exception instanceof UnauthorizedException) {
                    return new InLocoMediaAPIException("You do not have authorization to access this feature. Did you put your application id and secret?", (Throwable)exception);
                }
                return new InLocoMediaAPIException(InLocoMediaException.getFormattedMessage((Throwable)exception), (Throwable)exception);
            }
            if (exception instanceof RetailException) {
                if (exception instanceof RetailNotFoundException) {
                    return new InLocoMediaAPIException("Invalid retail id " + ((RetailNotFoundException)((Object)exception)).getRetailId());
                }
                return new InLocoMediaAPIException("An unregistered retail error was received", (Throwable)exception);
            }
            if (exception instanceof RetailMapException) {
                if (exception instanceof RetailMapNotFoundException) {
                    return new InLocoMediaAPIException("Invalid retail map id " + ((RetailMapNotFoundException)((Object)exception)).getRetailMapId());
                }
                if (exception instanceof RetailMapImageNotFoundException) {
                    return new RetailMapImageInvalidException("No image was found for the selected retail map");
                }
                return new InLocoMediaAPIException("An unregistered retail map error was received", (Throwable)exception);
            }
            if (exception instanceof MapInvalidImageException) {
                return new RetailMapImageInvalidException(exception.getMessage(), exception);
            }
            if (exception instanceof InvalidMappingException) {
                return new InLocoMediaAPIException(exception.getMessage(), (Throwable)exception);
            }
            if (exception instanceof InLocoMediaAPIException) {
                return (InLocoMediaAPIException)exception;
            }
        }
        if (e2 instanceof RuntimeException) {
            exception = (Exception)e2;
            return new InLocoMediaAPIException("Critical error occurred (" + InLocoMediaException.getFormattedMessage((Throwable)e2) + ")", (Throwable)exception);
        }
        if (e2 instanceof Error) {
            return new InLocoMediaAPIException("Critical error occurred (" + InLocoMediaException.getFormattedMessage((Throwable)e2) + ")");
        }
        return new InLocoMediaUnavailableException("An unregistered error was received");
    }
}

