/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location.maps;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import com.inlocomedia.android.core.communication.Request;
import com.inlocomedia.android.core.communication.exception.NetworkException;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.exception.InLocoMediaAPIException;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLoco;
import com.inlocomedia.android.location.core.communication.listeners.StoresRequestListener;
import com.inlocomedia.android.location.exception.InvalidFloorException;
import com.inlocomedia.android.location.exception.LocationExceptionMapping;
import com.inlocomedia.android.location.exception.RetailMapImageInvalidException;
import com.inlocomedia.android.location.exception.RouteUnavailableException;
import com.inlocomedia.android.location.exception.StoresUnavailableException;
import com.inlocomedia.android.location.maps.MapViewLoadListener;
import com.inlocomedia.android.location.maps.views.IndoorMapView;
import com.inlocomedia.android.location.models.Location;
import com.inlocomedia.android.location.models.Retail;
import com.inlocomedia.android.location.models.RetailMap;
import com.inlocomedia.android.location.models.Store;
import com.inlocomedia.android.location.models.e;
import com.inlocomedia.android.location.private.bg;
import com.inlocomedia.android.location.private.bj;
import com.inlocomedia.android.location.private.bo;
import com.inlocomedia.android.location.private.u;
import com.inlocomedia.android.location.private.v;
import com.inlocomedia.android.location.private.z;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class a {
    private static final String a = Logger.makeTag(a.class);
    private final IndoorMapView b;
    private Retail c;
    private RetailMap d;
    private Integer e;
    private List<RetailMap> f;
    private SparseArray<RetailMap> g;
    private HashMap<String, RetailMap> h;
    private final ThreadPoolExecutor i;
    private final LinkedBlockingQueue<Runnable> j;
    private z k;
    private Thread l;
    private MapViewLoadListener m;
    private final Handler n;
    private boolean o;

    public a(IndoorMapView indoorMapView) {
        this.b = indoorMapView;
        this.j = new LinkedBlockingQueue();
        this.i = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.j);
        this.n = new Handler(Looper.getMainLooper());
    }

    public void a(RetailMap retailMap) {
        Integer n2;
        Validator.mainThread((String)"IndoorMapView data change error");
        if (this.b("SetRetailMap") && this.a(n2 = this.a(this.f, retailMap), " a map with floor " + retailMap.getFloor())) {
            this.e = n2;
            this.h();
            this.i.submit(new a(n2, this.m, this.c));
        }
    }

    public void a() {
        Validator.mainThread((String)"IndoorMapView data change error");
        if (this.b("NextFloor")) {
            if (this.e == null) {
                this.e = -1;
            }
            if (this.a(this.e + 1, "a next floor")) {
                Integer n2 = this.e;
                Integer n3 = this.e = Integer.valueOf(this.e + 1);
                this.h();
                this.i.submit(new a(this.e, this.m, this.c));
            }
        }
    }

    public void b() {
        Validator.mainThread((String)"IndoorMapView data change error");
        if (this.b("PreviousFloor")) {
            if (this.e == null) {
                this.e = 1;
            }
            if (this.a(this.e - 1, "a previous floor")) {
                Integer n2 = this.e;
                Integer n3 = this.e = Integer.valueOf(this.e - 1);
                this.h();
                this.i.submit(new a(this.e, this.m, this.c));
            }
        }
    }

    public RetailMap a(int n2) {
        return (RetailMap)((Object)this.g.get(n2));
    }

    public RetailMap a(String string2) {
        return this.h.get(string2);
    }

    public boolean c() {
        return this.d != null && this.a((Integer)(this.e + 1));
    }

    public boolean d() {
        return this.d != null && this.a((Integer)(this.e - 1));
    }

    public boolean e() {
        return this.c != null;
    }

    private boolean b(String string2) {
        if (this.c == null) {
            InLocoMediaAPIException inLocoMediaAPIException = new InLocoMediaAPIException("You need to load a retail before using this operation (" + string2 + ")");
            this.a(this.m, inLocoMediaAPIException);
            return false;
        }
        if (this.f == null) {
            InLocoMediaAPIException inLocoMediaAPIException = new InLocoMediaAPIException("Retail not loaded. Wait the setRetail to finish before using this operation (" + string2 + ")");
            this.a(this.m, inLocoMediaAPIException);
            return false;
        }
        return true;
    }

    private boolean a(Integer n2, String string2) {
        if (!this.a(n2)) {
            InvalidFloorException invalidFloorException = new InvalidFloorException("The retail does not have " + string2);
            this.a(this.m, invalidFloorException);
            return false;
        }
        return true;
    }

    public void a(Retail retail, MapViewLoadListener mapViewLoadListener) {
        Validator.notNull((Object)((Object)retail), (String)"Retail");
        Validator.notNullNorEmpty((String)retail.getId(), (String)"Retail id");
        this.m = mapViewLoadListener;
        this.c = retail;
        this.h();
        this.k = new z(this.b.getContext(), retail.getId());
        this.e = null;
        this.i.submit(new c(retail, this.m));
    }

    public void a(MapViewLoadListener mapViewLoadListener) {
        this.m = mapViewLoadListener;
    }

    public RetailMap b(int n2) {
        for (RetailMap retailMap : this.f) {
            if (retailMap.getFloor() != n2) continue;
            return retailMap;
        }
        return null;
    }

    private void a(final MapViewLoadListener mapViewLoadListener, final InLocoMediaAPIException inLocoMediaAPIException) {
        DevLogger.w((String)("IndoorMapView error: " + inLocoMediaAPIException.getFormattedMessage()));
        if (mapViewLoadListener != null && this.g()) {
            this.n.post(new Runnable(){

                @Override
                public void run() {
                    mapViewLoadListener.onLoadError(inLocoMediaAPIException);
                }
            });
        }
    }

    private Integer a(List<RetailMap> list, RetailMap retailMap) {
        int n2 = 0;
        for (RetailMap retailMap2 : list) {
            if (retailMap2.getId().equals(retailMap.getId())) {
                return n2;
            }
            ++n2;
        }
        return null;
    }

    private boolean a(Integer n2) {
        return n2 != null && n2 >= 0 && n2 < this.f.size();
    }

    public boolean a(Location location) {
        return this.c != null && (location == null || this.c.getId().equals(location.getRetailId()));
    }

    private void h() {
        this.j.clear();
    }

    public void f() {
        this.o = true;
        this.i.shutdownNow();
        if (this.l != null) {
            this.l.interrupt();
            this.l = null;
        }
        this.h();
        this.c = null;
        this.d = null;
        this.f = null;
        this.m = null;
        this.e = null;
    }

    public boolean g() {
        return !this.o && this.b != null;
    }

    class b
    extends Thread {
        private final Retail b;
        private final MapViewLoadListener c;

        public b(Retail retail, MapViewLoadListener mapViewLoadListener) {
            super("InLocoMedia IndoorMapView Extras Thread");
            this.b = retail;
            this.c = mapViewLoadListener;
        }

        @Override
        public void run() {
            Context context;
            if (a.this.g() && (context = a.this.b.getContext()) != null) {
                IndoorMapView.Options options = a.this.b.getOptions();
                this.a(context, this.b, this.c);
                if (a.this.g() && options.isRouteEnabled()) {
                    this.b(context, this.b, this.c);
                }
            }
        }

        private void a(Context context, Retail retail, final MapViewLoadListener mapViewLoadListener) {
            StoresRequestListener storesRequestListener = new StoresRequestListener(){

                @Override
                public void onRequestFinished(List<Store> response) {
                    a.this.b.setStores(response);
                }

                @Override
                public void onRequestFailed(InLocoMediaAPIException error) {
                    StoresUnavailableException storesUnavailableException = new StoresUnavailableException("Stores request has failed. " + error.getLocalizedMessage(), (Exception)error);
                    a.this.a(mapViewLoadListener, storesUnavailableException);
                }
            };
            List<Store> list = a.this.k.a();
            if (list == null) {
                InLoco.requestStores(context, retail.getId(), Locale.getDefault(), storesRequestListener);
            } else {
                storesRequestListener.onRequestFinished(list);
            }
        }

        private void b(Context context, Retail retail, final MapViewLoadListener mapViewLoadListener) {
            RequestListener<bj<bo>> requestListener = new RequestListener<bj<bo>>(){

                public void a(bj<bo> bj2) {
                    a.this.b.setGraph(bj2);
                }

                public void onRequestFailed(InLocoMediaException error) {
                    if (error instanceof NetworkException) {
                        RouteUnavailableException routeUnavailableException = new RouteUnavailableException("Route request has failed", (Exception)((Object)error));
                        a.this.a(mapViewLoadListener, routeUnavailableException);
                    } else {
                        RouteUnavailableException routeUnavailableException = new RouteUnavailableException("Route is unavaialble", (Exception)((Object)error));
                        a.this.a(mapViewLoadListener, routeUnavailableException);
                    }
                }

                public /* synthetic */ void onRequestFinished(Object object) {
                    this.a((bj)object);
                }
            };
            bj<bo> bj2 = a.this.k.b();
            if (bj2 == null) {
                bg.b(context, retail.getId(), requestListener);
            } else {
                requestListener.onRequestFinished(bj2);
            }
        }
    }

    class a
    implements Runnable {
        private final MapViewLoadListener b;
        private final Retail c;
        private final int d;

        public a(int n2, MapViewLoadListener mapViewLoadListener, Retail retail) {
            this.b = mapViewLoadListener;
            this.d = n2;
            this.c = retail;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DevLogger.i((String)("IndoorMapView is loading the retail map at position " + this.d));
            List list = a.this.f;
            if (a.this.b("Load map at index " + this.d)) {
                final RetailMap retailMap = (RetailMap)((Object)list.get(this.d));
                if (a.this.g() && a.this.b("Switch to map " + (Object)((Object)retailMap))) {
                    RequestListener<e> requestListener = new RequestListener<e>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void a(final e e2) {
                            if (a.this.g()) {
                                ThreadPool.executeInMain((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            a.this.d = retailMap;
                                            a.this.b.loadRetailMap(retailMap, e2);
                                            if (a.this.b != null) {
                                                a.this.b.onRetailMapLoadFinished(retailMap);
                                            }
                                        }
                                        catch (RetailMapImageInvalidException retailMapImageInvalidException) {
                                            a.this.a(a.this.b, retailMapImageInvalidException);
                                        }
                                    }
                                });
                            }
                            a a2 = a.this;
                            synchronized (a2) {
                                a.this.notifyAll();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onRequestFailed(InLocoMediaException error) {
                            a a2 = a.this;
                            synchronized (a2) {
                                a.this.notifyAll();
                            }
                            a.this.a(a.this.b, LocationExceptionMapping.parseException(error));
                        }

                        public /* synthetic */ void onRequestFinished(Object object) {
                            this.a((e)object);
                        }
                    };
                    e e2 = a.this.k.a(retailMap.getId());
                    if (e2 == null) {
                        a a2 = this;
                        synchronized (a2) {
                            Request request = bg.a(a.this.b.getContext(), this.c.getId(), retailMap.getId(), true, requestListener);
                            while (!request.isTerminated()) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    } else {
                        requestListener.onRequestFinished((Object)e2);
                    }
                }
            }
        }
    }

    class c
    implements Runnable {
        private final Retail b;
        private final MapViewLoadListener c;

        public c(Retail retail, MapViewLoadListener mapViewLoadListener) {
            this.b = retail;
            this.c = mapViewLoadListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            v.a(a.this.b.getContext(), u.b.e);
            DevLogger.i((String)("IndoorMapView is loading the retail with id " + this.b.getId()));
            RequestListener<List<RetailMap>> requestListener = new RequestListener<List<RetailMap>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void a(final List<RetailMap> list) {
                    Collections.sort(list, RetailMap.getComparatorByFloor());
                    a.this.f = list;
                    a.this.c = c.this.b;
                    if (a.this.f.size() > 0) {
                        a.this.g = new SparseArray(list.size());
                        a.this.h = new HashMap(list.size());
                        for (RetailMap retailMap : list) {
                            a.this.g.append(retailMap.getFloor(), (Object)retailMap);
                            a.this.h.put(retailMap.getId(), retailMap);
                        }
                        if (a.this.g() && c.this.c != null) {
                            a.this.n.post(new Runnable(){

                                @Override
                                public void run() {
                                    c.this.c.onRetailLoadFinished(c.this.b, list);
                                }
                            });
                            a.this.l = new b(c.this.b, c.this.c);
                            a.this.l.start();
                        }
                    }
                    c c2 = c.this;
                    synchronized (c2) {
                        c.this.notifyAll();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onRequestFailed(InLocoMediaException error) {
                    a.this.a(c.this.c, LocationExceptionMapping.parseException(error));
                    c c2 = c.this;
                    synchronized (c2) {
                        c.this.notifyAll();
                    }
                }

                public /* synthetic */ void onRequestFinished(Object object) {
                    this.a((List)object);
                }
            };
            List<RetailMap> list = a.this.k.c();
            if (list == null) {
                Request request = bg.a(a.this.b.getContext(), this.b.getId(), requestListener);
                c c2 = this;
                synchronized (c2) {
                    while (!request.isTerminated()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            } else {
                requestListener.onRequestFinished(list);
            }
        }
    }
}

