/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.common;

import android.support.annotation.NonNull;
import com.inlocomedia.android.common.ConsentState;
import com.inlocomedia.android.core.annotations.ApiAccess;
import java.util.HashMap;
import java.util.Map;

@ApiAccess
public class ConsentResult {
    private final Map<String, ConsentState> result;

    ConsentResult(@NonNull Map<String, ConsentState> result) {
        this.result = result;
    }

    ConsentResult() {
        this.result = new HashMap<String, ConsentState>();
    }

    public boolean areAllConsentTypesGiven() {
        for (Map.Entry<String, ConsentState> entry : this.result.entrySet()) {
            if (entry.getValue().equals((Object)ConsentState.GIVEN)) continue;
            return false;
        }
        return !this.result.isEmpty();
    }

    public boolean isWaitingConsent() {
        for (Map.Entry<String, ConsentState> entry : this.result.entrySet()) {
            if (!entry.getValue().equals((Object)ConsentState.GIVEN) && !entry.getValue().equals((Object)ConsentState.DENIED)) continue;
            return false;
        }
        return !this.result.isEmpty();
    }

    public boolean hasFinished() {
        return !this.result.isEmpty();
    }

    public Map<String, ConsentState> getResult() {
        return this.result;
    }

    @NonNull
    public String toString() {
        return this.result.toString();
    }
}

