/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads;

import com.inlocomedia.android.ads.exception.AdvertisementRequestException;
import com.inlocomedia.android.ads.exception.AdvertisementsUnavailableException;
import com.inlocomedia.android.ads.exception.InvalidResourceException;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.private.cd;
import com.inlocomedia.android.core.private.w;
import com.inlocomedia.android.core.private.x;
import com.inlocomedia.android.core.private.y;

@ApiAccess
public enum AdError {
    NO_FILL("No Fill"),
    INVALID_REQUEST("Invalid Request"),
    NETWORK_NOT_AVAILABLE("Network not available"),
    UNAUTHORIZED("Unauthorized"),
    INTERNAL_ERROR("Internal Error"),
    TIMEOUT("Timeout"),
    GOOGLE_PLAY_SERVICES_NOT_FOUND("GooglePlayServices not found"),
    INVALID_SDK_VERSION("Android SDK version below 14"),
    INVALID_RESOURCE("Invalid resource");

    private String value;

    private AdError(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static AdError fromThrowable(Throwable t2) {
        AdError adError = t2 instanceof x ? TIMEOUT : (t2 instanceof AdvertisementRequestException ? INVALID_REQUEST : (t2 instanceof w ? NETWORK_NOT_AVAILABLE : (t2 instanceof AdvertisementsUnavailableException ? NO_FILL : (t2 instanceof y ? UNAUTHORIZED : (t2 instanceof InvalidResourceException ? INVALID_RESOURCE : INTERNAL_ERROR)))));
        return adError;
    }

    public static void logError(Throwable t2) {
        if (t2 instanceof AdvertisementRequestException || t2 instanceof y) {
            DevLogger.w((String)cd.a((Throwable)t2));
        } else if (!(t2 instanceof x || t2 instanceof w || t2 instanceof AdvertisementsUnavailableException)) {
            DevLogger.w((String)("AdRequest has failed with error: " + cd.a((Throwable)t2)));
        }
    }
}

