/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.inlocomedia.android.ads.core.o;
import com.inlocomedia.android.ads.private.bd;
import com.inlocomedia.android.ads.private.k;
import com.inlocomedia.android.core.util.ai;
import java.util.concurrent.CopyOnWriteArraySet;

public class EnhancedView
extends FrameLayout {
    private boolean mVisible;
    private boolean mAttached;
    private int mOrientation;
    private ai mScreenHelper;
    private ai.a mScreenStateListener;
    private ViewTreeObserver.OnGlobalLayoutListener mOnGlobalLayoutListener;
    @Nullable
    @VisibleForTesting
    protected CopyOnWriteArraySet<a> mListeners;

    public EnhancedView(Context context) {
        super(context);
        this.init();
    }

    public EnhancedView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public EnhancedView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @SuppressLint(value={"NewApi"})
    public EnhancedView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.mVisible = k.d((View)this);
        this.mAttached = k.c((View)this);
        this.mOrientation = 0;
        o.a.a(this.getContext());
        this.mScreenHelper = bd.e();
    }

    public void addEnhancedViewListener(a listener) {
        if (this.mListeners == null) {
            this.mListeners = new CopyOnWriteArraySet();
        }
        this.mListeners.add(listener);
    }

    public void removeEnhancedViewListener(a listener) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
        if (this.mListeners.isEmpty()) {
            this.mListeners = null;
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mOrientation != newConfig.orientation) {
            this.mOrientation = newConfig.orientation;
            this.onOrientationChanged(this.mOrientation);
            if (this.mListeners != null) {
                for (a a2 : this.mListeners) {
                    a2.a(this, this.mOrientation);
                }
            }
        }
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    protected void onOrientationChanged(int orientation) {
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.checkVisibilityHasChanged();
    }

    private void checkVisibilityHasChanged() {
        boolean bl2 = k.d((View)this);
        if (this.mVisible != bl2) {
            this.mVisible = bl2;
            this.onVisibilityChanged(this.mVisible);
            if (this.mListeners != null) {
                for (a a2 : this.mListeners) {
                    a2.a(this, this.mVisible);
                }
            }
        }
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    protected void onVisibilityChanged(boolean visible) {
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttached = true;
        if (this.mScreenStateListener == null) {
            this.mScreenStateListener = new ai.a(){

                public void a(boolean isScreenOn) {
                    EnhancedView.this.checkVisibilityHasChanged();
                }
            };
            this.mScreenHelper.a(this.mScreenStateListener);
        }
        if (this.mOnGlobalLayoutListener == null) {
            this.mOnGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    EnhancedView.this.checkVisibilityHasChanged();
                }
            };
            this.getViewTreeObserver().addOnGlobalLayoutListener(this.mOnGlobalLayoutListener);
        }
        this.notifyAttachmentChanged();
        this.checkVisibilityHasChanged();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAttached = false;
        if (this.mScreenStateListener != null) {
            this.mScreenHelper.b(this.mScreenStateListener);
            this.mScreenStateListener = null;
        }
        if (this.mOnGlobalLayoutListener != null) {
            k.a(this.getViewTreeObserver(), this.mOnGlobalLayoutListener);
            this.mOnGlobalLayoutListener = null;
        }
        this.notifyAttachmentChanged();
        this.checkVisibilityHasChanged();
    }

    private void notifyAttachmentChanged() {
        if (this.mListeners != null) {
            for (a a2 : this.mListeners) {
                a2.b(this, this.mAttached);
            }
        }
    }

    public boolean isAttachedToWindow() {
        return this.mAttached;
    }

    public static class a {
        public void a(EnhancedView enhancedView, boolean bl2) {
        }

        public void b(EnhancedView enhancedView, boolean bl2) {
        }

        public void a(EnhancedView enhancedView, int n2) {
        }
    }
}

