/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.notification;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.NotificationCompat;
import android.webkit.URLUtil;
import com.inlocomedia.android.ads.AdActivity;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.R;
import com.inlocomedia.android.ads.core.a;
import com.inlocomedia.android.ads.core.n;
import com.inlocomedia.android.ads.core.o;
import com.inlocomedia.android.ads.models.NotificationAd;
import com.inlocomedia.android.ads.notification.NotificationAdRequest;
import com.inlocomedia.android.ads.notification.NotificationAdResponse;
import com.inlocomedia.android.ads.notification.b;
import com.inlocomedia.android.ads.notification.c;
import com.inlocomedia.android.ads.notification.d;
import com.inlocomedia.android.ads.notification.f;
import com.inlocomedia.android.ads.private.af;
import com.inlocomedia.android.ads.private.bd;
import com.inlocomedia.android.ads.private.j;
import com.inlocomedia.android.ads.private.z;
import com.inlocomedia.android.ads.profile.UserProfile;
import com.inlocomedia.android.core.c;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.permissions.PermissionResult;
import com.inlocomedia.android.core.permissions.PermissionsListener;
import com.inlocomedia.android.core.private.bt;
import com.inlocomedia.android.core.private.du;
import com.inlocomedia.android.core.private.dv;
import com.inlocomedia.android.core.private.dw;
import com.inlocomedia.android.core.private.dy;
import com.inlocomedia.android.core.private.dz;
import com.inlocomedia.android.core.private.ec;
import com.inlocomedia.android.core.private.ed;
import com.inlocomedia.android.core.private.ei;
import com.inlocomedia.android.core.profile.Device;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.core.util.p;
import com.inlocomedia.android.location.InLoco;
import com.inlocomedia.android.location.InLocoPrivate;
import com.inlocomedia.android.location.geofencing.SimpleGeofence;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class e
implements d {
    private static final String a = com.inlocomedia.android.core.log.c.a(e.class);
    private static final long b = TimeUnit.SECONDS.toMillis(5L);
    private p c;
    private final Map<String, NotificationAdResponse> d;
    private final com.inlocomedia.android.core.log.b e;
    private final com.inlocomedia.android.ads.core.c f;

    public e(Context context, com.inlocomedia.android.ads.core.c c2, com.inlocomedia.android.core.log.b b2) {
        com.inlocomedia.android.core.a.a((Context)context);
        this.c = new p(60000L);
        this.d = Collections.synchronizedMap(new HashMap());
        this.f = c2;
        this.e = b2;
    }

    @Override
    public void a(final Activity activity, final boolean bl2) {
        dw.m().b((ei)dy.b()).b((dz)new ed(){

            public void a() {
                boolean bl22;
                o.f.a(activity.getApplicationContext());
                boolean bl3 = bl22 = com.inlocomedia.android.ads.notification.f.c((Context)activity) != bl2;
                if (bl22 && com.inlocomedia.android.ads.notification.e.c((Context)activity)) {
                    if (bl2) {
                        e.this.a(activity, new PermissionsListener(){

                            public void onPermissionRequestCompleted(final HashMap<String, PermissionResult> permissionResultHashMap) {
                                dw.m().b((ei)dy.b()).b((dz)new ed(){

                                    public void a() {
                                        PermissionResult permissionResult = (PermissionResult)permissionResultHashMap.get("android.permission.ACCESS_FINE_LOCATION");
                                        if (permissionResult != null && permissionResult.isAuthorized()) {
                                            if (!com.inlocomedia.android.ads.util.d.a((Context)activity)) {
                                                DevLogger.w((String)"Notifications could not be enabled. Did you add the 'com.google.android.gms:play-services-location' dependency?");
                                                return;
                                            }
                                            DevLogger.i((String)"Enabling Notifications");
                                            e.this.c = new p(60000L);
                                            InLocoPrivate.Geofencing.registerListener((Context)activity, d.a.class, (String)"push");
                                            com.inlocomedia.android.ads.notification.f.a((Context)activity, true);
                                        } else {
                                            DevLogger.w((String)"Notification error: Missing required permission android.permission.ACCESS_FINE_LOCATION");
                                        }
                                    }
                                }).a(new ec(){

                                    public void a(Throwable t2) {
                                        e.this.e.a(a, t2, (com.inlocomedia.android.core.e)c.b.c);
                                    }
                                }).b();
                            }
                        });
                    } else {
                        DevLogger.i((String)"Disabling notifications");
                        InLocoPrivate.Geofencing.unregisterListener((Context)activity, (String)"push");
                    }
                    com.inlocomedia.android.ads.notification.f.a((Context)activity, bl2);
                }
            }
        }).a((Thread.UncaughtExceptionHandler)o.e).b();
    }

    private void a(Activity activity, PermissionsListener permissionsListener) {
        boolean bl2 = com.inlocomedia.android.ads.notification.f.d((Context)activity);
        com.inlocomedia.android.core.permissions.b b2 = bd.b();
        if (bl2) {
            String[] stringArray = new String[]{"android.permission.ACCESS_FINE_LOCATION"};
            b2.a((Context)activity, stringArray, true, permissionsListener);
        } else {
            HashMap<String, PermissionResult> hashMap = new HashMap<String, PermissionResult>();
            PermissionResult permissionResult = new PermissionResult(b2.b((Context)activity, "android.permission.ACCESS_FINE_LOCATION"), false);
            hashMap.put("android.permission.ACCESS_FINE_LOCATION", permissionResult);
            permissionsListener.onPermissionRequestCompleted(hashMap);
        }
    }

    @Override
    public void a(Context context, NotificationAdRequest notificationAdRequest) {
        Validator.notNull((Object)context, (String)"Context");
        Validator.notNull((Object)notificationAdRequest, (String)"Notification Ad Request");
        try {
            if (Validator.isValidSDKVersion()) {
                com.inlocomedia.android.ads.notification.f.a(context, notificationAdRequest.getAdUnitId());
                com.inlocomedia.android.ads.notification.f.b(context, notificationAdRequest.getChannelId());
                com.inlocomedia.android.ads.notification.f.a(context, notificationAdRequest.getNotificationIconResourceId());
                com.inlocomedia.android.ads.notification.f.b(context, notificationAdRequest.isAskForPermissionEnabled());
            }
        }
        catch (Throwable throwable) {
            this.e.a(a, throwable, (com.inlocomedia.android.core.e)o.e);
        }
    }

    @Override
    public boolean a(Context context) {
        try {
            return com.inlocomedia.android.ads.notification.f.c(context);
        }
        catch (Throwable throwable) {
            this.e.a(a, throwable, (com.inlocomedia.android.core.e)o.e);
            return false;
        }
    }

    @Override
    public void a(Context context, Intent intent) {
        DevLogger.i((String)"Notification clicked");
        try {
            NotificationAd notificationAd = (NotificationAd)intent.getSerializableExtra("com.android.inlocomedia.ads.notification_click_extra");
            AdActivity.startActivity(context, af.a(notificationAd, com.inlocomedia.android.ads.core.a.b(notificationAd, notificationAd.getFirstContentUrlKey())).a());
        }
        catch (Throwable throwable) {
            this.e.a(a, throwable, (com.inlocomedia.android.core.e)o.e);
        }
    }

    @Override
    public void a(int n2, Collection<SimpleGeofence> collection) {
        try {
            String string2;
            if (!this.a(com.inlocomedia.android.core.a.a())) {
                return;
            }
            String string3 = string2 = InLocoPrivate.Geofencing.containsEnterTransition((int)n2) || InLocoPrivate.Geofencing.containsDwellTransition((int)n2) || InLocoPrivate.Geofencing.containsPollingTransition((int)n2) ? "com.inlocomedia.location.event.actions.INSIDE" : "com.inlocomedia.location.event.actions.OUTSIDE";
            if (InLocoPrivate.Geofencing.containsEnterTransition((int)n2) || InLocoPrivate.Geofencing.containsDwellTransition((int)n2) || InLocoPrivate.Geofencing.containsPollingTransition((int)n2)) {
                for (SimpleGeofence simpleGeofence : collection) {
                    if (simpleGeofence.type != 1 || !simpleGeofence.category.equals("push")) continue;
                    this.a();
                    break;
                }
            }
            Intent intent = new Intent(string2);
            intent.setPackage(com.inlocomedia.android.core.a.a().getPackageName());
            com.inlocomedia.android.core.a.a().sendBroadcast(intent);
        }
        catch (Throwable throwable) {
            this.e.a(a, throwable, (com.inlocomedia.android.core.e)o.e);
        }
    }

    @VisibleForTesting
    protected void a() {
        dw.m().b((ei)dy.b()).b((dz)new ed(){

            public void a() {
                if (e.this.c.a()) {
                    AdRequest adRequest = new AdRequest();
                    adRequest.setUserProfile(UserProfile.getSavedProfile(com.inlocomedia.android.core.a.a()));
                    adRequest.setAdUnitId(com.inlocomedia.android.ads.notification.f.a(com.inlocomedia.android.core.a.a()));
                    DevLogger.i((String)("Requesting Notification. " + adRequest));
                    com.inlocomedia.android.ads.models.a a2 = new com.inlocomedia.android.ads.models.a(AdType.NOTIFICATION, adRequest, 25);
                    com.inlocomedia.android.ads.core.b<com.inlocomedia.android.ads.core.e> b2 = e.this.a(a2);
                    e.this.f.a(b2);
                }
            }
        }).a(new ec(){

            public void a(Throwable t2) {
                e.this.c.b();
            }
        }).a((Thread.UncaughtExceptionHandler)o.e).b(b).b();
    }

    @VisibleForTesting
    protected com.inlocomedia.android.ads.core.b<com.inlocomedia.android.ads.core.e> a(com.inlocomedia.android.ads.models.a a2) {
        return new com.inlocomedia.android.ads.core.b<com.inlocomedia.android.ads.core.e>(com.inlocomedia.android.core.a.a(), a2, (com.inlocomedia.android.ads.core.f)new c()){

            @Override
            public void a(com.inlocomedia.android.ads.core.e e2) {
                NotificationAd notificationAd = (NotificationAd)e2.c();
                if (notificationAd != null) {
                    DevLogger.i((String)"NotificationAd received");
                    if (this.a(notificationAd)) {
                        b.a a2 = e.this.b();
                        b b2 = new b(a2);
                        b2.a(notificationAd);
                    } else {
                        this.a(AdError.INVALID_REQUEST);
                    }
                }
            }

            @Override
            public void a(AdError adError) {
                DevLogger.w((String)("Notification request has failed with error: " + (Object)((Object)adError)));
                e.this.c.b();
            }

            private boolean a(NotificationAd notificationAd) {
                boolean bl2 = Device.canHandleIntentForUri((Context)com.inlocomedia.android.core.a.a(), (String)notificationAd.getFirstDeeplinkUrl());
                boolean bl3 = !Validator.isNullOrEmpty((String)notificationAd.getHtml());
                boolean bl4 = URLUtil.isValidUrl((String)notificationAd.getHtmlUrl());
                if (!(bl3 || bl4 || bl2)) {
                    if (notificationAd.getFirstDeeplinkUrl() != null) {
                        DevLogger.w((String)("No listener for the url " + notificationAd.getFirstDeeplinkUrl()));
                    } else {
                        DevLogger.w((String)"The notification does not have any displayable content");
                    }
                    return false;
                }
                return true;
            }
        };
    }

    b.a b() {
        return new b.a(){

            @Override
            public void a(NotificationAdResponse notificationAdResponse) {
                try {
                    long l2 = System.currentTimeMillis();
                    com.inlocomedia.android.ads.notification.f.a(com.inlocomedia.android.core.a.a(), l2);
                    Intent intent = new Intent("com.inlocomedia.android.ads.actions.NOTIFICATION_READY");
                    intent.putExtra("NOTIFICATION_EXTRA_ID", Long.toString(l2));
                    intent.setPackage(com.inlocomedia.android.core.a.a().getPackageName());
                    if (e.this.b(com.inlocomedia.android.core.a.a(), intent)) {
                        e.this.a(l2, notificationAdResponse, intent);
                    } else {
                        e.this.a(notificationAdResponse);
                    }
                }
                catch (Throwable throwable) {
                    e.this.e.a(a, throwable, (com.inlocomedia.android.core.e)o.e);
                }
                e.this.c.b();
            }

            @Override
            public void a(bt bt2) {
                DevLogger.w((String)"Notification request has failed", (Throwable)bt2);
                e.this.c.b();
            }
        };
    }

    @VisibleForTesting
    protected void a(long l2, NotificationAdResponse notificationAdResponse, Intent intent) {
        this.d.put(Long.toString(l2), notificationAdResponse);
        com.inlocomedia.android.core.a.a().sendBroadcast(intent);
    }

    @VisibleForTesting
    protected boolean b(Context context, Intent intent) {
        return !context.getPackageManager().queryBroadcastReceivers(intent, 65536).isEmpty();
    }

    @Override
    @Nullable
    public NotificationAdResponse a(String string2) {
        NotificationAdResponse notificationAdResponse = null;
        try {
            notificationAdResponse = this.d.get(string2);
        }
        catch (Throwable throwable) {
            this.e.a(a, throwable, (com.inlocomedia.android.core.e)o.e);
        }
        return notificationAdResponse;
    }

    @Override
    public void b(String string2) {
        try {
            NotificationAdResponse notificationAdResponse = this.d.remove(string2);
            if (notificationAdResponse != null) {
                this.a(notificationAdResponse);
            }
        }
        catch (Throwable throwable) {
            this.e.a(a, throwable, (com.inlocomedia.android.core.e)o.e);
        }
    }

    @Override
    public boolean c(String string2) {
        NotificationAdResponse notificationAdResponse = null;
        try {
            notificationAdResponse = this.d.remove(string2);
        }
        catch (Throwable throwable) {
            this.e.a(a, throwable, (com.inlocomedia.android.core.e)o.e);
        }
        return notificationAdResponse != null;
    }

    @VisibleForTesting
    protected void a(NotificationAdResponse notificationAdResponse) {
        if (com.inlocomedia.android.ads.notification.f.c(com.inlocomedia.android.core.a.a())) {
            NotificationManager notificationManager;
            NotificationCompat.BigPictureStyle bigPictureStyle;
            PendingIntent pendingIntent = n.a(com.inlocomedia.android.core.a.a(), notificationAdResponse.getNotificationAd());
            du du2 = new du.a().a(R.string.ilm_notification_channel_name).b(R.string.ilm_notification_channel_description).a("In Loco Ads").a(Boolean.valueOf(notificationAdResponse.isVibrationEnabled())).c(3).a();
            String string2 = dv.a((Context)com.inlocomedia.android.core.a.a(), (String)com.inlocomedia.android.ads.notification.f.e(com.inlocomedia.android.core.a.a()), (du)du2);
            NotificationCompat.Builder builder = new NotificationCompat.Builder(com.inlocomedia.android.core.a.a(), string2);
            builder.setAutoCancel(true);
            builder.setContentIntent(pendingIntent);
            builder.setContentTitle((CharSequence)notificationAdResponse.getTitle());
            builder.setContentText((CharSequence)notificationAdResponse.getDescription());
            builder.setSmallIcon(com.inlocomedia.android.ads.notification.e.d(com.inlocomedia.android.core.a.a()));
            if (notificationAdResponse.getIcon() != null) {
                builder.setLargeIcon(notificationAdResponse.getIcon());
            }
            if (notificationAdResponse.getImage() != null) {
                bigPictureStyle = new NotificationCompat.BigPictureStyle(builder);
                bigPictureStyle.bigPicture(notificationAdResponse.getImage());
                bigPictureStyle.setSummaryText((CharSequence)notificationAdResponse.getDescription());
            } else {
                bigPictureStyle = new NotificationCompat.BigTextStyle(builder);
                bigPictureStyle.bigText((CharSequence)notificationAdResponse.getDescription());
            }
            bigPictureStyle = builder.build();
            if (notificationAdResponse.getNotificationAd().isSoundEnabled()) {
                bigPictureStyle.defaults |= 1;
            }
            if (notificationAdResponse.getNotificationAd().isVibrationEnabled() && j.d(com.inlocomedia.android.core.a.a())) {
                bigPictureStyle.defaults |= 2;
            }
            if ((notificationManager = (NotificationManager)com.inlocomedia.android.core.a.a().getSystemService("notification")) != null) {
                notificationManager.notify(8233, (Notification)bigPictureStyle);
            }
            z z2 = new z(notificationAdResponse.getNotificationAd());
            z2.a(com.inlocomedia.android.core.a.a());
        }
    }

    private static boolean c(Context context) {
        if (!Validator.isValidSDKVersion()) {
            DevLogger.w((String)("Notifications could not be toggled: " + (Object)((Object)AdError.INVALID_SDK_VERSION)));
            return false;
        }
        if (!j.b(context)) {
            DevLogger.w((String)"Notifications could not be enabled. You must register your application for ads before using this service");
            return false;
        }
        if (!o.e.a()) {
            DevLogger.w((String)"Notifications could not be enabled: Invalid application state. Check your log for more details");
            return false;
        }
        if (!InLoco.isLocationTrackingEnabled((Context)context)) {
            DevLogger.w((String)"Notifications could not be enabled. You must enable background location tracking before using this service");
            return false;
        }
        return j.e(context);
    }

    private static int d(Context context) {
        int n2 = com.inlocomedia.android.ads.notification.e.e(context);
        if (n2 == 0) {
            n2 = com.inlocomedia.android.ads.notification.e.f(context);
        }
        return n2;
    }

    private static int e(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            return bundle.getInt("com.inlocomedia.android.ads.notification_ad_icon");
        }
        catch (Throwable throwable) {
            DevLogger.e((String)"Could not find notification icon resource id in the manifest.");
            return 0;
        }
    }

    private static int f(Context context) {
        return com.inlocomedia.android.ads.notification.f.b(context);
    }
}

