/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.util;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import android.widget.ImageView;
import com.inlocomedia.android.ads.util.ImageViewDownloadManager;
import com.inlocomedia.android.core.private.ab;

public class ImageRequest {
    private static final boolean DEFAULT_SHOW_PLACEHOLDER = false;
    private static final boolean DEFAULT_SHOW_ERROR = false;
    private int mMaxWidth;
    private int mMaxHeight;
    private Drawable mPlaceholderDrawable = null;
    private Drawable mErrorDrawable = null;
    private boolean mShowPlaceholderImage = false;
    private boolean mShowErrorImage = false;
    private ab<Void> mListener = null;
    private String mUrl = null;
    private ImageView mTarget;
    private Context mContext;
    private boolean mMemoryCacheEnable;

    ImageRequest(Context context) {
        this.mContext = context;
        this.mMemoryCacheEnable = true;
        if (context != null) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            this.mMaxWidth = displayMetrics.widthPixels;
            this.mMaxHeight = displayMetrics.heightPixels;
        } else {
            this.mMaxWidth = Integer.MAX_VALUE;
            this.mMaxHeight = Integer.MAX_VALUE;
        }
    }

    public ImageRequest load(String url) {
        if (url == null || url.trim().length() == 0) {
            throw new IllegalArgumentException("Url must not be empty.");
        }
        this.mUrl = url;
        return this;
    }

    public ImageRequest maxHeight(int maxHeight) {
        this.mMaxHeight = maxHeight;
        return this;
    }

    public ImageRequest maxWidth(int maxWidth) {
        this.mMaxWidth = maxWidth;
        return this;
    }

    public ImageRequest placeholderDrawable(Drawable placeholderDrawable) {
        this.mPlaceholderDrawable = placeholderDrawable;
        return this;
    }

    public ImageRequest errorDrawable(Drawable errorDrawable) {
        this.mErrorDrawable = errorDrawable;
        return this;
    }

    public ImageRequest showPlaceholderImage(boolean showPlaceholderImage) {
        this.mShowPlaceholderImage = showPlaceholderImage;
        return this;
    }

    public ImageRequest showErrorImage(boolean showErrorImage) {
        this.mShowErrorImage = showErrorImage;
        return this;
    }

    public boolean into(@NonNull ImageView target) {
        this.mTarget = target;
        return ImageViewDownloadManager.downloadAndSet(this);
    }

    public ImageRequest listener(ab<Void> listener) {
        this.mListener = listener;
        return this;
    }

    public ImageRequest memoryCacheEnable(boolean memoryCacheEnable) {
        this.mMemoryCacheEnable = memoryCacheEnable;
        return this;
    }

    public ImageView getImageView() {
        return this.mTarget;
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public int getMaxHeight() {
        return this.mMaxHeight;
    }

    Drawable getPlaceholderDrawable() {
        return this.mPlaceholderDrawable;
    }

    Drawable getErrorDrawable() {
        return this.mErrorDrawable;
    }

    boolean hasPlaceholderImage() {
        return this.mShowPlaceholderImage;
    }

    boolean hasErrorImage() {
        return this.mShowErrorImage;
    }

    protected String getUrl() {
        return this.mUrl;
    }

    @Nullable
    protected ab<Void> getListener() {
        return this.mListener;
    }

    protected Context getContext() {
        return this.mContext;
    }

    boolean isMemoryCacheEnabled() {
        return this.mMemoryCacheEnable;
    }
}

