/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.inlocomedia.android.ads.R;
import com.inlocomedia.android.ads.private.bh;
import com.inlocomedia.android.ads.private.i;
import com.inlocomedia.android.ads.views.EnhancedView;
import com.inlocomedia.android.core.util.ag;
import com.inlocomedia.android.core.util.ai;
import com.inlocomedia.android.core.util.h;

public class CloseableLayout
extends EnhancedView {
    @SuppressLint(value={"RtlHardcoded"})
    @VisibleForTesting
    static final int DEFAULT_CLOSE_POSITION_GRAVITY = 53;
    @VisibleForTesting
    static final float CLOSE_REGION_SIZE_DP = 50.0f;
    @VisibleForTesting
    static final float CLOSE_BUTTON_PADDING_DP = 8.0f;
    private static final boolean DEFAULT_CLOSE_ENABLED = false;
    private final Rect mCloseRegionBounds = new Rect();
    private final Rect mCloseButtonBounds = new Rect();
    private final Rect mClosableLayoutRect = new Rect();
    private final Rect mInsetCloseRegionBounds = new Rect();
    private int mTouchSlop;
    @NonNull
    private StateListDrawable mCloseDrawable = new StateListDrawable();
    private int mCloseRegionSize;
    private int mCloseButtonPadding;
    private boolean mCloseEnabled;
    private boolean mCloseOffScreenEnabled;
    @SuppressLint(value={"RtlHardcoded"})
    private int mCloseButtonGravity;
    private boolean mCloseBoundChanged;
    @Nullable
    private a mUnsetPressedState;

    @SuppressLint(value={"NewApi"})
    public CloseableLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    public CloseableLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public CloseableLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public CloseableLayout(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mCloseDrawable.addState(SELECTED_STATE_SET, h.a((Context)context, (int)R.drawable.ilm_interstitial_ad_close_button_pressed));
        this.mCloseDrawable.addState(EMPTY_STATE_SET, h.a((Context)context, (int)R.drawable.ilm_interstitial_ad_close_button_normal));
        this.mCloseDrawable.setState(EMPTY_STATE_SET);
        this.mCloseDrawable.setCallback((Drawable.Callback)this);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        ai ai2 = bh.e();
        this.mCloseRegionSize = (int)ai2.a(50.0f);
        this.mCloseButtonPadding = (int)ai2.a(8.0f);
        this.setCloseButtonGravity(53);
        this.setCloseEnabled(false);
        this.setWillNotDraw(false);
    }

    protected void onClose() {
    }

    public int getCloseButtonGravity() {
        return this.mCloseButtonGravity;
    }

    public void setCloseButtonGravity(int gravity) {
        if (this.mCloseButtonGravity == gravity) {
            return;
        }
        this.mCloseButtonGravity = gravity;
        this.mCloseBoundChanged = true;
        this.invalidate();
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.mCloseBoundChanged = true;
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.mCloseBoundChanged) {
            this.mCloseBoundChanged = false;
            this.mClosableLayoutRect.set(0, 0, this.getWidth(), this.getHeight());
            this.applyCloseRegionBounds(this.mCloseButtonGravity, this.mClosableLayoutRect, this.mCloseRegionBounds);
            this.mInsetCloseRegionBounds.set(this.mCloseRegionBounds);
            this.mInsetCloseRegionBounds.inset(this.mCloseButtonPadding, this.mCloseButtonPadding);
            this.applyCloseButtonBounds(this.mCloseButtonGravity, this.mInsetCloseRegionBounds, this.mCloseButtonBounds);
            this.mCloseDrawable.setBounds(this.mCloseButtonBounds);
        }
        if (this.mCloseDrawable.isVisible()) {
            this.mCloseDrawable.draw(canvas);
        }
    }

    private void applyCloseRegionBounds(int gravity, Rect bounds, Rect closeBounds) {
        this.applyCloseBoundsWithSize(gravity, this.mCloseRegionSize, this.mCloseRegionSize, bounds, closeBounds);
    }

    private void applyCloseButtonBounds(int gravity, Rect bounds, Rect outBounds) {
        int n2 = this.mCloseDrawable.getCurrent().getIntrinsicWidth();
        int n3 = this.mCloseDrawable.getCurrent().getIntrinsicHeight();
        this.applyCloseBoundsWithSize(gravity, n2, n3, bounds, outBounds);
    }

    private void applyCloseBoundsWithSize(int gravity, int w2, int h2, Rect bounds, Rect outBounds) {
        if (!this.mCloseOffScreenEnabled) {
            Rect rect = new Rect();
            i.a(this.getRootView(), rect);
            rect.offset(-this.getLeft(), -this.getTop());
            if (!rect.contains(bounds)) {
                ag.a((Rect)bounds, (Rect)rect);
            }
        }
        Gravity.apply((int)gravity, (int)w2, (int)h2, (Rect)bounds, (Rect)outBounds);
    }

    public boolean onInterceptTouchEvent(@NonNull MotionEvent event) {
        if (!this.mCloseEnabled || event.getAction() != 0) {
            return super.onInterceptTouchEvent(event);
        }
        int n2 = (int)event.getX();
        int n3 = (int)event.getY();
        return this.pointInCloseBounds(n2, n3, 0);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        int n2;
        if (!this.mCloseEnabled) {
            return super.onTouchEvent(event);
        }
        int n3 = (int)event.getX();
        if (!this.pointInCloseBounds(n3, n2 = (int)event.getY(), this.mTouchSlop)) {
            this.setClosePressed(false);
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                this.setClosePressed(true);
                break;
            }
            case 3: {
                this.setClosePressed(false);
                break;
            }
            case 1: {
                if (!this.isClosePressed()) break;
                if (this.mUnsetPressedState == null) {
                    this.mUnsetPressedState = new a();
                }
                this.postDelayed(this.mUnsetPressedState, ViewConfiguration.getPressedStateDuration());
                this.performClose();
            }
        }
        return true;
    }

    private void performClose() {
        this.playSoundEffect(0);
        this.onClose();
    }

    @VisibleForTesting
    boolean isClosePressed() {
        return this.mCloseDrawable.getState() == SELECTED_STATE_SET;
    }

    private void setClosePressed(boolean pressed) {
        if (pressed == this.isClosePressed()) {
            return;
        }
        this.mCloseDrawable.setState(pressed ? SELECTED_STATE_SET : EMPTY_STATE_SET);
        this.invalidate(this.mCloseRegionBounds);
    }

    @VisibleForTesting
    boolean pointInCloseBounds(int x2, int y2, int slop) {
        return x2 >= this.mCloseRegionBounds.left - slop && y2 >= this.mCloseRegionBounds.top - slop && x2 < this.mCloseRegionBounds.right + slop && y2 < this.mCloseRegionBounds.bottom + slop;
    }

    @VisibleForTesting
    Rect getCloseBounds() {
        return this.mCloseRegionBounds;
    }

    @VisibleForTesting
    void setCloseBounds(Rect closeBounds) {
        this.mCloseRegionBounds.set(closeBounds);
    }

    @VisibleForTesting
    void setCloseBoundChanged(boolean changed) {
        this.mCloseBoundChanged = changed;
    }

    public boolean isCloseVisible() {
        return this.mCloseDrawable.isVisible();
    }

    public void setCloseVisible(boolean visible) {
        if (this.mCloseDrawable.setVisible(visible, false)) {
            this.invalidate(this.mCloseRegionBounds);
        }
    }

    public boolean isCloseEnabled() {
        return this.mCloseEnabled;
    }

    public void setCloseEnabled(boolean enabled) {
        this.mCloseEnabled = enabled;
        this.setCloseVisible(enabled);
    }

    public boolean isCloseOffScreenEnabled() {
        return this.mCloseOffScreenEnabled;
    }

    public void setCloseOffScreenEnabled(boolean enabled) {
        if (this.mCloseOffScreenEnabled != enabled) {
            this.mCloseOffScreenEnabled = enabled;
            this.mCloseBoundChanged = true;
        }
    }

    private final class a
    implements Runnable {
        private a() {
        }

        @Override
        public void run() {
            CloseableLayout.this.setClosePressed(false);
        }
    }
}

