/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.AttributeSet;
import android.view.View;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.AdViewListener;
import com.inlocomedia.android.ads.R;
import com.inlocomedia.android.ads.core.AdContentView;
import com.inlocomedia.android.ads.core.b;
import com.inlocomedia.android.ads.core.c;
import com.inlocomedia.android.ads.core.f;
import com.inlocomedia.android.ads.core.h;
import com.inlocomedia.android.ads.core.j;
import com.inlocomedia.android.ads.core.o;
import com.inlocomedia.android.ads.exception.AdvertisementException;
import com.inlocomedia.android.ads.private.ak;
import com.inlocomedia.android.ads.private.al;
import com.inlocomedia.android.ads.private.bh;
import com.inlocomedia.android.ads.private.bm;
import com.inlocomedia.android.ads.private.h;
import com.inlocomedia.android.ads.profile.UserProfile;
import com.inlocomedia.android.ads.views.EnhancedView;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.InvalidatableRunnable;
import com.inlocomedia.android.core.util.ScreenHelper;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.TimeUtils;
import com.inlocomedia.android.core.util.Validator;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class AdView
extends AdContentView {
    public static final String TAG = Logger.makeTag(AdView.class);
    private static final int UNLOADED = 0;
    private static final int LOADING = 1;
    private static final int DEFAULT = 2;
    private static final int RESIZED = 3;
    private static final int EXPANDED = 4;
    private static final int ON_AD_ERROR = 5;
    private static final int DESTROYED = 6;
    private static final int REFRESH_DISABLED = 0;
    private static final int REFRESH_INTERVAL_DEFAULT = 30000;
    protected static final boolean LOAD_ON_ATTACH_DEFAULT_VALUE = false;
    private int mLoadState;
    private AdViewListener mAdViewListener;
    private bm mViewabilityTracker;
    @VisibleForTesting
    private long mRequestStartedTimestamp;
    @VisibleForTesting
    private long mRequestCompletedTimestamp;
    @VisibleForTesting
    private AdRequest mAdRequest;
    private a mAdRefresher;
    private long mRefreshInterval;
    private boolean mLoadOnAttach;
    private String mAdUnitId;
    private al mCurrentAd;
    private al mAdToLoadAfterCollapsing;
    private c adRequestManager;
    private com.inlocomedia.android.ads.util.b adLoadTimer;
    private h.a mAdViewControllerInterface = new h.a(){

        @Override
        public final void a(al al2) {
            AdView.this.mRequestCompletedTimestamp = SystemClock.elapsedRealtime();
            AdView.this.mLoadState = 2;
            if (AdView.this.mCurrentAd != null) {
                AdView.this.mViewabilityTracker.a(AdView.this.mCurrentAd);
            }
            AdView.this.mViewabilityTracker.a(al2, (View)AdView.this, new bm.b(){

                @Override
                public void a() {
                    AdView.this.onVisualizationRegistered();
                }

                @Override
                public void a(boolean bl2) {
                }
            });
            AdView.this.mCurrentAd = al2;
            AdView.this.adLoadTimer.a(al2, true);
            DevLogger.i((String)"AdView is ready");
            AdView.this.mAdRefresher.a();
            if (AdView.this.mAdViewListener != null) {
                AdView.this.mAdViewListener.onAdViewReady(AdView.this);
            }
        }

        @Override
        public boolean b(al al2) {
            return AdView.this.mViewabilityTracker.b(al2);
        }

        @Override
        public void a() {
            if (AdView.this.mAdViewListener != null) {
                AdView.this.mAdViewListener.onAdLeftApplication(AdView.this);
            }
        }

        @Override
        public void a(AdError adError) {
            AdView.this.mLoadState = 5;
            AdView.this.notifyAdError(adError);
            AdView.this.mAdRefresher.a();
        }

        @Override
        public void a(EnhancedView enhancedView) {
            AdView.this.mLoadState = 4;
            AdView.this.mAdRefresher.c();
            AdView.this.mViewabilityTracker.a(AdView.this.mCurrentAd, (View)enhancedView);
        }

        @Override
        public void b(EnhancedView enhancedView) {
            AdView.this.mLoadState = 3;
            AdView.this.mAdRefresher.c();
            AdView.this.mViewabilityTracker.a(AdView.this.mCurrentAd, (View)enhancedView);
        }

        @Override
        public void b() {
            if (AdView.this.mLoadState == 4 || AdView.this.mLoadState == 3) {
                AdView.this.mLoadState = 2;
                AdView.this.mViewabilityTracker.a(AdView.this.mCurrentAd, (View)AdView.this);
                if (AdView.this.mAdToLoadAfterCollapsing != null) {
                    AdView.this.loadFrom(AdView.this.mAdToLoadAfterCollapsing, AdView.this.mAdViewControllerInterface);
                    AdView.this.mAdToLoadAfterCollapsing = null;
                } else {
                    AdView.this.mAdRefresher.b();
                }
            }
        }
    };

    public AdView(Context context) {
        super(context);
        this.init(context, null);
    }

    public AdView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AdView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    @SuppressLint(value={"NewApi"})
    public AdView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        o.e.a(this.getContext());
        this.adLoadTimer = new com.inlocomedia.android.ads.util.b();
        this.mLoadOnAttach = false;
        this.mRefreshInterval = 30000L;
        this.mViewabilityTracker = new bm();
        this.mAdRefresher = new a(this);
        this.adRequestManager = bh.i();
        this.mLoadState = 0;
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ilmAdView);
            boolean bl2 = typedArray.getBoolean(R.styleable.ilmAdView_ilmLoadOnAttach, false);
            this.setLoadOnAttach(bl2);
            String string = typedArray.getString(R.styleable.ilmAdView_ilmAdUnitId);
            this.setAdUnitId(string);
            typedArray.recycle();
        }
    }

    @Override
    protected final void onVisibilityChanged(boolean visible) {
        super.onVisibilityChanged(visible);
        if (this.isInEditMode() || !Validator.isValidSDKVersion()) {
            return;
        }
        if (visible) {
            this.mAdRefresher.b();
        } else {
            this.mAdRefresher.c();
        }
    }

    @Override
    protected final void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            return;
        }
        if (this.mLoadState == 0 && this.mLoadOnAttach) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    AdView.this.loadAd();
                }
            }, 50L);
        }
    }

    public final void loadAd() {
        AdRequest adRequest = null;
        if (o.e.isValid()) {
            adRequest = new AdRequest();
            adRequest.setUserProfile(UserProfile.getSavedProfile(this.getContext()));
        }
        this.loadAd(adRequest);
    }

    public final void loadAd(AdRequest adRequest) {
        this.adLoadTimer.a();
        this.mRequestStartedTimestamp = SystemClock.elapsedRealtime();
        DevLogger.i((String)("Loading AdView" + (adRequest != null ? ". " + adRequest : "")));
        if (!this.mustRequestNewAd()) {
            return;
        }
        this.mAdRefresher.c();
        this.mAdRequest = adRequest;
        if (this.mAdRequest != null && this.mAdRequest.getAdUnitId() == null) {
            adRequest.setAdUnitId(this.mAdUnitId);
        }
        if (TimeUtils.hasElapsedEnoughTime((long)this.mRequestCompletedTimestamp, (long)SystemClock.elapsedRealtime(), (long)this.mRefreshInterval)) {
            this.requestAd(new ak(this.getType(), this.mAdRequest));
        } else {
            long l2 = SystemClock.elapsedRealtime() - this.mRequestCompletedTimestamp;
            this.mAdRefresher.a(this.mRefreshInterval - l2);
        }
    }

    private void requestAd(ak target) {
        this.mLoadState = 1;
        b<com.inlocomedia.android.ads.b> b2 = new b<com.inlocomedia.android.ads.b>(this.getContext(), target, (f)new com.inlocomedia.android.ads.c()){

            @Override
            public void a(com.inlocomedia.android.ads.b b2) {
                if (b2.a() != null) {
                    this.a(b2.a());
                }
                if (b2.c() != null) {
                    this.a(b2.c());
                }
            }

            @Override
            public void a(AdError adError) {
                AdView.this.mRequestCompletedTimestamp = SystemClock.elapsedRealtime();
                AdView.this.mLoadState = 5;
                AdView.this.notifyAdError(adError);
                AdView.this.mAdRefresher.a();
            }

            @Override
            private void a(j j2) {
                AdView.this.setRefreshInterval(j2.b());
            }

            @Override
            private void a(al al2) {
                if (AdView.this.mLoadState == 3 || AdView.this.mLoadState == 4) {
                    AdView.this.mAdToLoadAfterCollapsing = al2;
                    AdView.this.mLoadState = 2;
                } else {
                    AdView.this.loadFrom(al2, AdView.this.mAdViewControllerInterface);
                }
            }
        };
        this.adRequestManager.a(b2);
    }

    private boolean mustRequestNewAd() {
        if (!Validator.isValidSDKVersion()) {
            this.onValidationError("AdView.loadAd() failed. Invalid SDK version.", AdError.INVALID_SDK_VERSION);
            return false;
        }
        if (!o.e.isValid()) {
            this.onValidationError("AdView.loadAd() failed. The SDK is in a invalid state. Check the log for the error that caused it", AdError.INTERNAL_ERROR);
            return false;
        }
        if (this.mLoadState == 6) {
            DevLogger.w((String)"AdView.loadAd() failed. AdView already destroyed");
            this.notifyAdError(AdError.INVALID_REQUEST);
            return false;
        }
        if (this.mLoadState == 1) {
            DevLogger.w((String)"Last AdView.loadAd() was ignored. AdView is already loading.");
            return false;
        }
        try {
            h.a(this);
        }
        catch (AdvertisementException advertisementException) {
            this.onValidationError("AdView.loadAd() failed. Invalid request with error: " + advertisementException.getFormattedMessage(), AdError.INVALID_REQUEST);
            return false;
        }
        return true;
    }

    private void onValidationError(String errorMessage, AdError adError) {
        this.mLoadState = 5;
        DevLogger.w((String)errorMessage);
        this.notifyAdError(adError);
        this.mAdRefresher.a();
    }

    private void notifyAdError(AdError adError) {
        DevLogger.w((String)("AdView error: (" + (Object)((Object)adError) + ")"));
        this.adLoadTimer.a(this.mCurrentAd, false);
        if (this.mAdViewListener != null) {
            this.mAdViewListener.onAdError(this, adError);
        }
    }

    @Override
    public void resume() {
        if (!Validator.isValidSDKVersion()) {
            return;
        }
        Validator.mainThread((String)"AdView onResume method");
        super.resume();
        this.mAdRefresher.b();
    }

    @Override
    public void pause(boolean isFinishing) {
        if (!Validator.isValidSDKVersion()) {
            return;
        }
        Validator.mainThread((String)"AdView onPause method");
        this.mAdRefresher.c();
        super.pause(isFinishing);
    }

    @Override
    public void destroy() {
        if (!Validator.isValidSDKVersion()) {
            return;
        }
        Validator.mainThread((String)"AdView onDestroy method");
        this.mLoadState = 6;
        this.mAdRefresher.c();
        this.mAdToLoadAfterCollapsing = null;
        this.mViewabilityTracker.a();
        this.setRefreshInterval(0L);
        this.setVisibility(8);
        super.destroy();
    }

    public final void setAdListener(AdViewListener listener) {
        this.mAdViewListener = listener;
    }

    public final boolean isLoaded() {
        return this.mLoadState == 2 || this.mLoadState == 4 || this.mLoadState == 3;
    }

    public final boolean isLoading() {
        return this.mLoadState == 1;
    }

    private void setRefreshInterval(long intervalInSeconds) {
        this.mRefreshInterval = intervalInSeconds;
    }

    public void setLoadOnAttach(boolean loadOnAttach) {
        this.mLoadOnAttach = loadOnAttach;
    }

    public boolean isLoadOnAttach() {
        return this.mLoadOnAttach;
    }

    public void setAdUnitId(String adUnitId) {
        this.mAdUnitId = adUnitId;
    }

    public boolean isRefreshEnabled() {
        return this.mRefreshInterval != 0L;
    }

    public long getRefreshInterval() {
        return this.mRefreshInterval;
    }

    protected static class a {
        private WeakReference<AdView> a;
        private InvalidatableRunnable b;
        private AtomicBoolean c = new AtomicBoolean(false);
        private ScreenHelper d;
        private long e;
        private long f;

        a(AdView adView) {
            this.f = adView.getRefreshInterval();
            this.a = new WeakReference<AdView>(adView);
            this.d = bh.e();
        }

        private boolean a(@Nullable AdView adView) {
            return adView != null && adView.isShown() && adView.isRefreshEnabled() && adView.isAttachedToWindow() && this.d.isScreenOn() && (adView.isLoaded() || adView.mLoadState == 5);
        }

        private boolean b(@Nullable AdView adView) {
            return adView != null && this.d.isScreenOn() && (adView.isShown() && adView.isAttachedToWindow() || adView.mLoadState == 5);
        }

        public boolean a() {
            AdView adView = (AdView)((Object)this.a.get());
            return adView != null && this.a(adView.getRefreshInterval());
        }

        public boolean a(long l2) {
            boolean bl2 = this.b(l2);
            if (bl2) {
                this.f = l2;
                DevLogger.i((String)("AdView refresh was started. Will refresh in " + l2 + "ms."));
            }
            return bl2;
        }

        public boolean b() {
            boolean bl2 = this.b(this.f);
            if (bl2) {
                DevLogger.i((String)("AdView refresh was resumed. Will refresh in " + this.f + "ms."));
            }
            return bl2;
        }

        public boolean c() {
            boolean bl2 = this.d();
            if (bl2) {
                long l2 = SystemClock.elapsedRealtime() - this.e;
                this.f = Math.max(0L, this.f - l2);
                DevLogger.i((String)("AdView refresh was paused " + this.f + "ms before refreshing."));
            }
            return bl2;
        }

        private boolean b(long l2) {
            if (this.a((AdView)((Object)this.a.get())) && this.c.compareAndSet(false, true)) {
                this.b = new InvalidatableRunnable(){

                    public void invalidatableRun() {
                        a.this.c.set(false);
                        AdView adView = (AdView)((Object)a.this.a.get());
                        if (a.this.b(adView)) {
                            adView.loadAd(adView.mAdRequest);
                        } else {
                            DevLogger.i((String)"AdView refresh was canceled. AdView is not visible.");
                        }
                        a.this.b = null;
                    }
                };
                ThreadPool.executeInMainAt((Runnable)this.b, (long)l2, (TimeUnit)TimeUnit.MILLISECONDS);
                this.e = SystemClock.elapsedRealtime();
                return true;
            }
            return false;
        }

        private boolean d() {
            if (this.c.compareAndSet(true, false)) {
                if (this.b != null) {
                    this.b.invalidate();
                    this.b = null;
                }
                return true;
            }
            return false;
        }
    }
}

