/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.ViewPropertyAnimator;
import android.widget.ImageView;
import com.inlocomedia.android.ads.core.m;
import com.inlocomedia.android.ads.util.ImageRequest;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.Module;
import com.inlocomedia.android.core.R;
import com.inlocomedia.android.core.communication.Request;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.exception.InLocoMediaUnhandledException;
import com.inlocomedia.android.core.log.CriticalErrorManager;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.MemoryCache;
import com.inlocomedia.android.core.util.ThreadPool;

@TargetApi(value=14)
public final class ImageViewDownloadManager {
    private static final String TAG = Logger.makeTag(ImageViewDownloadManager.class);
    private static final int TAG_KEY_URL = R.id.ilm_private_id_url;
    private static final int TAG_KEY_IS_RECYCLED = R.id.ilm_private_id_recycled;
    private static final int TAG_KEY_PLACEHOLDER = R.id.ilm_private_id_placeholder;
    private static final int TAG_KEY_REQUEST = R.id.ilm_private_id_request;
    private static final int TAG_KEY_BITMAP_REQUEST_LISTENER = R.id.ilm_private_id_request_listener;
    private static final int TAG_KEY_USER_LISTENER = R.id.ilm_private_id_user_listener;

    public static ImageRequest with(Context context) {
        return new ImageRequest(context);
    }

    public static void setMaxMemoryCacheSize(int maxMemorySize) {
        MemoryCache.setMaxMemorySize((int)maxMemorySize);
    }

    public static void clearMemoryCache() {
        MemoryCache.clear();
    }

    static boolean downloadAndSet(final @NonNull ImageRequest imageRequest) {
        try {
            final ImageView imageView = imageRequest.getImageView();
            String string2 = imageRequest.getUrl();
            RequestListener<Void> requestListener = imageRequest.getListener();
            if (string2.equals(imageView.getTag(TAG_KEY_URL))) {
                return false;
            }
            ThreadPool.executeInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    imageView.setImageDrawable(null);
                    imageView.measure(0, 0);
                    if (imageRequest.hasPlaceholderImage()) {
                        ImageViewDownloadManager.displayInProgressPlaceholder(imageView, imageRequest.getPlaceholderDrawable());
                    }
                }
            });
            ImageViewDownloadManager.cancelPotentialDownload(imageView);
            ImageViewDownloadManager.saveUrl(imageView, string2);
            ImageViewDownloadManager.saveUserListener(imageView, requestListener);
            ImageViewDownloadManager.savePlaceholderIfNecessary(imageView);
            Bitmap bitmap = null;
            if (imageRequest.isMemoryCacheEnabled()) {
                bitmap = MemoryCache.getInstance((Context)imageRequest.getContext()).get(string2);
            }
            if (bitmap != null && bitmap.getWidth() >= imageView.getMeasuredWidth() && bitmap.getHeight() >= imageView.getMeasuredHeight()) {
                imageView.setImageBitmap(bitmap);
                if (requestListener != null) {
                    requestListener.onRequestFinished(null);
                }
                return false;
            }
            a a2 = new a(imageRequest, string2);
            imageView.setTag(TAG_KEY_BITMAP_REQUEST_LISTENER, (Object)a2);
            imageView.setTag(TAG_KEY_REQUEST, (Object)m.a(imageRequest.getContext(), string2, a2, string2, imageRequest.getImageView(), imageRequest.getMaxWidth(), imageRequest.getMaxHeight()));
            return true;
        }
        catch (Throwable throwable) {
            CriticalErrorManager.notifyError((String)TAG, (Throwable)throwable, (Module)Environment.CoreModulesManager.SDK, (boolean)true);
            return false;
        }
    }

    private static void cancelPotentialDownload(@NonNull ImageView iv) {
        try {
            a a2;
            final Request request = (Request)iv.getTag(TAG_KEY_REQUEST);
            if (request != null) {
                ThreadPool.executeInBackground((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        request.cancel();
                    }
                });
            }
            if ((a2 = (a)iv.getTag(TAG_KEY_BITMAP_REQUEST_LISTENER)) != null) {
                a2.a();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void saveUserListener(@NonNull ImageView iv, @Nullable RequestListener<Void> listener) {
        iv.setTag(TAG_KEY_USER_LISTENER, listener);
    }

    private static void saveUrl(@NonNull ImageView iv, @NonNull String imageUrl) {
        iv.setTag(TAG_KEY_URL, (Object)imageUrl);
    }

    private static void savePlaceholderIfNecessary(@NonNull ImageView iv) {
        try {
            boolean bl;
            boolean bl2 = bl = iv.getTag(TAG_KEY_IS_RECYCLED) != null;
            if (!bl) {
                iv.setTag(TAG_KEY_IS_RECYCLED, (Object)true);
                Drawable drawable2 = iv.getDrawable();
                if (drawable2 != null) {
                    iv.setTag(TAG_KEY_PLACEHOLDER, (Object)drawable2.getConstantState());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void displayInProgressPlaceholder(final @NonNull ImageView iv, final Drawable placeholder) {
        ThreadPool.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    iv.setImageDrawable(placeholder);
                    ImageViewDownloadManager.showImageView(iv, false);
                }
                catch (Throwable throwable) {
                    ImageViewDownloadManager.hideImageView(iv, false);
                }
            }
        });
    }

    private static void displayErrorPlaceholderIfExists(final @NonNull ImageRequest imageRequest) {
        ThreadPool.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ImageView imageView = imageRequest.getImageView();
                    if (imageRequest.hasErrorImage()) {
                        imageView.setImageDrawable(imageRequest.getErrorDrawable());
                        ImageViewDownloadManager.showImageView(imageView, false);
                    } else {
                        ImageViewDownloadManager.hideImageView(imageView, false);
                    }
                }
                catch (Throwable throwable) {
                    ImageViewDownloadManager.hideImageView(imageRequest.getImageView(), false);
                }
            }
        });
    }

    private static void showImageView(@NonNull ImageView iv, boolean fade) {
        if (fade) {
            ViewPropertyAnimator viewPropertyAnimator = iv.animate();
            viewPropertyAnimator.cancel();
            iv.setAlpha(0.0f);
            viewPropertyAnimator.alpha(1.0f).start();
        } else {
            iv.setAlpha(1.0f);
        }
    }

    private static void hideImageView(ImageView iv, boolean fade) {
        if (fade) {
            ViewPropertyAnimator viewPropertyAnimator = iv.animate();
            viewPropertyAnimator.cancel();
            viewPropertyAnimator.alpha(0.0f).start();
        } else {
            iv.setAlpha(0.0f);
        }
    }

    private static void notifyRequestFailure(final @NonNull ImageView iv, final InLocoMediaException error) {
        ThreadPool.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                RequestListener requestListener = (RequestListener)iv.getTag(TAG_KEY_USER_LISTENER);
                if (requestListener != null) {
                    requestListener.onRequestFailed(error);
                }
            }
        });
    }

    private static void notifyRequestFinished(final @NonNull ImageView iv) {
        ThreadPool.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                RequestListener requestListener = (RequestListener)iv.getTag(TAG_KEY_USER_LISTENER);
                if (requestListener != null) {
                    requestListener.onRequestFinished(null);
                }
            }
        });
    }

    private static class a
    implements RequestListener<Bitmap> {
        private final ImageRequest a;
        private final String b;
        private boolean c;

        a(ImageRequest imageRequest, String string2) {
            this.a = imageRequest;
            this.b = string2;
            this.c = false;
        }

        public void a(final Bitmap bitmap) {
            block5: {
                if (this.c) {
                    return;
                }
                try {
                    final ImageView imageView = this.a.getImageView();
                    if (imageView == null || imageView.getTag(TAG_KEY_URL) == null || !imageView.getTag(TAG_KEY_URL).equals(this.b)) {
                        return;
                    }
                    imageView.setTag(TAG_KEY_URL, null);
                    if (this.a.isMemoryCacheEnabled()) {
                        MemoryCache.getInstance((Context)this.a.getContext()).put(this.b, bitmap);
                    }
                    ThreadPool.executeInMain((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (a.this.c) {
                                return;
                            }
                            try {
                                imageView.setImageBitmap(bitmap);
                            }
                            catch (Throwable throwable) {
                                Log.w((String)TAG, (String)("Cannot set bitmap. MainQueue.execute() has failed: " + InLocoMediaException.getFormattedMessage((Throwable)throwable)));
                                ImageViewDownloadManager.displayErrorPlaceholderIfExists(a.this.a);
                            }
                            ImageViewDownloadManager.notifyRequestFinished(imageView);
                        }
                    });
                }
                catch (Throwable throwable) {
                    ImageView imageView = this.a.getImageView();
                    if (imageView == null) break block5;
                    ImageViewDownloadManager.displayErrorPlaceholderIfExists(this.a);
                    ImageViewDownloadManager.notifyRequestFailure(imageView, new InLocoMediaException("Unhandled error in ImageView loading", throwable));
                    CriticalErrorManager.notifyError((String)TAG, (Throwable)throwable, (Module)Environment.CoreModulesManager.SDK, (boolean)true);
                }
            }
        }

        public void onRequestFailed(InLocoMediaException error) {
            if (this.c) {
                return;
            }
            if (error instanceof InLocoMediaUnhandledException && this.a != null) {
                CriticalErrorManager.notifyError((String)TAG, (Throwable)error, (Module)Environment.CoreModulesManager.SDK, (boolean)true);
            }
            if (this.a != null) {
                ImageViewDownloadManager.displayErrorPlaceholderIfExists(this.a);
                ImageViewDownloadManager.notifyRequestFailure(this.a.getImageView(), error);
            }
        }

        private void a() {
            this.c = true;
        }

        public /* synthetic */ void onRequestFinished(Object object) {
            this.a((Bitmap)object);
        }
    }
}

