/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads;

import android.text.TextUtils;
import com.inlocomedia.android.ads.profile.UserProfile;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class AdRequest {
    public static final int TAGGED_CHILDREN_TRUE = 1;
    public static final int TAGGED_CHILDREN_FALSE = 0;
    public static final int TAGGED_CHILDREN_UNSPECIFIED = -1;
    private UserProfile mUserProfile;
    private Set<String> mKeywords;
    private Set<String> mTags;
    private String mRequestAgent;
    private Locale mLocale;
    private String mQuery;
    private int mTaggedForChildren = -1;
    private String mTestHtml;
    private String mCrId;
    private String mAdUnitId;
    private boolean mNativeListConfigEnabled;

    public com.inlocomedia.android.profile.UserProfile getUserProfile() {
        return UserProfile.newToOld(this.mUserProfile);
    }

    public AdRequest setUserProfile(com.inlocomedia.android.profile.UserProfile userProfile) {
        this.mUserProfile = UserProfile.oldToNew(userProfile);
        return this;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public AdRequest setLocale(Locale locale) {
        this.mLocale = locale;
        return this;
    }

    public AdRequest addKeyword(String keyword) {
        if (!TextUtils.isEmpty((CharSequence)keyword)) {
            if (this.mKeywords == null) {
                this.mKeywords = new HashSet<String>();
            }
            this.mKeywords.add(keyword);
        }
        return this;
    }

    public Set<String> getKeywords() {
        return this.mKeywords;
    }

    public AdRequest setKeywords(Set<String> keywords) {
        this.mKeywords = keywords;
        return this;
    }

    public AdRequest addTag(String tag) {
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            if (this.mTags == null) {
                this.mTags = new HashSet<String>();
            }
            this.mTags.add(tag);
        }
        return this;
    }

    public Set<String> getTags() {
        return this.mTags;
    }

    public AdRequest setTags(Set<String> tags) {
        this.mTags = tags;
        return this;
    }

    public String getRequestAgent() {
        return this.mRequestAgent;
    }

    public AdRequest setRequestAgent(String requestAgent) {
        this.mRequestAgent = requestAgent;
        return this;
    }

    public String getQuery() {
        return this.mQuery;
    }

    public AdRequest setQuery(String query) {
        this.mQuery = query;
        return this;
    }

    public String getCreativeId() {
        return this.mCrId;
    }

    public AdRequest setCreativeId(String crId) {
        this.mCrId = crId;
        return this;
    }

    public String getAdUnitId() {
        return this.mAdUnitId;
    }

    public AdRequest setAdUnitId(String adUnitId) {
        this.mAdUnitId = adUnitId;
        return this;
    }

    public boolean isNativeListConfigEnabled() {
        return this.mNativeListConfigEnabled;
    }

    public AdRequest setNativeListConfigEnabled(boolean nativeListConfigEnabled) {
        this.mNativeListConfigEnabled = nativeListConfigEnabled;
        return this;
    }

    public String getTestHtml() {
        return this.mTestHtml;
    }

    public AdRequest setTestHtml(String testHtml) {
        this.mTestHtml = testHtml;
        return this;
    }

    public int getTaggedForChildren() {
        return this.mTaggedForChildren;
    }

    public AdRequest setTaggedForChildren(boolean taggedForChildren) {
        this.mTaggedForChildren = taggedForChildren ? 1 : 0;
        return this;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        AdRequest adRequest = (AdRequest)o2;
        if (this.mTaggedForChildren != adRequest.mTaggedForChildren) {
            return false;
        }
        if (this.mNativeListConfigEnabled != adRequest.mNativeListConfigEnabled) {
            return false;
        }
        if (this.mUserProfile != null ? !this.mUserProfile.equals((Object)adRequest.mUserProfile) : adRequest.mUserProfile != null) {
            return false;
        }
        if (this.mKeywords != null ? !this.mKeywords.equals(adRequest.mKeywords) : adRequest.mKeywords != null) {
            return false;
        }
        if (this.mTags != null ? !this.mTags.equals(adRequest.mTags) : adRequest.mTags != null) {
            return false;
        }
        if (this.mRequestAgent != null ? !this.mRequestAgent.equals(adRequest.mRequestAgent) : adRequest.mRequestAgent != null) {
            return false;
        }
        if (this.mLocale != null ? !this.mLocale.equals(adRequest.mLocale) : adRequest.mLocale != null) {
            return false;
        }
        if (this.mQuery != null ? !this.mQuery.equals(adRequest.mQuery) : adRequest.mQuery != null) {
            return false;
        }
        if (this.mTestHtml != null ? !this.mTestHtml.equals(adRequest.mTestHtml) : adRequest.mTestHtml != null) {
            return false;
        }
        if (this.mCrId != null ? !this.mCrId.equals(adRequest.mCrId) : adRequest.mCrId != null) {
            return false;
        }
        return this.mAdUnitId != null ? this.mAdUnitId.equals(adRequest.mAdUnitId) : adRequest.mAdUnitId == null;
    }

    public int hashCode() {
        int n2 = this.mUserProfile != null ? this.mUserProfile.hashCode() : 0;
        n2 = 31 * n2 + (this.mKeywords != null ? this.mKeywords.hashCode() : 0);
        n2 = 31 * n2 + (this.mTags != null ? this.mTags.hashCode() : 0);
        n2 = 31 * n2 + (this.mRequestAgent != null ? this.mRequestAgent.hashCode() : 0);
        n2 = 31 * n2 + (this.mLocale != null ? this.mLocale.hashCode() : 0);
        n2 = 31 * n2 + (this.mQuery != null ? this.mQuery.hashCode() : 0);
        n2 = 31 * n2 + this.mTaggedForChildren;
        n2 = 31 * n2 + (this.mTestHtml != null ? this.mTestHtml.hashCode() : 0);
        n2 = 31 * n2 + (this.mCrId != null ? this.mCrId.hashCode() : 0);
        n2 = 31 * n2 + (this.mAdUnitId != null ? this.mAdUnitId.hashCode() : 0);
        n2 = 31 * n2 + (this.mNativeListConfigEnabled ? 1 : 0);
        return n2;
    }

    public String toString() {
        return "AdRequest{" + (this.mUserProfile != null ? " mUserProfile=" + (Object)((Object)this.mUserProfile) : "") + (this.mTags != null ? " mTags=" + this.mTags : "") + (this.mKeywords != null ? " mKeywords=" + this.mKeywords : "") + (this.mRequestAgent != null ? " mRequestAgent='" + this.mRequestAgent + '\'' : "") + (this.mLocale != null ? ", mLocale=" + this.mLocale : "") + (this.mQuery != null ? " mQuery='" + this.mQuery + '\'' : "") + (this.mTaggedForChildren != -1 ? " mTaggedForChildren=" + this.mTaggedForChildren : "") + (this.mTestHtml != null ? " mTestHtml='" + this.mTestHtml + '\'' : "") + (this.mCrId != null ? " mCrId='" + this.mCrId + '\'' : "") + (this.mAdUnitId != null ? " mAdUnitId='" + this.mAdUnitId + '\'' : "") + (this.mNativeListConfigEnabled ? " mNativeListConfigEnabled=" + this.mNativeListConfigEnabled : "") + '}';
    }
}

