/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.mediation.google.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.inlocomedia.android.ads.nativeads.NativeAdResponse;
import com.inlocomedia.android.mediation.google.utils.InLocoMediaNativeMappedImage;
import com.inlocomedia.android.mediation.google.utils.NativeAdMapperInterface;
import java.util.ArrayList;
import java.util.HashMap;

public class InLocoContentNativeAdMapper
extends NativeContentAdMapper
implements NativeAdMapperInterface {
    private NativeAdResponse nativeAd;
    private Context context;

    public InLocoContentNativeAdMapper(Context context, NativeAdResponse nativeAd, HashMap<String, Drawable> images) {
        this.nativeAd = nativeAd;
        this.context = context;
        this.setHeadline(nativeAd.getTitle());
        this.setBody(nativeAd.getDescription());
        this.setCallToAction(nativeAd.getCallToAction());
        this.setAdvertiser(nativeAd.getHighlightText());
        this.setLogo(new InLocoMediaNativeMappedImage(images.get("icon_key"), nativeAd.getIconUrl(), 1.0));
        ArrayList<InLocoMediaNativeMappedImage> mainImageList = new ArrayList<InLocoMediaNativeMappedImage>();
        mainImageList.add(new InLocoMediaNativeMappedImage(images.get("image_key"), nativeAd.getMainImageUrl(), 1.0));
        this.setImages(mainImageList);
        this.setOverrideClickHandling(false);
        this.setOverrideImpressionRecording(false);
    }

    public void recordImpression() {
        if (this.context != null) {
            this.nativeAd.registerImpression(this.context);
        }
    }

    public void handleClick(View view) {
        if (this.context != null) {
            this.nativeAd.performClick(this.context);
        }
    }

    @Override
    public void destroy() {
        this.context = null;
    }
}

