/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.mediation.google;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventBanner;
import com.google.android.gms.ads.mediation.customevent.CustomEventBannerListener;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.AdView;
import com.inlocomedia.android.ads.AdViewListener;
import com.inlocomedia.android.mediation.google.Utils;

public class InLocoMediaBannerAdapter
implements CustomEventBanner {
    public static final String TAG = "InLocoMedia";
    private AdView mAdView;
    private String mRequestAgent;

    public InLocoMediaBannerAdapter(String requestAgent) {
        this.mRequestAgent = requestAgent;
    }

    public void requestBannerAd(Context context, final CustomEventBannerListener listener, String serverParameter, AdSize size, MediationAdRequest mediationAdRequest, Bundle bundle) {
        Utils.setupInLocoMedia(context, serverParameter);
        AdType adType = Utils.convertAdSizeToAdType(size);
        if (adType == null) {
            Log.w((String)TAG, (String)("Requested AdSize is incompatible: " + size));
            listener.onAdFailedToLoad(1);
            return;
        }
        this.mAdView = new AdView(context);
        this.mAdView.setType(adType);
        this.mAdView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Log.i((String)InLocoMediaBannerAdapter.TAG, (String)"Ad clicked");
                listener.onAdClicked();
            }
        });
        this.mAdView.setAdListener(new AdViewListener(){

            public void onAdViewReady(AdView adView) {
                Log.i((String)InLocoMediaBannerAdapter.TAG, (String)"Ad ready");
                listener.onAdLoaded((View)adView);
            }

            public void onAdLeftApplication(AdView adView) {
                Log.i((String)InLocoMediaBannerAdapter.TAG, (String)"Ad left application");
                listener.onAdLeftApplication();
            }

            public void onAdError(AdView adView, AdError error) {
                Log.i((String)InLocoMediaBannerAdapter.TAG, (String)("Ad error: " + error));
                listener.onAdFailedToLoad(Utils.adErrorToAdMobError(error));
                InLocoMediaBannerAdapter.this.mAdView.destroy();
            }
        });
        String adUnitId = Utils.getAdUnitId(serverParameter);
        this.mAdView.loadAd(Utils.createAdRequest(mediationAdRequest, adUnitId, this.mRequestAgent));
        Log.i((String)TAG, (String)("Ad requested. AdSize: " + size.toString() + " AdType: " + adType.toString()));
    }

    public void onDestroy() {
        if (this.mAdView != null) {
            this.mAdView.destroy();
        }
    }

    public void onPause() {
        if (this.mAdView != null) {
            this.mAdView.pause(false);
        }
    }

    public void onResume() {
        if (this.mAdView != null) {
            this.mAdView.resume();
        }
    }
}

