/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import android.content.Context;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class TrendsAPI
extends AbsOpenAPI {
    private static final String SERVER_URL_PRIX = "https://api.weibo.com/2/trends";

    public TrendsAPI(Context context, String appKey, Oauth2AccessToken accessToken) {
        super(context, appKey, accessToken);
    }

    public void trends(long uid, int count, int page, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("uid", uid);
        params.put("count", count);
        params.put("page", page);
        this.requestAsync("https://api.weibo.com/2/trends.json", params, "GET", listener);
    }

    public void isFollow(String trend_name, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("trend_name", trend_name);
        this.requestAsync("https://api.weibo.com/2/trends/is_follow.json", params, "GET", listener);
    }

    public void hourly(boolean base_app, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("base_app", base_app ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/trends/hourly.json", params, "GET", listener);
    }

    public void daily(boolean base_app, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("base_app", base_app ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/trends/daily.json", params, "GET", listener);
    }

    public void weekly(boolean base_app, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("base_app", base_app ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/trends/weekly.json", params, "GET", listener);
    }

    public void follow(String trend_name, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("trend_name", trend_name);
        this.requestAsync("https://api.weibo.com/2/trends/follow.json", params, "POST", listener);
    }

    public void destroy(long trend_id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("trend_id", trend_id);
        this.requestAsync("https://api.weibo.com/2/trends/destroy.json", params, "POST", listener);
    }
}

