/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import android.content.Context;
import android.util.SparseArray;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class LocationAPI
extends AbsOpenAPI {
    private static final String API_BASE_URL = "https://api.weibo.com/2/location";
    private static final int READ_API_GPS_TO_OFFSET = 0;
    private static final int READ_API_SEARCH_POIS_BY_GEO = 1;
    private static final int READ_API_GET_TO_ADDRESS = 2;
    private static final SparseArray<String> sAPIList = new SparseArray();

    public LocationAPI(Context context, String appKey, Oauth2AccessToken accessToken) {
        super(context, appKey, accessToken);
    }

    public void gps2Offset(Double longtitude, Double latitude, RequestListener listener) {
        WeiboParameters params = this.buildGPS2OffsetParams(longtitude, latitude);
        this.requestAsync((String)sAPIList.get(0), params, "GET", listener);
    }

    public void searchPoisByGeo(Double longtitude, Double latitude, String keyWord, RequestListener listener) {
        WeiboParameters params = this.buildSerarPoiByGeoParmas(longtitude, latitude, keyWord);
        this.requestAsync((String)sAPIList.get(1), params, "GET", listener);
    }

    public void geo2Address(Double longtitude, Double latitude, RequestListener listener) {
        WeiboParameters params = this.buildGeo2AddressParam(longtitude, latitude);
        this.requestAsync((String)sAPIList.get(2), params, "GET", listener);
    }

    public String gps2OffsetSync(Double longtitude, Double latitude) {
        WeiboParameters params = this.buildGPS2OffsetParams(longtitude, latitude);
        return this.requestSync((String)sAPIList.get(0), params, "GET");
    }

    public String searchPoisByGeoSync(Double longtitude, Double latitude, String keyWord) {
        WeiboParameters params = this.buildSerarPoiByGeoParmas(longtitude, latitude, keyWord);
        return this.requestSync((String)sAPIList.get(1), params, "GET");
    }

    public String geo2AddressSync(Double longtitude, Double latitude) {
        WeiboParameters params = this.buildGeo2AddressParam(longtitude, latitude);
        return this.requestSync((String)sAPIList.get(2), params, "GET");
    }

    private WeiboParameters buildGPS2OffsetParams(Double longtitude, Double latitude) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        String coordinate = longtitude + "," + latitude;
        params.put("coordinate", coordinate);
        return params;
    }

    private WeiboParameters buildSerarPoiByGeoParmas(Double longtitude, Double latitude, String keyWord) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        String coordinate = longtitude + "," + latitude;
        params.put("coordinate", coordinate);
        params.put("q", keyWord);
        return params;
    }

    private WeiboParameters buildGeo2AddressParam(Double longtitude, Double latitude) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        String coordinate = longtitude + "," + latitude;
        params.put("coordinate", coordinate);
        return params;
    }

    static {
        sAPIList.put(0, (Object)"https://api.weibo.com/2/location/geo/gps_to_offset.json");
        sAPIList.put(1, (Object)"https://api.weibo.com/2/location/pois/search/by_geo.json");
        sAPIList.put(2, (Object)"https://api.weibo.com/2/location/geo/geo_to_address.json");
    }
}

