/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import android.content.Context;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class CommonAPI
extends AbsOpenAPI {
    public static final String LANGUAGE_ZH_CN = "zh-cn";
    public static final String LANGUAGE_ZH_TW = "zh-tw";
    public static final String LANGUAGE_EN = "english";
    private static final String SERVER_URL_PRIX = "https://api.weibo.com/2/common";

    public CommonAPI(Context context, String appKey, Oauth2AccessToken accessToken) {
        super(context, appKey, accessToken);
    }

    public void getCity(String province, String capital, String language, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("province", province);
        if (null != capital) {
            params.put("capital", capital);
        }
        params.put("language", language);
        this.requestAsync("https://api.weibo.com/2/common/get_city.json", params, "GET", listener);
    }

    public void getCountry(CAPITAL capital, String language, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        if (null != capital) {
            params.put("capital", capital.name().toLowerCase());
        }
        params.put("language", language);
        this.requestAsync("https://api.weibo.com/2/common/get_country.json", params, "GET", listener);
    }

    public void getTimezone(String language, RequestListener listener) {
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("language", language);
        this.requestAsync("https://api.weibo.com/2/common/get_timezone.json", params, "GET", listener);
    }

    public static enum CAPITAL {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h,
        i,
        j,
        k,
        l,
        m,
        n,
        o,
        p,
        q,
        r,
        s,
        t,
        u,
        v,
        w,
        x,
        y,
        z;

    }
}

