/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.models;

import android.text.TextUtils;
import com.sina.weibo.sdk.openapi.models.Status;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StatusList {
    public ArrayList<Status> statusList;
    public Status statuses;
    public boolean hasvisible;
    public String previous_cursor;
    public String next_cursor;
    public int total_number;
    public Object[] advertises;

    public static StatusList parse(String jsonString) {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        StatusList statuses = new StatusList();
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            statuses.hasvisible = jsonObject.optBoolean("hasvisible", false);
            statuses.previous_cursor = jsonObject.optString("previous_cursor", "0");
            statuses.next_cursor = jsonObject.optString("next_cursor", "0");
            statuses.total_number = jsonObject.optInt("total_number", 0);
            JSONArray jsonArray = jsonObject.optJSONArray("statuses");
            if (jsonArray != null && jsonArray.length() > 0) {
                int length = jsonArray.length();
                statuses.statusList = new ArrayList(length);
                for (int ix = 0; ix < length; ++ix) {
                    statuses.statusList.add(Status.parse(jsonArray.getJSONObject(ix)));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return statuses;
    }
}

