/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class TagsAPI
extends AbsOpenAPI {
    private static final String SERVER_URL_PRIX = "https://api.weibo.com/2/tags";

    public TagsAPI(Oauth2AccessToken accessToken) {
        super(accessToken);
    }

    public void tags(long uid, int count, int page, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("uid", uid);
        params.put("count", count);
        params.put("page", page);
        this.requestAsync("https://api.weibo.com/2/tags.json", params, "GET", listener);
    }

    public void tagsBatch(String[] uids, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        StringBuilder strb = new StringBuilder();
        for (String uid : uids) {
            strb.append(uid).append(",");
        }
        strb.deleteCharAt(strb.length() - 1);
        params.put("uids", strb.toString());
        this.requestAsync("https://api.weibo.com/2/tags/tags_batch.json", params, "GET", listener);
    }

    public void suggestions(int count, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("count", count);
        this.requestAsync("https://api.weibo.com/2/tags/suggestions.json", params, "GET", listener);
    }

    public void create(String[] tags, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        StringBuilder strb = new StringBuilder();
        for (String tag : tags) {
            strb.append(tag).append(",");
        }
        strb.deleteCharAt(strb.length() - 1);
        params.put("tags", strb.toString());
        this.requestAsync("https://api.weibo.com/2/tags/create.json", params, "POST", listener);
    }

    public void destroy(long tag_id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("tag_id", tag_id);
        this.requestAsync("https://api.weibo.com/2/tags/destroy.json", params, "POST", listener);
    }

    public void destroyBatch(String[] ids, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        StringBuilder strb = new StringBuilder();
        for (String id : ids) {
            strb.append(id).append(",");
        }
        strb.deleteCharAt(strb.length() - 1);
        params.put("ids", strb.toString());
        this.requestAsync("https://api.weibo.com/2/tags/destroy_batch.json", params, "POST", listener);
    }
}

