/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi;

import android.util.SparseArray;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class CommentsAPI
extends AbsOpenAPI {
    public static final int AUTHOR_FILTER_ALL = 0;
    public static final int AUTHOR_FILTER_ATTENTIONS = 1;
    public static final int AUTHOR_FILTER_STRANGER = 2;
    public static final int SRC_FILTER_ALL = 0;
    public static final int SRC_FILTER_WEIBO = 1;
    public static final int SRC_FILTER_WEIQUN = 2;
    private static final int READ_API_TO_ME = 0;
    private static final int READ_API_BY_ME = 1;
    private static final int READ_API_SHOW = 2;
    private static final int READ_API_TIMELINE = 3;
    private static final int READ_API_MENTIONS = 4;
    private static final int READ_API_SHOW_BATCH = 5;
    private static final int WRITE_API_CREATE = 6;
    private static final int WRITE_API_DESTROY = 7;
    private static final int WRITE_API_SDESTROY_BATCH = 8;
    private static final int WRITE_API_REPLY = 9;
    private static final String API_BASE_URL = "https://api.weibo.com/2/comments";
    private static final SparseArray<String> sAPIList = new SparseArray();

    public CommentsAPI(Oauth2AccessToken accessToken) {
        super(accessToken);
    }

    public void show(long id, long since_id, long max_id, int count, int page, int authorType, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page);
        params.put("id", id);
        params.put("filter_by_author", authorType);
        this.requestAsync((String)sAPIList.get(2), params, "GET", listener);
    }

    public void byME(long since_id, long max_id, int count, int page, int sourceType, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page);
        params.put("filter_by_source", sourceType);
        this.requestAsync((String)sAPIList.get(1), params, "GET", listener);
    }

    public void toME(long since_id, long max_id, int count, int page, int authorType, int sourceType, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page);
        params.put("filter_by_author", authorType);
        params.put("filter_by_source", sourceType);
        this.requestAsync((String)sAPIList.get(0), params, "GET", listener);
    }

    public void timeline(long since_id, long max_id, int count, int page, boolean trim_user, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page);
        params.put("trim_user", trim_user ? 1 : 0);
        this.requestAsync((String)sAPIList.get(3), params, "GET", listener);
    }

    public void mentions(long since_id, long max_id, int count, int page, int authorType, int sourceType, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page);
        params.put("filter_by_author", authorType);
        params.put("filter_by_source", sourceType);
        this.requestAsync((String)sAPIList.get(4), params, "GET", listener);
    }

    public void showBatch(long[] cids, RequestListener listener) {
        WeiboParameters params = this.buildShowOrDestoryBatchParams(cids);
        this.requestAsync((String)sAPIList.get(5), params, "GET", listener);
    }

    public void create(String comment, long id, boolean comment_ori, RequestListener listener) {
        WeiboParameters params = this.buildCreateParams(comment, id, comment_ori);
        this.requestAsync((String)sAPIList.get(6), params, "POST", listener);
    }

    public void destroy(long cid, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("cid", cid);
        this.requestAsync((String)sAPIList.get(7), params, "POST", listener);
    }

    public void destroyBatch(long[] ids, RequestListener listener) {
        WeiboParameters params = this.buildShowOrDestoryBatchParams(ids);
        this.requestAsync((String)sAPIList.get(8), params, "POST", listener);
    }

    public void reply(long cid, long id, String comment, boolean without_mention, boolean comment_ori, RequestListener listener) {
        WeiboParameters params = this.buildReplyParams(cid, id, comment, without_mention, comment_ori);
        this.requestAsync((String)sAPIList.get(9), params, "POST", listener);
    }

    public String showSync(long id, long since_id, long max_id, int count, int page, int authorType) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page);
        params.put("id", id);
        params.put("filter_by_author", authorType);
        return this.requestSync((String)sAPIList.get(2), params, "GET");
    }

    public String byMESync(long since_id, long max_id, int count, int page, int sourceType) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page);
        params.put("filter_by_source", sourceType);
        return this.requestSync((String)sAPIList.get(1), params, "GET");
    }

    public String toMESync(long since_id, long max_id, int count, int page, int authorType, int sourceType) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page);
        params.put("filter_by_author", authorType);
        params.put("filter_by_source", sourceType);
        return this.requestSync((String)sAPIList.get(0), params, "GET");
    }

    public String timelineSync(long since_id, long max_id, int count, int page, boolean trim_user) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page);
        params.put("trim_user", trim_user ? 1 : 0);
        return this.requestSync((String)sAPIList.get(3), params, "GET");
    }

    public String mentionsSync(long since_id, long max_id, int count, int page, int authorType, int sourceType) {
        WeiboParameters params = this.buildTimeLineParamsBase(since_id, max_id, count, page);
        params.put("filter_by_author", authorType);
        params.put("filter_by_source", sourceType);
        return this.requestSync((String)sAPIList.get(4), params, "GET");
    }

    public String showBatchSync(long[] cids) {
        WeiboParameters params = this.buildShowOrDestoryBatchParams(cids);
        return this.requestSync((String)sAPIList.get(5), params, "GET");
    }

    public String createSync(String comment, long id, boolean comment_ori) {
        WeiboParameters params = this.buildCreateParams(comment, id, comment_ori);
        return this.requestSync((String)sAPIList.get(6), params, "POST");
    }

    public String destroySync(long cid) {
        WeiboParameters params = new WeiboParameters();
        params.put("cid", cid);
        return this.requestSync((String)sAPIList.get(7), params, "POST");
    }

    public String destroyBatchSync(long[] ids) {
        WeiboParameters params = this.buildShowOrDestoryBatchParams(ids);
        return this.requestSync((String)sAPIList.get(8), params, "POST");
    }

    public String replySync(long cid, long id, String comment, boolean without_mention, boolean comment_ori) {
        WeiboParameters params = this.buildReplyParams(cid, id, comment, without_mention, comment_ori);
        return this.requestSync((String)sAPIList.get(9), params, "POST");
    }

    private WeiboParameters buildTimeLineParamsBase(long since_id, long max_id, int count, int page) {
        WeiboParameters params = new WeiboParameters();
        params.put("since_id", since_id);
        params.put("max_id", max_id);
        params.put("count", count);
        params.put("page", page);
        return params;
    }

    private WeiboParameters buildShowOrDestoryBatchParams(long[] cids) {
        WeiboParameters params = new WeiboParameters();
        StringBuilder strb = new StringBuilder();
        for (long cid : cids) {
            strb.append(cid).append(",");
        }
        strb.deleteCharAt(strb.length() - 1);
        params.put("cids", strb.toString());
        return params;
    }

    private WeiboParameters buildCreateParams(String comment, long id, boolean comment_ori) {
        WeiboParameters params = new WeiboParameters();
        params.put("comment", comment);
        params.put("id", id);
        params.put("comment_ori", comment_ori ? 1 : 0);
        return params;
    }

    private WeiboParameters buildReplyParams(long cid, long id, String comment, boolean without_mention, boolean comment_ori) {
        WeiboParameters params = new WeiboParameters();
        params.put("cid", cid);
        params.put("id", id);
        params.put("comment", comment);
        params.put("without_mention", without_mention ? 1 : 0);
        params.put("comment_ori", comment_ori ? 1 : 0);
        return params;
    }

    static {
        sAPIList.put(0, (Object)"https://api.weibo.com/2/comments/to_me.json");
        sAPIList.put(1, (Object)"https://api.weibo.com/2/comments/by_me.json");
        sAPIList.put(2, (Object)"https://api.weibo.com/2/comments/show.json");
        sAPIList.put(3, (Object)"https://api.weibo.com/2/comments/timeline.json");
        sAPIList.put(4, (Object)"https://api.weibo.com/2/comments/mentions.json");
        sAPIList.put(5, (Object)"https://api.weibo.com/2/comments/show_batch.json");
        sAPIList.put(6, (Object)"https://api.weibo.com/2/comments/create.json");
        sAPIList.put(7, (Object)"https://api.weibo.com/2/comments/destroy.json");
        sAPIList.put(8, (Object)"https://api.weibo.com/2/comments/sdestroy_batch.json");
        sAPIList.put(9, (Object)"https://api.weibo.com/2/comments/reply.json");
    }
}

