/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.widget;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import com.sina.weibo.sdk.R;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.auth.WeiboAuth;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.auth.sso.SsoHandler;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.openapi.LogoutAPI;
import com.sina.weibo.sdk.utils.LogUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class LoginoutButton
extends Button
implements View.OnClickListener {
    private static final String TAG = "LoginButton";
    private Context mContext;
    private WeiboAuth.AuthInfo mAuthInfo;
    private SsoHandler mSsoHandler;
    private WeiboAuthListener mAuthListener;
    private Oauth2AccessToken mAccessToken;
    private RequestListener mLogoutListener;
    private View.OnClickListener mExternalOnClickListener;

    public LoginoutButton(Context context) {
        this(context, null);
    }

    public LoginoutButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoginoutButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialize(context, attrs);
    }

    public void setWeiboAuthInfo(WeiboAuth.AuthInfo authInfo, WeiboAuthListener authListener) {
        this.mAuthInfo = authInfo;
        this.mAuthListener = authListener;
    }

    public void setWeiboAuthInfo(String appKey, String redirectUrl, String scope, WeiboAuthListener authListener) {
        this.mAuthInfo = new WeiboAuth.AuthInfo(this.mContext, appKey, redirectUrl, scope);
        this.mAuthListener = authListener;
    }

    public void setLogoutInfo(Oauth2AccessToken accessToken, RequestListener logoutListener) {
        this.mAccessToken = accessToken;
        this.mLogoutListener = logoutListener;
        if (this.mAccessToken != null && this.mAccessToken.isSessionValid()) {
            this.setText(R.string.com_sina_weibo_sdk_logout);
        }
    }

    public void setLogoutListener(RequestListener logoutListener) {
        this.mLogoutListener = logoutListener;
    }

    public void setExternalOnClickListener(View.OnClickListener l) {
        this.mExternalOnClickListener = l;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mSsoHandler != null) {
            this.mSsoHandler.authorizeCallBack(requestCode, resultCode, data);
        }
    }

    public void onClick(View v) {
        if (this.mExternalOnClickListener != null) {
            this.mExternalOnClickListener.onClick(v);
        }
        if (this.mAccessToken != null && this.mAccessToken.isSessionValid()) {
            this.logout();
        } else {
            this.login();
        }
    }

    private void initialize(Context context, AttributeSet attrs) {
        this.mContext = context;
        this.setOnClickListener(this);
        this.loadDefaultStyle(attrs);
    }

    private void loadDefaultStyle(AttributeSet attrs) {
        if (attrs != null && 0 == attrs.getStyleAttribute()) {
            Resources res = this.getResources();
            this.setBackgroundResource(R.drawable.com_sina_weibo_sdk_button_blue);
            this.setPadding(res.getDimensionPixelSize(R.dimen.com_sina_weibo_sdk_loginview_padding_left), res.getDimensionPixelSize(R.dimen.com_sina_weibo_sdk_loginview_padding_top), res.getDimensionPixelSize(R.dimen.com_sina_weibo_sdk_loginview_padding_right), res.getDimensionPixelSize(R.dimen.com_sina_weibo_sdk_loginview_padding_bottom));
            this.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_com_sina_weibo_sdk_logo, 0, 0, 0);
            this.setCompoundDrawablePadding(res.getDimensionPixelSize(R.dimen.com_sina_weibo_sdk_loginview_compound_drawable_padding));
            this.setTextColor(res.getColor(R.color.com_sina_weibo_sdk_loginview_text_color));
            this.setTextSize(0, res.getDimension(R.dimen.com_sina_weibo_sdk_loginview_text_size));
            this.setTypeface(Typeface.DEFAULT_BOLD);
            this.setGravity(17);
            this.setText(R.string.com_sina_weibo_sdk_login_with_weibo_account);
        }
    }

    private void login() {
        LogUtil.i((String)TAG, (String)"Click to login");
        if (null == this.mSsoHandler && this.mAuthInfo != null) {
            WeiboAuth weiboAuth = new WeiboAuth(this.mContext, this.mAuthInfo);
            this.mSsoHandler = new SsoHandler((Activity)this.mContext, weiboAuth);
        }
        if (this.mSsoHandler != null) {
            this.mSsoHandler.authorize(new WeiboAuthListener(){

                public void onComplete(Bundle values) {
                    LoginoutButton.this.mAccessToken = Oauth2AccessToken.parseAccessToken((Bundle)values);
                    if (LoginoutButton.this.mAccessToken.isSessionValid()) {
                        LoginoutButton.this.setText(R.string.com_sina_weibo_sdk_logout);
                    }
                    if (LoginoutButton.this.mAuthListener != null) {
                        LoginoutButton.this.mAuthListener.onComplete(values);
                    }
                }

                public void onCancel() {
                    if (LoginoutButton.this.mAuthListener != null) {
                        LoginoutButton.this.mAuthListener.onCancel();
                    }
                }

                public void onWeiboException(WeiboException e) {
                    if (LoginoutButton.this.mAuthListener != null) {
                        LoginoutButton.this.mAuthListener.onWeiboException(e);
                    }
                }
            });
        } else {
            LogUtil.e((String)TAG, (String)"Please setWeiboAuthInfo(...) for first");
        }
    }

    private void logout() {
        if (this.mAccessToken != null && this.mAccessToken.isSessionValid()) {
            LogUtil.i((String)TAG, (String)"Click to logout");
            new LogoutAPI(this.mAccessToken).logout(new RequestListener(){

                public void onComplete(String response) {
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        try {
                            JSONObject obj = new JSONObject(response);
                            if (obj.isNull("error")) {
                                String value = obj.getString("result");
                                if ("true".equalsIgnoreCase(value)) {
                                    LoginoutButton.this.mAccessToken = null;
                                    LoginoutButton.this.setText(R.string.com_sina_weibo_sdk_login_with_weibo_account);
                                }
                            } else {
                                String error_code = obj.getString("error_code");
                                if (error_code.equals("21317")) {
                                    LoginoutButton.this.mAccessToken = null;
                                    LoginoutButton.this.setText(R.string.com_sina_weibo_sdk_login_with_weibo_account);
                                }
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    if (LoginoutButton.this.mLogoutListener != null) {
                        LoginoutButton.this.mLogoutListener.onComplete(response);
                    }
                }

                public void onWeiboException(WeiboException e) {
                    LogUtil.e((String)LoginoutButton.TAG, (String)("WeiboException\uff1a " + e.getMessage()));
                    LoginoutButton.this.setText(R.string.com_sina_weibo_sdk_logout);
                    if (LoginoutButton.this.mLogoutListener != null) {
                        LoginoutButton.this.mLogoutListener.onWeiboException(e);
                    }
                }
            });
        }
    }
}

