/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class SuggestionsAPI
extends AbsOpenAPI {
    private static final String SERVER_URL_PRIX = "https://api.weibo.com/2/suggestions";

    public SuggestionsAPI(Oauth2AccessToken accessToken) {
        super(accessToken);
    }

    public void usersHot(USER_CATEGORY category, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("category", category.name());
        this.requestAsync("https://api.weibo.com/2/suggestions/users/hot.json", params, "GET", listener);
    }

    public void mayInterested(int count, int page, RequestListener listener) {
        WeiboParameters params = this.builderCountPage(count, page);
        this.requestAsync("https://api.weibo.com/2/suggestions/users/may_interested.json", params, "GET", listener);
    }

    public void byStatus(String content, int num, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("content", content);
        params.put("num", num);
        this.requestAsync("https://api.weibo.com/2/suggestions/users/may_interested.json", params, "GET", listener);
    }

    public void statusesHot(STATUSES_TYPE type, boolean is_pic, int count, int page, RequestListener listener) {
        WeiboParameters params = this.builderCountPage(count, page);
        params.put("type", type.ordinal() + 1);
        params.put("is_pic", is_pic ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/suggestions/statuses/hot.json", params, "GET", listener);
    }

    public void favoritesHot(int count, int page, RequestListener listener) {
        WeiboParameters params = this.builderCountPage(count, page);
        this.requestAsync("https://api.weibo.com/2/suggestions/favorites/hot.json", params, "GET", listener);
    }

    public void notInterested(long uid, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("uid", uid);
        this.requestAsync("https://api.weibo.com/2/suggestions/users/not_interested.json", params, "POST", listener);
    }

    private WeiboParameters builderCountPage(int count, int page) {
        WeiboParameters params = new WeiboParameters();
        params.put("count", count);
        params.put("page", page);
        return params;
    }

    public static enum STATUSES_TYPE {
        ENTERTAINMENT,
        FUNNY,
        BEAUTY,
        VIDEO,
        CONSTELLATION,
        LOVELY,
        FASHION,
        CARS,
        CATE,
        MUSIC;

    }

    public static enum USER_CATEGORY {
        DEFAULT,
        ent,
        hk_famous,
        model,
        cooking,
        sports,
        finance,
        tech,
        singer,
        writer,
        moderator,
        medium,
        stockplayer;

    }
}

