/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import android.graphics.Bitmap;
import android.text.TextUtils;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class StatusesAPI
extends AbsOpenAPI {
    public static final int FEATURE_ALL = 0;
    public static final int FEATURE_ORIGINAL = 1;
    public static final int FEATURE_PICTURE = 2;
    public static final int FEATURE_VIDEO = 3;
    public static final int FEATURE_MUSICE = 4;
    public static final int AUTHOR_FILTER_ALL = 0;
    public static final int AUTHOR_FILTER_ATTENTIONS = 1;
    public static final int AUTHOR_FILTER_STRANGER = 2;
    public static final int SRC_FILTER_ALL = 0;
    public static final int SRC_FILTER_WEIBO = 1;
    public static final int SRC_FILTER_WEIQUN = 2;
    public static final int TYPE_FILTER_ALL = 0;
    public static final int TYPE_FILTER_ORIGAL = 1;
    public static final int TYPE_STATUSES = 1;
    public static final int TYPE_COMMENTS = 2;
    public static final int TYPE_MESSAGE = 3;
    public static final int COMMENTS_NONE = 0;
    public static final int COMMENTS_CUR_STATUSES = 1;
    public static final int COMMENTS_RIGAL_STATUSES = 2;
    public static final int COMMENTS_BOTH = 3;
    public static final String EMOTION_TYPE_FACE = "face";
    public static final String EMOTION_TYPE_ANI = "ani";
    public static final String EMOTION_TYPE_CARTOON = "cartoon";
    public static final String LANGUAGE_CNNAME = "cnname";
    public static final String LANGUAGE_TWNAME = "twname";
    private static final String SERVER_URL_PRIX = "https://api.weibo.com/2/statuses";

    public StatusesAPI(Oauth2AccessToken accessToken) {
        super(accessToken);
    }

    public void publicTimeline(int count, int page, boolean base_app, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("count", count);
        params.put("page", page);
        params.put("base_app", base_app ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/statuses/public_timeline.json", params, "GET", listener);
    }

    public void friendsTimeline(long since_id, long max_id, int count, int page, boolean base_app, int featureType, boolean trim_user, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineWithAppTrim(since_id, max_id, count, page, base_app, trim_user, featureType);
        this.requestAsync("https://api.weibo.com/2/statuses/friends_timeline.json", params, "GET", listener);
    }

    public void friendsTimelineIds(long since_id, long max_id, int count, int page, boolean base_app, int featureType, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineWithApp(since_id, max_id, count, page, base_app, featureType);
        this.requestAsync("https://api.weibo.com/2/statuses/friends_timeline/ids.json", params, "GET", listener);
    }

    public void homeTimeline(long since_id, long max_id, int count, int page, boolean base_app, int featureType, boolean trim_user, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineWithAppTrim(since_id, max_id, count, page, base_app, trim_user, featureType);
        this.requestAsync("https://api.weibo.com/2/statuses/home_timeline.json", params, "GET", listener);
    }

    public void userTimeline(long uid, long since_id, long max_id, int count, int page, boolean base_app, int featureType, boolean trim_user, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineWithAppTrim(since_id, max_id, count, page, base_app, trim_user, featureType);
        params.put("uid", uid);
        this.requestAsync("https://api.weibo.com/2/statuses/user_timeline.json", params, "GET", listener);
    }

    public void userTimeline(String screen_name, long since_id, long max_id, int count, int page, boolean base_app, int featureType, boolean trim_user, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineWithAppTrim(since_id, max_id, count, page, base_app, trim_user, featureType);
        params.put("screen_name", screen_name);
        this.requestAsync("https://api.weibo.com/2/statuses/user_timeline.json", params, "GET", listener);
    }

    public void userTimeline(long since_id, long max_id, int count, int page, boolean base_app, int featureType, boolean trim_user, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineWithAppTrim(since_id, max_id, count, page, base_app, trim_user, featureType);
        this.requestAsync("https://api.weibo.com/2/statuses/user_timeline.json", params, "GET", listener);
    }

    public void userTimelineIds(long uid, long since_id, long max_id, int count, int page, boolean base_app, int featureType, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineWithApp(since_id, max_id, count, page, base_app, featureType);
        params.put("uid", uid);
        this.requestAsync("https://api.weibo.com/2/statuses/user_timeline/ids.json", params, "GET", listener);
    }

    public void userTimelineIds(String screen_name, long since_id, long max_id, int count, int page, boolean base_app, int featureType, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineWithApp(since_id, max_id, count, page, base_app, featureType);
        params.put("screen_name", screen_name);
        this.requestAsync("https://api.weibo.com/2/statuses/user_timeline/ids.json", params, "GET", listener);
    }

    public void repostTimeline(long id, long since_id, long max_id, int count, int page, int authorType, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineBase(since_id, max_id, count, page);
        params.put("id", id);
        params.put("filter_by_author", authorType);
        this.requestAsync("https://api.weibo.com/2/statuses/repost_timeline.json", params, "GET", listener);
    }

    public void repostTimelineIds(long id, long since_id, long max_id, int count, int page, int authorType, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineBase(since_id, max_id, count, page);
        params.put("id", id);
        params.put("filter_by_author", authorType);
        this.requestAsync("https://api.weibo.com/2/statuses/repost_timeline/ids.json", params, "GET", listener);
    }

    public void repostByMe(long since_id, long max_id, int count, int page, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineBase(since_id, max_id, count, page);
        this.requestAsync("https://api.weibo.com/2/statuses/repost_by_me.json", params, "GET", listener);
    }

    public void mentions(long since_id, long max_id, int count, int page, int authorType, int sourceType, int filterType, boolean trim_user, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineBase(since_id, max_id, count, page);
        params.put("filter_by_author", authorType);
        params.put("filter_by_source", sourceType);
        params.put("filter_by_type", filterType);
        params.put("trim_user", trim_user ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/statuses/mentions.json", params, "GET", listener);
    }

    public void mentionsIds(long since_id, long max_id, int count, int page, int authorType, int sourceType, int filterType, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineBase(since_id, max_id, count, page);
        params.put("filter_by_author", authorType);
        params.put("filter_by_source", sourceType);
        params.put("filter_by_type", filterType);
        this.requestAsync("https://api.weibo.com/2/statuses/mentions/ids.json", params, "GET", listener);
    }

    public void bilateralTimeline(long since_id, long max_id, int count, int page, boolean base_app, int featureType, boolean trim_user, RequestListener listener) {
        WeiboParameters params = this.buildTimeLineWithAppTrim(since_id, max_id, count, page, base_app, trim_user, featureType);
        this.requestAsync("https://api.weibo.com/2/statuses/bilateral_timeline.json", params, "GET", listener);
    }

    public void show(long id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("id", id);
        this.requestAsync("https://api.weibo.com/2/statuses/show.json", params, "GET", listener);
    }

    public void queryMID(long[] ids, int type, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        if (1 == ids.length) {
            params.put("id", ids[0]);
        } else {
            params.put("is_batch", 1);
            StringBuilder strb = new StringBuilder();
            for (long id : ids) {
                strb.append(id).append(",");
            }
            strb.deleteCharAt(strb.length() - 1);
            params.put("id", strb.toString());
        }
        params.put("type", type);
        this.requestAsync("https://api.weibo.com/2/statuses/querymid.json", params, "GET", listener);
    }

    public void queryID(String[] mids, int type, boolean inbox, boolean isBase62, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        if (mids != null) {
            if (1 == mids.length) {
                params.put("mid", mids[0]);
            } else {
                params.put("is_batch", 1);
                StringBuilder strb = new StringBuilder();
                for (String mid : mids) {
                    strb.append(mid).append(",");
                }
                strb.deleteCharAt(strb.length() - 1);
                params.put("mid", strb.toString());
            }
        }
        params.put("type", type);
        params.put("inbox", inbox ? 1 : 0);
        params.put("isBase62", isBase62 ? 1 : 0);
        this.requestAsync("https://api.weibo.com/2/statuses/queryid.json", params, "GET", listener);
    }

    public void hotRepostDaily(int count, boolean base_app, RequestListener listener) {
        WeiboParameters params = this.buildHotParams(count, base_app);
        this.requestAsync("https://api.weibo.com/2/statuses/hot/repost_daily.json", params, "GET", listener);
    }

    public void hotRepostWeekly(int count, boolean base_app, RequestListener listener) {
        WeiboParameters params = this.buildHotParams(count, base_app);
        this.requestAsync("https://api.weibo.com/2/statuses/hot/repost_weekly.json", params, "GET", listener);
    }

    public void hotCommentsDaily(int count, boolean base_app, RequestListener listener) {
        WeiboParameters params = this.buildHotParams(count, base_app);
        this.requestAsync("https://api.weibo.com/2/statuses/hot/comments_daily.json", params, "GET", listener);
    }

    public void hotCommentsWeekly(int count, boolean base_app, RequestListener listener) {
        WeiboParameters params = this.buildHotParams(count, base_app);
        this.requestAsync("https://api.weibo.com/2/statuses/hot/comments_weekly.json", params, "GET", listener);
    }

    public void count(String[] ids, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        StringBuilder strb = new StringBuilder();
        for (String id : ids) {
            strb.append(id).append(",");
        }
        strb.deleteCharAt(strb.length() - 1);
        params.put("ids", strb.toString());
        this.requestAsync("https://api.weibo.com/2/statuses/count.json", params, "GET", listener);
    }

    public void repost(long id, String status, int commentType, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("id", id);
        params.put("status", status);
        params.put("is_comment", commentType);
        this.requestAsync("https://api.weibo.com/2/statuses/repost.json", params, "POST", listener);
    }

    public void destroy(long id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("id", id);
        this.requestAsync("https://api.weibo.com/2/statuses/destroy.json", params, "POST", listener);
    }

    public void update(String content, String lat, String lon, RequestListener listener) {
        WeiboParameters params = this.buildUpdateParams(content, lat, lon);
        this.requestAsync("https://api.weibo.com/2/statuses/update.json", params, "POST", listener);
    }

    public void upload(String content, Bitmap bitmap, String lat, String lon, RequestListener listener) {
        WeiboParameters params = this.buildUpdateParams(content, lat, lon);
        params.put("pic", bitmap);
        this.requestAsync("https://api.weibo.com/2/statuses/upload.json", params, "POST", listener);
    }

    public void uploadUrlText(String status, String imageUrl, String pic_id, String lat, String lon, RequestListener listener) {
        WeiboParameters params = this.buildUpdateParams(status, lat, lon);
        params.put("url", imageUrl);
        params.put("pic_id", pic_id);
        this.requestAsync("https://api.weibo.com/2/statuses/upload_url_text.json", params, "POST", listener);
    }

    public void emotions(String type, String language, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("type", type);
        params.put("language", language);
        this.requestAsync("https://api.weibo.com/2/emotions.json", params, "GET", listener);
    }

    private WeiboParameters buildTimeLineBase(long since_id, long max_id, int count, int page) {
        WeiboParameters params = new WeiboParameters();
        params.put("since_id", since_id);
        params.put("max_id", max_id);
        params.put("count", count);
        params.put("page", page);
        return params;
    }

    private WeiboParameters buildTimeLineWithApp(long since_id, long max_id, int count, int page, boolean base_app, int featureType) {
        WeiboParameters params = this.buildTimeLineBase(since_id, max_id, count, page);
        params.put("feature", featureType);
        params.put("base_app", base_app ? 1 : 0);
        return params;
    }

    private WeiboParameters buildTimeLineWithAppTrim(long since_id, long max_id, int count, int page, boolean base_app, boolean trim_user, int featureType) {
        WeiboParameters params = this.buildTimeLineWithApp(since_id, max_id, count, page, base_app, featureType);
        params.put("trim_user", trim_user ? 1 : 0);
        return params;
    }

    private WeiboParameters buildHotParams(int count, boolean base_app) {
        WeiboParameters params = new WeiboParameters();
        params.put("count", count);
        params.put("base_app", base_app ? 1 : 0);
        return params;
    }

    private WeiboParameters buildUpdateParams(String content, String lat, String lon) {
        WeiboParameters params = new WeiboParameters();
        params.put("status", content);
        if (!TextUtils.isEmpty((CharSequence)lon)) {
            params.put("long", lon);
        }
        if (!TextUtils.isEmpty((CharSequence)lat)) {
            params.put("lat", lat);
        }
        return params;
    }
}

