/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi.legacy;

import android.text.TextUtils;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class GroupAPI
extends AbsOpenAPI {
    public static final int FEATURE_ALL = 0;
    public static final int FEATURE_ORIGINAL = 1;
    public static final int FEATURE_PICTURE = 2;
    public static final int FEATURE_VIDEO = 3;
    public static final int FEATURE_MUSICE = 4;
    private static final String SERVER_URL_PRIX = "https://api.weibo.com/2/friendships/groups";

    public GroupAPI(Oauth2AccessToken accessToken) {
        super(accessToken);
    }

    public void groups(RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        this.requestAsync("https://api.weibo.com/2/friendships/groups.json", params, "GET", listener);
    }

    public void timeline(long list_id, long since_id, long max_id, int count, int page, boolean base_app, int featureType, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("list_id", list_id);
        params.put("since_id", since_id);
        params.put("max_id", max_id);
        params.put("count", count);
        params.put("page", page);
        params.put("base_app", base_app ? 1 : 0);
        params.put("feature", featureType);
        this.requestAsync("https://api.weibo.com/2/friendships/groups/timeline.json", params, "GET", listener);
    }

    public void timelineIds() {
    }

    public void members(long list_id, int count, int cursor, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("list_id", list_id);
        params.put("count", count);
        params.put("cursor", cursor);
        this.requestAsync("https://api.weibo.com/2/friendships/groups/members.json", params, "GET", listener);
    }

    public void membersIds() {
    }

    public void memberDescriptionPatch() {
    }

    public void isMember(long uid, long list_id, RequestListener listener) {
        WeiboParameters params = this.buildeMembersParams(list_id, uid);
        this.requestAsync("https://api.weibo.com/2/friendships/groups/is_member.json", params, "GET", listener);
    }

    public void listed() {
    }

    public void showGroup(long list_id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("list_id", list_id);
        this.requestAsync("https://api.weibo.com/2/friendships/groups/show.json", params, "GET", listener);
    }

    public void showGroupBatch(String list_ids, long uids, RequestListener listener) {
        WeiboParameters params = this.buildeMembersParams(Long.valueOf(list_ids), uids);
        this.requestAsync("https://api.weibo.com/2/friendships/groups/show_batch.json", params, "GET", listener);
    }

    public void create(String name, String description, String tags, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("name", name);
        if (!TextUtils.isEmpty((CharSequence)description)) {
            params.put("description", description);
        }
        if (!TextUtils.isEmpty((CharSequence)tags)) {
            params.put("tags", tags);
        }
        this.requestAsync("https://api.weibo.com/2/friendships/groups/create.json", params, "POST", listener);
    }

    public void update(long list_id, String name, String description, String tags, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("list_id", list_id);
        if (!TextUtils.isEmpty((CharSequence)name)) {
            params.put("name", name);
        }
        if (!TextUtils.isEmpty((CharSequence)description)) {
            params.put("description", description);
        }
        if (!TextUtils.isEmpty((CharSequence)tags)) {
            params.put("tags", tags);
        }
        this.requestAsync("https://api.weibo.com/2/friendships/groups/update.json", params, "POST", listener);
    }

    public void deleteGroup(long list_id, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("list_id", list_id);
        this.requestAsync("https://api.weibo.com/2/friendships/groups/destroy.json", params, "POST", listener);
    }

    public void addMember(long list_id, long uid, RequestListener listener) {
        WeiboParameters params = this.buildeMembersParams(list_id, uid);
        this.requestAsync("https://api.weibo.com/2/friendships/groups/members/add.json", params, "POST", listener);
    }

    public void addMemberBatch(long list_id, String uids, String group_descriptions, RequestListener listener) {
        WeiboParameters params = this.buildeMembersParams(list_id, Long.valueOf(uids));
        params.put("group_descriptions", group_descriptions);
        this.requestAsync("https://api.weibo.com/2/friendships/groups/members/add_batch.json", params, "POST", listener);
    }

    public void updateMembers(long list_id, long uid, String group_description, RequestListener listener) {
        WeiboParameters params = this.buildeMembersParams(list_id, uid);
        if (!TextUtils.isDigitsOnly((CharSequence)group_description)) {
            params.put("group_description", group_description);
        }
        this.requestAsync("https://api.weibo.com/2/friendships/groups/members/update.json", params, "POST", listener);
    }

    public void deleteMembers(long list_id, long uid, RequestListener listener) {
        WeiboParameters params = this.buildeMembersParams(list_id, uid);
        this.requestAsync("https://api.weibo.com/2/friendships/groups/members/destroy.json", params, "POST", listener);
    }

    public void order(String list_ids, int count, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("list_id", list_ids);
        params.put("count", count);
        this.requestAsync("https://api.weibo.com/2/friendships/groups/order.json", params, "POST", listener);
    }

    private WeiboParameters buildeMembersParams(long list_id, long uid) {
        WeiboParameters params = new WeiboParameters();
        params.put("list_id", list_id);
        params.put("uid", uid);
        return params;
    }
}

