/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.openapi;

import android.util.SparseArray;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.openapi.AbsOpenAPI;

public class UsersAPI
extends AbsOpenAPI {
    private static final int READ_USER = 0;
    private static final int READ_USER_BY_DOMAIN = 1;
    private static final int READ_USER_COUNT = 2;
    private static final String API_BASE_URL = "https://api.weibo.com/2/users";
    private static final SparseArray<String> sAPIList = new SparseArray();

    public UsersAPI(Oauth2AccessToken accessToken) {
        super(accessToken);
    }

    public void show(long uid, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("uid", uid);
        this.requestAsync((String)sAPIList.get(0), params, "GET", listener);
    }

    public void show(String screen_name, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("screen_name", screen_name);
        this.requestAsync((String)sAPIList.get(0), params, "GET", listener);
    }

    public void domainShow(String domain, RequestListener listener) {
        WeiboParameters params = new WeiboParameters();
        params.put("domain", domain);
        this.requestAsync((String)sAPIList.get(1), params, "GET", listener);
    }

    public void counts(long[] uids, RequestListener listener) {
        WeiboParameters params = this.buildCountsParams(uids);
        this.requestAsync((String)sAPIList.get(2), params, "GET", listener);
    }

    public String showSync(long uid) {
        WeiboParameters params = new WeiboParameters();
        params.put("uid", uid);
        return this.requestSync((String)sAPIList.get(0), params, "GET");
    }

    public String showSync(String screen_name) {
        WeiboParameters params = new WeiboParameters();
        params.put("screen_name", screen_name);
        return this.requestSync((String)sAPIList.get(0), params, "GET");
    }

    public String domainShowSync(String domain) {
        WeiboParameters params = new WeiboParameters();
        params.put("domain", domain);
        return this.requestSync((String)sAPIList.get(1), params, "GET");
    }

    public String countsSync(long[] uids) {
        WeiboParameters params = this.buildCountsParams(uids);
        return this.requestSync((String)sAPIList.get(2), params, "GET");
    }

    private WeiboParameters buildCountsParams(long[] uids) {
        WeiboParameters params = new WeiboParameters();
        StringBuilder strb = new StringBuilder();
        for (long cid : uids) {
            strb.append(cid).append(",");
        }
        strb.deleteCharAt(strb.length() - 1);
        params.put("uids", strb.toString());
        return params;
    }

    static {
        sAPIList.put(0, (Object)"https://api.weibo.com/2/users/show.json");
        sAPIList.put(1, (Object)"https://api.weibo.com/2/users/domain_show.json");
        sAPIList.put(2, (Object)"https://api.weibo.com/2/users/counts.json");
    }
}

