/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.db;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;

public class WeiboInfoDB {
    private static final Uri WEIBO_NAME_URI = Uri.parse((String)"content://com.sina.weibo.sdkProvider/query/package");

    public static void initWeiboInfo(Context ct, boolean isDownWeibo) {
        ContentResolver cr = ct.getContentResolver();
        Cursor cursor = null;
        try {
            try {
                WeiboInfo.isDownWeibo = isDownWeibo;
                cursor = cr.query(WEIBO_NAME_URI, null, null, null, null);
                int packageIndex = cursor.getColumnIndex("package");
                int versionNameIndex = cursor.getColumnIndex("version_name");
                int versionCodeIndex = cursor.getColumnIndex("version_code");
                int supportApiIndex = cursor.getColumnIndex("support_api");
                if (cursor.moveToFirst()) {
                    WeiboInfo.packageName = cursor.getString(packageIndex);
                    WeiboInfo.versionName = cursor.getString(versionNameIndex);
                    WeiboInfo.versionCode = cursor.getInt(versionCodeIndex);
                    WeiboInfo.supportApi = cursor.getInt(supportApiIndex);
                }
            }
            catch (Exception e) {
                Log.e((String)"WeiboInfoDB", (String)"get db error");
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public static int getSupportApi() {
        return WeiboInfo.supportApi;
    }

    public static String getPackageName() {
        return WeiboInfo.packageName;
    }

    public static String getVersionName() {
        return WeiboInfo.versionName;
    }

    public static int getVersionCode() {
        return WeiboInfo.versionCode;
    }

    public static boolean isDownWeibo() {
        return WeiboInfo.isDownWeibo;
    }

    private static class WeiboInfo {
        public static int supportApi;
        public static String packageName;
        public static String versionName;
        public static int versionCode;
        public static boolean isDownWeibo;

        private WeiboInfo() {
        }
    }
}

