/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.StrictMode;
import com.parse.ParseException;
import com.parse.ParseObject;
import com.parse.ParseRESTCommand;
import com.parse.ParseRequest;
import com.parse.ParseTaskUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

class ParseTestUtils {
    private static final Object TEST_SERVER_LOCK = new Object();
    private static String testServer;
    private static final AtomicBoolean strictModeEnabled;

    ParseTestUtils() {
    }

    public static String useServer(String theServer) {
        String oldServer = ParseObject.server;
        ParseObject.server = theServer;
        return oldServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTestServer(String server) {
        Object object = TEST_SERVER_LOCK;
        synchronized (object) {
            testServer = server;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTestServer(Context context) {
        if (testServer == null) {
            Object object = TEST_SERVER_LOCK;
            synchronized (object) {
                if (testServer == null) {
                    try {
                        BufferedReader br = new BufferedReader(new InputStreamReader(context.getAssets().open("server.config")));
                        testServer = br.readLine();
                    }
                    catch (Exception e) {
                        testServer = Build.PRODUCT.contains("vbox") ? "http://192.168.56.1:3000" : (Build.PRODUCT.contains("sdk") || Build.PRODUCT.contains("full_x86") ? "http://10.0.2.2:3000" : "http://localhost:3000");
                    }
                }
            }
        }
        return testServer;
    }

    public static String useTestServer(Context context) {
        return ParseTestUtils.useServer(ParseTestUtils.getTestServer(context));
    }

    public static String useBadServerPort() {
        return ParseTestUtils.useBadServerPort(ParseObject.server);
    }

    public static String useInvalidServer() {
        return ParseTestUtils.useServer("http://invalid.server:3000");
    }

    public static String useBadServerPort(String baseUrl) {
        String newUrl = "http://10.0.2.2:6000";
        try {
            URL base = new URL(baseUrl);
            newUrl = base.getProtocol() + "://" + base.getHost() + ":" + (base.getPort() + 999);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return ParseTestUtils.useServer(newUrl);
    }

    public static void clearApp() {
        ParseRESTCommand command = new ParseRESTCommand("rest_clear_app", ParseRequest.Method.POST, new JSONObject(), null);
        try {
            ParseTaskUtils.wait(command.executeAsync());
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void setStrictModeEnabledForMainThread(final boolean enabled) {
        if (strictModeEnabled.compareAndSet(!enabled, enabled)) {
            final Semaphore done = new Semaphore(0);
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    ParseTestUtils.setStrictModeEnabledForThisThread(enabled);
                    done.release();
                }
            });
            done.acquireUninterruptibly();
        }
    }

    public static void setStrictModeEnabledForThisThread(boolean enabled) {
        if (enabled) {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().detectAll().penaltyLog().penaltyDeath().build());
        } else {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().detectAll().penaltyLog().build());
        }
    }

    static {
        strictModeEnabled = new AtomicBoolean(false);
    }
}

