/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseACL;
import com.parse.ParseClassName;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseRelation;
import com.parse.ParseUser;
import java.util.regex.Pattern;

@ParseClassName(value="_Role")
public class ParseRole
extends ParseObject {
    private static final Pattern NAME_PATTERN = Pattern.compile("^[0-9a-zA-Z_\\- ]+$");

    ParseRole() {
    }

    public ParseRole(String name) {
        this();
        this.setName(name);
    }

    public ParseRole(String name, ParseACL acl) {
        this(name);
        this.setACL(acl);
    }

    public void setName(String name) {
        this.put("name", name);
    }

    public String getName() {
        return this.getString("name");
    }

    public ParseRelation<ParseUser> getUsers() {
        return this.getRelation("users");
    }

    public ParseRelation<ParseRole> getRoles() {
        return this.getRelation("roles");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void validateSave() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.getObjectId() == null && this.getName() == null) {
                throw new IllegalStateException("New roles must specify a name.");
            }
            super.validateSave();
        }
    }

    @Override
    public void put(String key, Object value) {
        if ("name".equals(key)) {
            if (this.getObjectId() != null) {
                throw new IllegalArgumentException("A role's name can only be set before it has been saved.");
            }
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("A role's name must be a String.");
            }
            if (!NAME_PATTERN.matcher((String)value).matches()) {
                throw new IllegalArgumentException("A role's name can only contain alphanumeric characters, _, -, and spaces.");
            }
        }
        super.put(key, value);
    }

    public static ParseQuery<ParseRole> getQuery() {
        return ParseQuery.getQuery(ParseRole.class);
    }
}

