/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.os.Build;
import bolts.Continuation;
import bolts.Task;
import com.parse.PLog;
import com.parse.ParseException;
import com.parse.ParseExecutors;
import com.parse.ParseHttpBody;
import com.parse.ParseHttpClient;
import com.parse.ParseHttpRequest;
import com.parse.ParseHttpResponse;
import com.parse.ProgressCallback;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.client.ClientProtocolException;

abstract class ParseRequest<Response> {
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ParseRequest.NETWORK_EXECUTOR-thread-" + this.mCount.getAndIncrement());
        }
    };
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int MAX_POOL_SIZE = CPU_COUNT * 2 * 2 + 1;
    private static final long KEEP_ALIVE_TIME = 1L;
    private static final int MAX_QUEUE_SIZE = 128;
    static final ExecutorService NETWORK_EXECUTOR = ParseRequest.newThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), sThreadFactory);
    protected static final int DEFAULT_MAX_RETRIES = 4;
    static final long DEFAULT_INITIAL_RETRY_DELAY = 1000L;
    private static long defaultInitialRetryDelay = 1000L;
    private static ParseHttpClient defaultClient = null;
    private int maxRetries = 4;
    Method method;
    String url;

    private static ThreadPoolExecutor newThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, workQueue, threadFactory);
        if (Build.VERSION.SDK_INT >= 9) {
            executor.allowCoreThreadTimeOut(true);
        }
        return executor;
    }

    @Deprecated
    public static void setDefaultClient(ParseHttpClient client) {
        defaultClient = client;
    }

    @Deprecated
    public static ParseHttpClient getDefaultClient() {
        if (defaultClient == null) {
            throw new IllegalStateException("Can't send Parse HTTPS request before Parse.initialize()");
        }
        return defaultClient;
    }

    public static void setDefaultInitialRetryDelay(long delay) {
        defaultInitialRetryDelay = delay;
    }

    public static long getDefaultInitialRetryDelay() {
        return defaultInitialRetryDelay;
    }

    public ParseRequest(String url) {
        this(Method.GET, url);
    }

    public ParseRequest(Method method, String url) {
        this.method = method;
        this.url = url;
    }

    public void setMaxRetries(int max) {
        this.maxRetries = max;
    }

    protected ParseHttpBody newBody(ProgressCallback uploadProgressCallback) {
        return null;
    }

    protected ParseHttpRequest newRequest(Method method, String url, ProgressCallback uploadProgressCallback) {
        ParseHttpRequest.Builder requestBuilder = new ParseHttpRequest.Builder().setMethod(method).setUrl(url);
        switch (method) {
            case GET: 
            case DELETE: {
                break;
            }
            case POST: 
            case PUT: {
                requestBuilder.setBody(this.newBody(uploadProgressCallback));
                break;
            }
            default: {
                throw new IllegalStateException("Invalid method " + (Object)((Object)method));
            }
        }
        return requestBuilder.build();
    }

    private Task<Response> sendOneRequestAsync(final ParseHttpClient client, final ParseHttpRequest request, final ProgressCallback downloadProgressCallback) {
        return Task.forResult(null).onSuccessTask(new Continuation<Void, Task<Response>>(){

            public Task<Response> then(Task<Void> task) throws Exception {
                ParseHttpResponse response = client.execute(request);
                return ParseRequest.this.onResponseAsync(response, downloadProgressCallback);
            }
        }, (Executor)NETWORK_EXECUTOR).continueWithTask(new Continuation<Response, Task<Response>>(){

            public Task<Response> then(Task<Response> task) throws Exception {
                if (task.isFaulted()) {
                    Exception error = task.getError();
                    if (error instanceof ClientProtocolException) {
                        return Task.forError((Exception)ParseRequest.this.newTemporaryException("bad protocol", error));
                    }
                    if (error instanceof IOException) {
                        return Task.forError((Exception)ParseRequest.this.newTemporaryException("i/o failure", error));
                    }
                }
                return task;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    protected abstract Task<Response> onResponseAsync(ParseHttpResponse var1, ProgressCallback var2);

    public Task<Response> executeAsync() {
        return this.executeAsync(ParseRequest.getDefaultClient());
    }

    public Task<Response> executeAsync(Task<Void> cancellationToken) {
        return this.executeAsync(ParseRequest.getDefaultClient(), (ProgressCallback)null, null, cancellationToken);
    }

    public Task<Response> executeAsync(ProgressCallback uploadProgressCallback, ProgressCallback downloadProgressCallback, Task<Void> cancellationToken) {
        return this.executeAsync(ParseRequest.getDefaultClient(), uploadProgressCallback, downloadProgressCallback, cancellationToken);
    }

    public Task<Response> executeAsync(ParseHttpClient client) {
        return this.executeAsync(client, (ProgressCallback)null, null, null);
    }

    public Task<Response> executeAsync(ParseHttpClient client, Task<Void> cancellationToken) {
        return this.executeAsync(client, (ProgressCallback)null, null, cancellationToken);
    }

    public Task<Response> executeAsync(ParseHttpClient client, ProgressCallback uploadProgressCallback, ProgressCallback downloadProgressCallback) {
        return this.executeAsync(client, uploadProgressCallback, downloadProgressCallback, null);
    }

    public Task<Response> executeAsync(ParseHttpClient client, ProgressCallback uploadProgressCallback, ProgressCallback downloadProgressCallback, Task<Void> cancellationToken) {
        ParseHttpRequest request = this.newRequest(this.method, this.url, uploadProgressCallback);
        return this.executeAsync(client, request, downloadProgressCallback, cancellationToken);
    }

    private Task<Response> executeAsync(ParseHttpClient client, final ParseHttpRequest request, ProgressCallback downloadProgressCallback, Task<Void> cancellationToken) {
        long delay = defaultInitialRetryDelay + (long)((double)defaultInitialRetryDelay * Math.random());
        if (cancellationToken != null) {
            cancellationToken.continueWith((Continuation)new Continuation<Void, Void>(){

                public Void then(Task<Void> task) throws Exception {
                    request.cancel();
                    return null;
                }
            });
        }
        return this.executeAsync(client, request, 0, delay, downloadProgressCallback, cancellationToken);
    }

    private Task<Response> executeAsync(final ParseHttpClient client, final ParseHttpRequest request, final int attemptsMade, final long delay, final ProgressCallback downloadProgressCallback, final Task<Void> cancellationToken) {
        if (cancellationToken != null && cancellationToken.isCancelled()) {
            return Task.cancelled();
        }
        return this.sendOneRequestAsync(client, request, downloadProgressCallback).continueWithTask(new Continuation<Response, Task<Response>>(){

            public Task<Response> then(Task<Response> task) throws Exception {
                Exception e = task.getError();
                if (task.isFaulted() && e instanceof ParseException) {
                    if (cancellationToken != null && cancellationToken.isCancelled()) {
                        return Task.cancelled();
                    }
                    if (e instanceof ParseRequestException && ((ParseRequestException)e).isPermanentFailure) {
                        return task;
                    }
                    if (attemptsMade < ParseRequest.this.maxRetries) {
                        PLog.i("com.parse.ParseRequest", "Request failed. Waiting " + delay + " milliseconds before attempt #" + (attemptsMade + 1));
                        final Task.TaskCompletionSource retryTask = Task.create();
                        ParseExecutors.scheduled().schedule(new Runnable(){

                            @Override
                            public void run() {
                                ParseRequest.this.executeAsync(client, request, attemptsMade + 1, delay * 2L, downloadProgressCallback, (Task<Void>)cancellationToken).continueWithTask(new Continuation<Response, Task<Void>>(){

                                    public Task<Void> then(Task<Response> task) throws Exception {
                                        if (task.isCancelled()) {
                                            retryTask.setCancelled();
                                        } else if (task.isFaulted()) {
                                            retryTask.setError(task.getError());
                                        } else {
                                            retryTask.setResult(task.getResult());
                                        }
                                        return null;
                                    }
                                });
                            }
                        }, delay, TimeUnit.MILLISECONDS);
                        return retryTask.getTask();
                    }
                    if (!request.isCancelled()) {
                        PLog.i("com.parse.ParseRequest", "Request failed. Giving up.");
                    }
                }
                return task;
            }
        });
    }

    protected ParseException newPermanentException(int code, String message) {
        ParseRequestException e = new ParseRequestException(code, message);
        e.isPermanentFailure = true;
        return e;
    }

    protected ParseException newTemporaryException(int code, String message) {
        ParseRequestException e = new ParseRequestException(code, message);
        e.isPermanentFailure = false;
        return e;
    }

    protected ParseException newTemporaryException(String message, Throwable t) {
        ParseRequestException e = new ParseRequestException(100, message, t);
        e.isPermanentFailure = false;
        return e;
    }

    private static class ParseRequestException
    extends ParseException {
        boolean isPermanentFailure = false;

        public ParseRequestException(int theCode, String theMessage) {
            super(theCode, theMessage);
        }

        public ParseRequestException(int theCode, String message, Throwable cause) {
            super(theCode, message, cause);
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;


        public static Method fromString(String string) {
            Method method = null;
            switch (string) {
                case "GET": {
                    method = GET;
                    break;
                }
                case "POST": {
                    method = POST;
                    break;
                }
                case "PUT": {
                    method = PUT;
                    break;
                }
                case "DELETE": {
                    method = DELETE;
                    break;
                }
            }
            return method;
        }

        public String toString() {
            String string = null;
            switch (this) {
                case GET: {
                    string = "GET";
                    break;
                }
                case POST: {
                    string = "POST";
                    break;
                }
                case PUT: {
                    string = "PUT";
                    break;
                }
                case DELETE: {
                    string = "DELETE";
                    break;
                }
            }
            return string;
        }
    }
}

