/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseInstallation;
import com.parse.ParseQuery;
import com.parse.ParseRESTCommand;
import com.parse.ParseRequest;
import com.parse.PointerEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ParseRESTPushCommand
extends ParseRESTCommand {
    static final String KEY_CHANNELS = "channels";
    static final String KEY_WHERE = "where";
    static final String KEY_DEVICE_TYPE = "deviceType";
    static final String KEY_EXPIRATION_TIME = "expiration_time";
    static final String KEY_EXPIRATION_INTERVAL = "expiration_interval";
    static final String KEY_DATA = "data";

    public ParseRESTPushCommand(String httpPath, ParseRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }

    public static ParseRESTPushCommand sendPushCommand(ParseQuery.State<ParseInstallation> query, Set<String> targetChannels, String targetDeviceType, Long expirationTime, Long expirationInterval, JSONObject payload, String sessionToken) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (targetChannels != null) {
            parameters.put(KEY_CHANNELS, new JSONArray(targetChannels));
        } else {
            if (query != null) {
                ParseQuery.QueryConstraints where = query.constraints();
                JSONObject whereJSON = (JSONObject)PointerEncoder.get().encode(where);
                parameters.put(KEY_WHERE, whereJSON);
            }
            if (targetDeviceType != null) {
                JSONObject deviceTypeCondition = new JSONObject();
                try {
                    deviceTypeCondition.put(KEY_DEVICE_TYPE, (Object)targetDeviceType);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e.getMessage());
                }
                parameters.put(KEY_WHERE, deviceTypeCondition);
            }
            if (parameters.size() == 0) {
                parameters.put(KEY_WHERE, new JSONObject());
            }
        }
        if (expirationTime != null) {
            parameters.put(KEY_EXPIRATION_TIME, expirationTime);
        } else if (expirationInterval != null) {
            parameters.put(KEY_EXPIRATION_INTERVAL, expirationInterval);
        }
        if (payload != null) {
            parameters.put(KEY_DATA, payload);
        }
        return new ParseRESTPushCommand("push", ParseRequest.Method.POST, parameters, sessionToken);
    }
}

