/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.ManifestInfo;
import com.parse.ParseInstallation;
import java.util.Arrays;
import java.util.List;

class ParsePushChannelsController {
    static final String V2_PUSH_NOT_CONFIGURED = "In order to use the ParsePush.subscribe or ParsePush.unsubscribe methods you must add the following to your AndroidManifest.xml: \n<receiver android:name=\"com.parse.ParsePushBroadcastReceiver\"\n  android:exported=\"false\">\n  <intent-filter>\n    <action android:name=\"com.parse.push.intent.RECEIVE\" />\n    <action android:name=\"com.parse.push.intent.OPEN\" />\n    <action android:name=\"com.parse.push.intent.DELETE\" />\n  </intent-filter>\n</receiver>\n(Replace \"com.parse.ParsePushBroadcastReceiver\" with your own implementation if you choose to extend ParsePushBroadcastReceiver)";

    ParsePushChannelsController() {
    }

    public Task<Void> subscribeInBackground(String channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Can't subscribe to null channel.");
        }
        ParsePushChannelsController.checkForManifestAndThrowExceptionIfNeeded();
        ParseInstallation installation = ParseInstallation.getCurrentInstallation();
        List channels = installation.getList("channels");
        if (channels == null || installation.isDirty("channels") || !channels.contains(channel)) {
            installation.addUnique("channels", channel);
            return installation.saveInBackground();
        }
        return Task.forResult(null);
    }

    public Task<Void> unsubscribeInBackground(String channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Can't unsubscribe from null channel.");
        }
        ParsePushChannelsController.checkForManifestAndThrowExceptionIfNeeded();
        ParseInstallation installation = ParseInstallation.getCurrentInstallation();
        List channels = installation.getList("channels");
        if (channels != null && channels.contains(channel)) {
            installation.removeAll("channels", Arrays.asList(channel));
            return installation.saveInBackground();
        }
        return Task.forResult(null);
    }

    static void checkForManifestAndThrowExceptionIfNeeded() {
        if (!ManifestInfo.getPushUsesBroadcastReceivers()) {
            throw new IllegalStateException(V2_PUSH_NOT_CONFIGURED);
        }
    }
}

