/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ParseHttpResponse {
    int statusCode;
    InputStream content;
    int totalSize;
    String reasonPhrase;
    Map<String, String> headers;
    String contentType;

    ParseHttpResponse(Init<?> builder) {
        this.statusCode = ((Init)builder).statusCode;
        this.content = ((Init)builder).content;
        this.totalSize = ((Init)builder).totalSize;
        this.reasonPhrase = ((Init)builder).reasonPhrase;
        this.headers = ((Init)builder).headers;
        this.contentType = ((Init)builder).contentType;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public InputStream getContent() {
        return this.content;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getHeader(String name) {
        return this.headers == null ? null : this.headers.get(name);
    }

    public Map<String, String> getAllHeaders() {
        return this.headers;
    }

    public static class Builder
    extends Init<Builder> {
        @Override
        Builder self() {
            return this;
        }

        public ParseHttpResponse build() {
            return new ParseHttpResponse(this);
        }
    }

    static abstract class Init<T extends Init<T>> {
        private int statusCode;
        private InputStream content;
        private int totalSize;
        private String reasonPhrase;
        private Map<String, String> headers;
        private String contentType;

        Init() {
        }

        abstract T self();

        public T setStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this.self();
        }

        public T setContent(InputStream content) {
            this.content = content;
            return this.self();
        }

        public T setTotalSize(int totalSize) {
            this.totalSize = totalSize;
            return this.self();
        }

        public T setReasonPhase(String reasonPhase) {
            this.reasonPhrase = reasonPhase;
            return this.self();
        }

        public T setHeaders(Map<String, String> headers) {
            this.headers = Collections.unmodifiableMap(new HashMap<String, String>(headers));
            return this.self();
        }

        public T setContentType(String contentType) {
            this.contentType = contentType;
            return this.self();
        }
    }
}

