/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.AbstractQueryController;
import com.parse.CacheQueryController;
import com.parse.NetworkObjectController;
import com.parse.NetworkQueryController;
import com.parse.OfflineQueryController;
import com.parse.Parse;
import com.parse.ParseAnalyticsController;
import com.parse.ParseCloudCodeController;
import com.parse.ParseConfigController;
import com.parse.ParseCurrentConfigController;
import com.parse.ParseFileController;
import com.parse.ParseObjectController;
import com.parse.ParsePlugins;
import com.parse.ParsePushChannelsController;
import com.parse.ParsePushController;
import com.parse.ParseQueryController;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;

class ParseCorePlugins {
    private static final ParseCorePlugins INSTANCE = new ParseCorePlugins();
    static final String CURRENT_CONFIG_FILENAME = "currentConfig";
    private AtomicReference<ParseObjectController> objectController = new AtomicReference();
    private AtomicReference<ParseQueryController> queryController = new AtomicReference();
    private AtomicReference<ParseFileController> fileController = new AtomicReference();
    private AtomicReference<ParseAnalyticsController> analyticsController = new AtomicReference();
    private AtomicReference<ParseCloudCodeController> cloudCodeController = new AtomicReference();
    private AtomicReference<ParseConfigController> configController = new AtomicReference();
    private AtomicReference<ParsePushController> pushController = new AtomicReference();
    private AtomicReference<ParsePushChannelsController> pushChannelsController = new AtomicReference();

    public static ParseCorePlugins getInstance() {
        return INSTANCE;
    }

    private ParseCorePlugins() {
    }

    void reset() {
        this.objectController.set(null);
        this.queryController.set(null);
        this.fileController.set(null);
        this.analyticsController.set(null);
        this.cloudCodeController.set(null);
        this.configController.set(null);
        this.pushController.set(null);
        this.pushChannelsController.set(null);
    }

    public ParseObjectController getObjectController() {
        if (this.objectController.get() == null) {
            this.objectController.compareAndSet(null, new NetworkObjectController(ParsePlugins.get().restClient()));
        }
        return this.objectController.get();
    }

    public void registerObjectController(ParseObjectController controller) {
        if (!this.objectController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another object controller was already registered: " + this.objectController.get());
        }
    }

    public ParseQueryController getQueryController() {
        if (this.queryController.get() == null) {
            NetworkQueryController networkController = new NetworkQueryController(ParsePlugins.get().restClient());
            AbstractQueryController controller = Parse.isLocalDatastoreEnabled() ? new OfflineQueryController(Parse.getLocalDatastore(), networkController) : new CacheQueryController(networkController);
            this.queryController.compareAndSet(null, controller);
        }
        return this.queryController.get();
    }

    public void registerQueryController(ParseQueryController controller) {
        if (!this.queryController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another query controller was already registered: " + this.queryController.get());
        }
    }

    public ParseFileController getFileController() {
        if (this.fileController.get() == null) {
            this.fileController.compareAndSet(null, new ParseFileController(ParsePlugins.get().restClient(), Parse.getParseCacheDir("files")));
        }
        return this.fileController.get();
    }

    public void registerFileController(ParseFileController controller) {
        if (!this.fileController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another file controller was already registered: " + this.fileController.get());
        }
    }

    public ParseAnalyticsController getAnalyticsController() {
        if (this.analyticsController.get() == null) {
            this.analyticsController.compareAndSet(null, new ParseAnalyticsController(Parse.getEventuallyQueue()));
        }
        return this.analyticsController.get();
    }

    public void registerAnalyticsController(ParseAnalyticsController controller) {
        if (!this.analyticsController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another analytics controller was already registered: " + this.analyticsController.get());
        }
    }

    public ParseCloudCodeController getCloudCodeController() {
        if (this.cloudCodeController.get() == null) {
            this.cloudCodeController.compareAndSet(null, new ParseCloudCodeController(ParsePlugins.get().restClient()));
        }
        return this.cloudCodeController.get();
    }

    public void registerCloudCodeController(ParseCloudCodeController controller) {
        if (!this.cloudCodeController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another cloud code controller was already registered: " + this.cloudCodeController.get());
        }
    }

    public ParseConfigController getConfigController() {
        if (this.configController.get() == null) {
            ParseCurrentConfigController currentConfigController = new ParseCurrentConfigController(new File(Parse.getParseDir(), CURRENT_CONFIG_FILENAME));
            this.configController.compareAndSet(null, new ParseConfigController(ParsePlugins.get().restClient(), currentConfigController));
        }
        return this.configController.get();
    }

    public void registerConfigController(ParseConfigController controller) {
        if (!this.configController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another config controller was already registered: " + this.configController.get());
        }
    }

    public ParsePushController getPushController() {
        if (this.pushController.get() == null) {
            this.pushController.compareAndSet(null, new ParsePushController(ParsePlugins.get().restClient()));
        }
        return this.pushController.get();
    }

    public void registerPushController(ParsePushController controller) {
        if (!this.pushController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another push controller was already registered: " + this.pushController.get());
        }
    }

    public ParsePushChannelsController getPushChannelsController() {
        if (this.pushChannelsController.get() == null) {
            this.pushChannelsController.compareAndSet(null, new ParsePushChannelsController());
        }
        return this.pushChannelsController.get();
    }

    public void registerPushChannelsController(ParsePushChannelsController controller) {
        if (!this.pushChannelsController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another pushChannels controller was already registered: " + this.pushChannelsController.get());
        }
    }
}

