/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.ConfigCallback;
import com.parse.ParseConfigController;
import com.parse.ParseCorePlugins;
import com.parse.ParseDecoder;
import com.parse.ParseException;
import com.parse.ParseFile;
import com.parse.ParseGeoPoint;
import com.parse.ParseTaskUtils;
import com.parse.ParseUser;
import com.parse.PointerEncoder;
import com.parse.TaskQueue;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class ParseConfig {
    static final TaskQueue taskQueue = new TaskQueue();
    final Map<String, Object> params;

    static ParseConfigController getConfigController() {
        return ParseCorePlugins.getInstance().getConfigController();
    }

    public static ParseConfig getCurrentConfig() {
        try {
            return ParseTaskUtils.wait(ParseConfig.getConfigController().getCurrentConfigController().getCurrentConfigAsync());
        }
        catch (ParseException e) {
            return new ParseConfig();
        }
    }

    public static ParseConfig get() throws ParseException {
        return ParseTaskUtils.wait(ParseConfig.getInBackground());
    }

    public static void getInBackground(ConfigCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseConfig.getInBackground(), callback);
    }

    public static Task<ParseConfig> getInBackground() {
        return taskQueue.enqueue(new Continuation<Void, Task<ParseConfig>>(){

            public Task<ParseConfig> then(Task<Void> toAwait) throws Exception {
                return ParseConfig.getAsync((Task<Void>)toAwait);
            }
        });
    }

    private static Task<ParseConfig> getAsync(final Task<Void> toAwait) {
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<ParseConfig>>(){

            public Task<ParseConfig> then(Task<String> task) throws Exception {
                final String sessionToken = (String)task.getResult();
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<ParseConfig>>(){

                    public Task<ParseConfig> then(Task<Void> task) throws Exception {
                        return ParseConfig.getConfigController().getAsync(sessionToken);
                    }
                });
            }
        });
    }

    ParseConfig(JSONObject object, ParseDecoder decoder) {
        Map decodedObject = (Map)decoder.decode(object);
        Map decodedParams = (Map)decodedObject.get("params");
        if (decodedParams == null) {
            throw new RuntimeException("Object did not contain the 'params' key.");
        }
        this.params = Collections.unmodifiableMap(decodedParams);
    }

    ParseConfig() {
        this.params = Collections.unmodifiableMap(new HashMap());
    }

    Map<String, Object> getParams() {
        return Collections.unmodifiableMap(new HashMap<String, Object>(this.params));
    }

    public Object get(String key) {
        return this.get(key, null);
    }

    public Object get(String key, Object defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == JSONObject.NULL) {
            return null;
        }
        return this.params.get(key);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public Date getDate(String key) {
        return this.getDate(key, null);
    }

    public Date getDate(String key, Date defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof Date ? (Date)value : defaultValue;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        Number number = this.getNumber(key);
        return number != null ? number.doubleValue() : defaultValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        Number number = this.getNumber(key);
        return number != null ? number.intValue() : defaultValue;
    }

    public JSONArray getJSONArray(String key) {
        return this.getJSONArray(key, null);
    }

    public JSONArray getJSONArray(String key, JSONArray defaultValue) {
        List list = this.getList(key);
        Object encoded = list != null ? PointerEncoder.get().encode(list) : null;
        return encoded == null || encoded instanceof JSONArray ? (JSONArray)encoded : defaultValue;
    }

    public JSONObject getJSONObject(String key) {
        return this.getJSONObject(key, null);
    }

    public JSONObject getJSONObject(String key, JSONObject defaultValue) {
        Map map = this.getMap(key);
        Object encoded = map != null ? PointerEncoder.get().encode(map) : null;
        return encoded == null || encoded instanceof JSONObject ? (JSONObject)encoded : defaultValue;
    }

    public <T> List<T> getList(String key) {
        return this.getList(key, null);
    }

    public <T> List<T> getList(String key, List<T> defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        List returnValue = value instanceof List ? (List)value : defaultValue;
        return returnValue;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        Number number = this.getNumber(key);
        return number != null ? number.longValue() : defaultValue;
    }

    public <V> Map<String, V> getMap(String key) {
        return this.getMap(key, null);
    }

    public <V> Map<String, V> getMap(String key, Map<String, V> defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        Map returnValue = value instanceof Map ? (Map)value : defaultValue;
        return returnValue;
    }

    public Number getNumber(String key) {
        return this.getNumber(key, null);
    }

    public Number getNumber(String key, Number defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof Number ? (Number)((Number)value) : (Number)defaultValue;
    }

    public ParseFile getParseFile(String key) {
        return this.getParseFile(key, null);
    }

    public ParseFile getParseFile(String key, ParseFile defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof ParseFile ? (ParseFile)value : defaultValue;
    }

    public ParseGeoPoint getParseGeoPoint(String key) {
        return this.getParseGeoPoint(key, null);
    }

    public ParseGeoPoint getParseGeoPoint(String key, ParseGeoPoint defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof ParseGeoPoint ? (ParseGeoPoint)value : defaultValue;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof String ? (String)value : defaultValue;
    }

    public String toString() {
        return "ParseConfig[" + this.params.toString() + "]";
    }
}

