/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.ParseUser;
import java.util.Map;

abstract class ParseAuthenticationProvider {
    ParseAuthenticationProvider() {
    }

    public abstract String getAuthType();

    public abstract Task<Map<String, String>> authenticateAsync();

    public abstract void deauthenticate();

    public abstract boolean restoreAuthentication(Map<String, String> var1);

    public abstract void cancel();

    public Task<ParseUser> logInAsync() {
        return this.authenticateAsync().onSuccessTask((Continuation)new Continuation<Map<String, String>, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<Map<String, String>> task) throws Exception {
                return ParseAuthenticationProvider.this.logInAsync((Map)task.getResult());
            }
        });
    }

    public Task<ParseUser> logInAsync(Map<String, String> authData) {
        return ParseUser.logInWithAsync(this.getAuthType(), authData);
    }

    public Task<Void> linkAsync(final ParseUser user) {
        return this.authenticateAsync().onSuccessTask((Continuation)new Continuation<Map<String, String>, Task<Void>>(){

            public Task<Void> then(Task<Map<String, String>> task) throws Exception {
                return ParseAuthenticationProvider.this.linkAsync(user, (Map)task.getResult());
            }
        });
    }

    public Task<Void> linkAsync(ParseUser user, Map<String, String> authData) {
        return user.linkWithAsync(this.getAuthType(), authData, user.getSessionToken());
    }

    public Task<Void> unlinkAsync(ParseUser user) {
        return user.unlinkFromAsync(this.getAuthType());
    }

    static interface ParseAuthenticationCallback {
        public void onSuccess(Map<String, String> var1);

        public void onCancel();

        public void onError(Throwable var1);
    }
}

