/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.AnonymousAuthenticationProvider;
import com.parse.LogInCallback;
import com.parse.ParseTaskUtils;
import com.parse.ParseUser;

public final class ParseAnonymousUtils {
    private static AnonymousAuthenticationProvider provider;
    static final String AUTH_TYPE = "anonymous";

    private static AnonymousAuthenticationProvider getProvider() {
        if (provider == null) {
            provider = new AnonymousAuthenticationProvider();
            ParseUser.registerAuthenticationProvider(provider);
        }
        return provider;
    }

    public static boolean isLinked(ParseUser user) {
        return user.isLinked(AUTH_TYPE);
    }

    public static Task<ParseUser> logInInBackground() {
        return ParseAnonymousUtils.getProvider().logInAsync();
    }

    public static void logIn(LogInCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseAnonymousUtils.logInInBackground(), callback);
    }

    static ParseUser lazyLogIn() {
        AnonymousAuthenticationProvider provider = ParseAnonymousUtils.getProvider();
        return ParseUser.logInLazyUser(provider.getAuthType(), provider.getAuthData());
    }

    private ParseAnonymousUtils() {
    }
}

