/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.PLog;
import com.parse.ParseFileUtils;
import com.parse.ParseTextUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;

class InstallationId {
    private static final String TAG = "InstallationId";
    private final Object lock = new Object();
    private final File file;
    private String installationId;

    public InstallationId(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        Object object = this.lock;
        synchronized (object) {
            if (this.installationId == null) {
                try {
                    this.installationId = ParseFileUtils.readFileToString(this.file, "UTF-8");
                }
                catch (FileNotFoundException e) {
                    PLog.i(TAG, "Couldn't find existing installationId file. Creating one instead.");
                }
                catch (IOException e) {
                    PLog.e(TAG, "Unexpected exception reading installation id from disk", e);
                }
            }
            if (this.installationId == null) {
                this.setInternal(UUID.randomUUID().toString());
            }
        }
        return this.installationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String newInstallationId) {
        Object object = this.lock;
        synchronized (object) {
            if (ParseTextUtils.isEmpty(newInstallationId) || newInstallationId.equals(this.get())) {
                return;
            }
            this.setInternal(newInstallationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInternal(String newInstallationId) {
        Object object = this.lock;
        synchronized (object) {
            try {
                ParseFileUtils.writeStringToFile(this.file, newInstallationId, "UTF-8");
            }
            catch (IOException e) {
                PLog.e(TAG, "Unexpected exception writing installation id to disk", e);
            }
            this.installationId = newInstallationId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.installationId = null;
            ParseFileUtils.deleteQuietly(this.file);
        }
    }
}

