/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.AbstractQueryController;
import com.parse.NetworkQueryController;
import com.parse.ParseException;
import com.parse.ParseKeyValueCache;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseRESTQueryCommand;
import com.parse.ParseUser;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

class CacheQueryController
extends AbstractQueryController {
    private final NetworkQueryController networkController;

    public CacheQueryController(NetworkQueryController network) {
        this.networkController = network;
    }

    @Override
    public <T extends ParseObject> Task<List<T>> findAsync(final ParseQuery.State<T> state, ParseUser user, final Task<Void> cancellationToken) {
        final String sessionToken = user != null ? user.getSessionToken() : null;
        CommandDelegate callbacks = new CommandDelegate<List<T>>(){

            @Override
            public Task<List<T>> runOnNetworkAsync(boolean retry) {
                return CacheQueryController.this.networkController.findAsync(state, sessionToken, retry, (Task<Void>)cancellationToken);
            }

            @Override
            public Task<List<T>> runFromCacheAsync() {
                return CacheQueryController.this.findFromCacheAsync(state, sessionToken);
            }
        };
        return this.runCommandWithPolicyAsync(callbacks, state.cachePolicy());
    }

    @Override
    public <T extends ParseObject> Task<Integer> countAsync(final ParseQuery.State<T> state, ParseUser user, final Task<Void> cancellationToken) {
        final String sessionToken = user != null ? user.getSessionToken() : null;
        CommandDelegate<Integer> callbacks = new CommandDelegate<Integer>(){

            @Override
            public Task<Integer> runOnNetworkAsync(boolean retry) {
                return CacheQueryController.this.networkController.countAsync(state, sessionToken, retry, (Task<Void>)cancellationToken);
            }

            @Override
            public Task<Integer> runFromCacheAsync() {
                return CacheQueryController.this.countFromCacheAsync(state, sessionToken);
            }
        };
        return this.runCommandWithPolicyAsync(callbacks, state.cachePolicy());
    }

    private <T extends ParseObject> Task<List<T>> findFromCacheAsync(final ParseQuery.State<T> state, String sessionToken) {
        final String cacheKey = ParseRESTQueryCommand.findCommand(state, sessionToken).getCacheKey();
        return Task.call((Callable)new Callable<List<T>>(){

            @Override
            public List<T> call() throws Exception {
                JSONObject cached = ParseKeyValueCache.jsonFromKeyValueCache(cacheKey, state.maxCacheAge());
                if (cached == null) {
                    throw new ParseException(120, "results not cached");
                }
                try {
                    return CacheQueryController.this.networkController.convertFindResponse(state, cached);
                }
                catch (JSONException e) {
                    throw new ParseException(120, "the cache contains corrupted json");
                }
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    private <T extends ParseObject> Task<Integer> countFromCacheAsync(final ParseQuery.State<T> state, String sessionToken) {
        final String cacheKey = ParseRESTQueryCommand.countCommand(state, sessionToken).getCacheKey();
        return Task.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                JSONObject cached = ParseKeyValueCache.jsonFromKeyValueCache(cacheKey, state.maxCacheAge());
                if (cached == null) {
                    throw new ParseException(120, "results not cached");
                }
                try {
                    return cached.getInt("count");
                }
                catch (JSONException e) {
                    throw new ParseException(120, "the cache contains corrupted json");
                }
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    private <TResult> Task<TResult> runCommandWithPolicyAsync(final CommandDelegate<TResult> c, ParseQuery.CachePolicy policy) {
        switch (policy) {
            case IGNORE_CACHE: 
            case NETWORK_ONLY: {
                return c.runOnNetworkAsync(true);
            }
            case CACHE_ONLY: {
                return c.runFromCacheAsync();
            }
            case CACHE_ELSE_NETWORK: {
                return c.runFromCacheAsync().continueWithTask(new Continuation<TResult, Task<TResult>>(){

                    public Task<TResult> then(Task<TResult> task) throws Exception {
                        if (task.getError() instanceof ParseException) {
                            return c.runOnNetworkAsync(true);
                        }
                        return task;
                    }
                });
            }
            case NETWORK_ELSE_CACHE: {
                return c.runOnNetworkAsync(false).continueWithTask(new Continuation<TResult, Task<TResult>>(){

                    public Task<TResult> then(Task<TResult> task) throws Exception {
                        Exception error = task.getError();
                        if (error instanceof ParseException && ((ParseException)error).getCode() == 100) {
                            return c.runFromCacheAsync();
                        }
                        return task;
                    }
                });
            }
            case CACHE_THEN_NETWORK: {
                throw new RuntimeException("You cannot use the cache policy CACHE_THEN_NETWORK with find()");
            }
        }
        throw new RuntimeException("Unknown cache policy: " + (Object)((Object)policy));
    }

    private static interface CommandDelegate<T> {
        public Task<T> runOnNetworkAsync(boolean var1);

        public Task<T> runFromCacheAsync();
    }
}

