/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Activity;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import bolts.Capture;
import bolts.Continuation;
import bolts.Task;
import com.parse.GcmRegistrar;
import com.parse.ManifestInfo;
import com.parse.PLog;
import com.parse.Parse;
import com.parse.ParseException;
import com.parse.ParseInstallation;
import com.parse.ParseTaskUtils;
import com.parse.PushConnection;
import com.parse.PushRouter;
import com.parse.PushType;
import com.parse.ServiceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class PushService
extends Service {
    private static final String TAG = "com.parse.PushService";
    private static final String START_IF_REQUIRED_ACTION = "com.parse.PushService.startIfRequired";
    private static final int WAKE_LOCK_TIMEOUT_MS = 20000;
    private static String host = "push.parse.com";
    private static int port = 443;
    private static boolean loggedStartError = false;
    private static List<ServiceLifecycleCallbacks> serviceLifecycleCallbacks = null;
    static final String CANNOT_USE_PUSH_V1_ERROR_MESSAGE = "PushService.subscribe, PushService.unsubscribe, and PushService.setDefaultPushCallback methods cannot be used in conjunction with ParsePushBroadcastReceiver. See ParsePush.subscribe and ParsePush.unsubscribe.";
    private PushConnection connection;
    private ExecutorService executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerServiceLifecycleCallbacks(ServiceLifecycleCallbacks callbacks) {
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            if (serviceLifecycleCallbacks == null) {
                serviceLifecycleCallbacks = new ArrayList<ServiceLifecycleCallbacks>();
            }
            serviceLifecycleCallbacks.add(callbacks);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterServiceLifecycleCallbacks(ServiceLifecycleCallbacks callbacks) {
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            serviceLifecycleCallbacks.remove(callbacks);
            if (serviceLifecycleCallbacks.size() <= 0) {
                serviceLifecycleCallbacks = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void dispatchOnServiceCreated(Service service) {
        Object[] callbacks = PushService.collectServiceLifecycleCallbacks();
        if (callbacks != null) {
            for (Object callback : callbacks) {
                ((ServiceLifecycleCallbacks)callback).onServiceCreated(service);
            }
        }
    }

    private static void dispatchOnServiceDestroyed(Service service) {
        Object[] callbacks = PushService.collectServiceLifecycleCallbacks();
        if (callbacks != null) {
            for (Object callback : callbacks) {
                ((ServiceLifecycleCallbacks)callback).onServiceDestroyed(service);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] collectServiceLifecycleCallbacks() {
        Object[] callbacks = null;
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            if (serviceLifecycleCallbacks == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            if (serviceLifecycleCallbacks.size() > 0) {
                callbacks = serviceLifecycleCallbacks.toArray();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return callbacks;
        }
    }

    static void runGcmIntentInService(Context context, Intent intent) {
        ServiceUtils.runWakefulIntentInService(context, intent, PushService.class, 20000L);
    }

    static void stopPpnsService(Context context) {
        if (ManifestInfo.getPushType() == PushType.PPNS) {
            context.stopService(new Intent(context, PushService.class));
        }
    }

    private static void startPpnsServiceIfRequired(Context context) {
        if (ManifestInfo.getPushType() == PushType.PPNS) {
            ParseInstallation installation = ParseInstallation.getCurrentInstallation();
            if (installation.getPushType() == PushType.GCM) {
                PLog.w(TAG, "Detected a client that used to use GCM and is now using PPNS.");
                installation.removePushType();
                installation.removeDeviceToken();
                installation.saveEventually();
            }
            ServiceUtils.runIntentInService(context, new Intent(START_IF_REQUIRED_ACTION), PushService.class);
        }
    }

    public static void startServiceIfRequired(Context context) {
        switch (ManifestInfo.getPushType()) {
            case PPNS: {
                PushService.startPpnsServiceIfRequired(context);
                break;
            }
            case GCM: {
                GcmRegistrar.getInstance().register();
                break;
            }
            default: {
                if (loggedStartError) break;
                PLog.e(TAG, "Tried to use push, but this app is not configured for push due to: " + ManifestInfo.getNonePushTypeLogMessage());
                loggedStartError = true;
            }
        }
    }

    @Deprecated
    public static void subscribe(Context context, String channel, Class<? extends Activity> cls) {
        PushService.subscribe(context, channel, cls, context.getApplicationInfo().icon);
    }

    @Deprecated
    public static synchronized void subscribe(Context context, String channel, Class<? extends Activity> cls, int icon) {
        PushService.checkManifestAndThrowExceptionIfNeeded();
        if (channel == null) {
            throw new IllegalArgumentException("Can't subscribe to null channel.");
        }
        PushRouter.subscribeAsync(channel, cls, icon).onSuccess((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) {
                PushService.startServiceIfRequired(Parse.applicationContext);
                return null;
            }
        });
    }

    @Deprecated
    public static synchronized void unsubscribe(Context context, String channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Can't unsubscribe from null channel.");
        }
        PushService.unsubscribeInternal(channel);
    }

    private static void unsubscribeInternal(String channel) {
        PushService.checkManifestAndThrowExceptionIfNeeded();
        PushRouter.unsubscribeAsync(channel).onSuccessTask((Continuation)new Continuation<Void, Task<Set<String>>>(){

            public Task<Set<String>> then(Task<Void> task) {
                return PushRouter.getSubscriptionsAsync(true);
            }
        }).onSuccess((Continuation)new Continuation<Set<String>, Void>(){

            public Void then(Task<Set<String>> task) {
                if (((Set)task.getResult()).size() == 0) {
                    PushService.stopPpnsService(Parse.applicationContext);
                }
                return null;
            }
        });
    }

    @Deprecated
    public static void setDefaultPushCallback(Context context, Class<? extends Activity> cls) {
        PushService.setDefaultPushCallback(context, cls, context.getApplicationInfo().icon);
    }

    @Deprecated
    public static void setDefaultPushCallback(Context context, Class<? extends Activity> cls, int icon) {
        if (icon == 0) {
            throw new IllegalArgumentException("Must subscribe to channel with a valid icon identifier.");
        }
        if (cls == null) {
            PushService.unsubscribeInternal(null);
        } else {
            PushRouter.subscribeAsync(null, cls, icon).onSuccess((Continuation)new Continuation<Void, Void>(){

                public Void then(Task<Void> task) {
                    PushService.startServiceIfRequired(Parse.applicationContext);
                    return null;
                }
            });
        }
    }

    private static void checkManifestAndThrowExceptionIfNeeded() {
        if (ManifestInfo.getPushUsesBroadcastReceivers()) {
            throw new IllegalStateException(CANNOT_USE_PUSH_V1_ERROR_MESSAGE);
        }
    }

    @Deprecated
    public static Set<String> getSubscriptions(Context context) {
        try {
            return ParseTaskUtils.wait(PushRouter.getSubscriptionsAsync(false));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static void useServer(String theHost, int thePort) {
        host = theHost;
        port = thePort;
    }

    public void onCreate() {
        super.onCreate();
        if (Parse.applicationContext == null) {
            PLog.e(TAG, "The Parse push service cannot start because Parse.initialize has not yet been called. If you call Parse.initialize from an Activity's onCreate, that call should instead be in the Application.onCreate. Be sure your Application class is registered in your AndroidManifest.xml with the android:name property of your <application> tag.");
            this.stopSelf();
            return;
        }
        switch (ManifestInfo.getPushType()) {
            case PPNS: {
                this.connection = new PushConnection(this, host, port);
                break;
            }
            case GCM: {
                this.executor = Executors.newSingleThreadExecutor();
                break;
            }
            default: {
                PLog.e(TAG, "PushService somehow started even though this device doesn't support push.");
            }
        }
        PushService.dispatchOnServiceCreated(this);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.wipeRoutingAndUpgradePushStateIfNeeded();
        switch (ManifestInfo.getPushType()) {
            case PPNS: {
                return this.onPpnsStartCommand(intent, flags, startId);
            }
            case GCM: {
                return this.onGcmStartCommand(intent, flags, startId);
            }
        }
        PLog.e(TAG, "Started push service even though no push service is enabled: " + intent);
        ServiceUtils.completeWakefulIntent(intent);
        return 2;
    }

    private void wipeRoutingAndUpgradePushStateIfNeeded() {
        if (ManifestInfo.getPushUsesBroadcastReceivers()) {
            PushRouter.wipeRoutingAndUpgradePushStateAsync();
        }
    }

    private int onPpnsStartCommand(Intent intent, int flags, int startId) {
        final PushConnection conn = this.connection;
        if (intent == null || intent.getAction() == null || intent.getAction().equals(START_IF_REQUIRED_ACTION)) {
            PLog.i(TAG, "Received request to start service if required");
            final Capture forceEnabledCapture = new Capture();
            PushRouter.getForceEnabledStateAsync().onSuccessTask((Continuation)new Continuation<Boolean, Task<Set<String>>>(){

                public Task<Set<String>> then(Task<Boolean> task) throws Exception {
                    forceEnabledCapture.set(task.getResult());
                    return PushRouter.getSubscriptionsAsync(true);
                }
            }).onSuccess((Continuation)new Continuation<Set<String>, Void>(){

                public Void then(Task<Set<String>> task) throws Exception {
                    Boolean forceEnabled = (Boolean)forceEnabledCapture.get();
                    boolean isPushV2 = ManifestInfo.getPushUsesBroadcastReceivers();
                    Set subscriptions = (Set)task.getResult();
                    String error = null;
                    if (!isPushV2) {
                        if (subscriptions != null && subscriptions.size() == 0) {
                            error = "Not starting PushService because this device has no subscriptions";
                        }
                    } else if (ParseInstallation.getCurrentInstallation().getObjectId() == null) {
                        error = "Not starting PushService because this device is not registered for push notifications.";
                    } else if (forceEnabled != null && !forceEnabled.booleanValue()) {
                        error = "Not starting PushService because push has been manually disabled.";
                    }
                    if (error != null) {
                        PLog.i(PushService.TAG, error);
                        PushService.this.stopSelf();
                    } else {
                        PLog.d(PushService.TAG, "Starting PushService.");
                        conn.start();
                    }
                    return null;
                }
            });
        }
        return 1;
    }

    private int onGcmStartCommand(final Intent intent, int flags, final int startId) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    PushService.this.onHandleGcmIntent(intent);
                }
                finally {
                    ServiceUtils.completeWakefulIntent(intent);
                    PushService.this.stopSelf(startId);
                }
            }
        });
        return 2;
    }

    private void onHandleGcmIntent(Intent intent) {
        if (intent != null) {
            GcmRegistrar registrar = GcmRegistrar.getInstance();
            if (registrar.isRegistrationIntent(intent)) {
                registrar.handleRegistrationIntent(intent);
            } else if (PushRouter.isGcmPushIntent(intent)) {
                PushRouter.handleGcmPushIntent(intent);
            } else {
                PLog.e(TAG, "PushService got unknown intent in GCM mode: " + intent);
            }
        }
    }

    public IBinder onBind(Intent intent) {
        throw new IllegalArgumentException("You cannot bind directly to the PushService. Use PushService.subscribe instead.");
    }

    public void onDestroy() {
        if (this.connection != null) {
            this.connection.stop();
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
        PushService.dispatchOnServiceDestroyed(this);
        super.onDestroy();
    }

    static interface ServiceLifecycleCallbacks {
        public void onServiceCreated(Service var1);

        public void onServiceDestroyed(Service var1);
    }
}

