/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseDecoder;
import com.parse.ParseEncoder;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseRelationOperation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseRelation<T extends ParseObject> {
    private final Object mutex = new Object();
    private ParseObject parent;
    private String key;
    private String targetClass;
    private Set<ParseObject> knownObjects = new HashSet<ParseObject>();

    ParseRelation(ParseObject parent, String key) {
        this.parent = parent;
        this.key = key;
        this.targetClass = null;
    }

    ParseRelation(String targetClass) {
        this.parent = null;
        this.key = null;
        this.targetClass = targetClass;
    }

    ParseRelation(JSONObject jsonObject, ParseDecoder decoder) {
        this.parent = null;
        this.targetClass = jsonObject.optString("className", null);
        this.key = null;
        JSONArray objectsArray = jsonObject.optJSONArray("objects");
        if (objectsArray != null) {
            for (int i = 0; i < objectsArray.length(); ++i) {
                this.knownObjects.add((ParseObject)decoder.decode(objectsArray.optJSONObject(i)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureParentAndKey(ParseObject someParent, String someKey) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.parent == null) {
                this.parent = someParent;
            }
            if (this.key == null) {
                this.key = someKey;
            }
            if (this.parent != someParent) {
                throw new IllegalStateException("Internal error. One ParseRelation retrieved from two different ParseObjects.");
            }
            if (!this.key.equals(someKey)) {
                throw new IllegalStateException("Internal error. One ParseRelation retrieved from two different keys.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            ParseRelationOperation<T> operation = new ParseRelationOperation<T>(Collections.singleton(object), null);
            this.targetClass = operation.getTargetClass();
            this.parent.performOperation(this.key, operation);
            this.knownObjects.add((ParseObject)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            ParseRelationOperation<T> operation = new ParseRelationOperation<T>(null, Collections.singleton(object));
            this.targetClass = operation.getTargetClass();
            this.parent.performOperation(this.key, operation);
            this.knownObjects.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParseQuery<T> getQuery() {
        Object object = this.mutex;
        synchronized (object) {
            ParseQuery.State.Builder builder = this.targetClass == null ? new ParseQuery.State.Builder(this.parent.getClassName()).redirectClassNameForKey(this.key) : new ParseQuery.State.Builder(this.targetClass);
            builder.whereRelatedTo(this.parent, this.key);
            return new ParseQuery(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject encodeToJSON(ParseEncoder objectEncoder) throws JSONException {
        Object object = this.mutex;
        synchronized (object) {
            JSONObject relation = new JSONObject();
            relation.put("__type", (Object)"Relation");
            relation.put("className", (Object)this.targetClass);
            JSONArray knownObjectsArray = new JSONArray();
            for (ParseObject knownObject : this.knownObjects) {
                try {
                    knownObjectsArray.put((Object)objectEncoder.encodeRelatedObject(knownObject));
                }
                catch (Exception e) {}
            }
            relation.put("objects", (Object)knownObjectsArray);
            return relation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getTargetClass() {
        Object object = this.mutex;
        synchronized (object) {
            return this.targetClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTargetClass(String className) {
        Object object = this.mutex;
        synchronized (object) {
            this.targetClass = className;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addKnownObject(ParseObject object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            this.knownObjects.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeKnownObject(ParseObject object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            this.knownObjects.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasKnownObject(ParseObject object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            return this.knownObjects.contains(object);
        }
    }
}

